"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from polar_sdk import models, utils
from polar_sdk._hooks import HookContext
from polar_sdk.types import BaseModel, OptionalNullable, UNSET
from polar_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union, cast


class Seats(BaseSDK):
    def list_seats(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsListSeatsSecurity,
            models.CustomerPortalSeatsListSeatsSecurityTypedDict,
        ],
        subscription_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SeatsList:
        r"""List Seats

        **Scopes**: `customer_portal:read` `customer_portal:write`

        :param security:
        :param subscription_id: Subscription ID
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsListSeatsRequest(
            subscription_id=subscription_id,
        )

        req = self._build_request(
            method="GET",
            path="/v1/customer-portal/seats",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsListSeatsSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:list_seats",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SeatsList, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["401", "403", "404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def list_seats_async(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsListSeatsSecurity,
            models.CustomerPortalSeatsListSeatsSecurityTypedDict,
        ],
        subscription_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SeatsList:
        r"""List Seats

        **Scopes**: `customer_portal:read` `customer_portal:write`

        :param security:
        :param subscription_id: Subscription ID
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsListSeatsRequest(
            subscription_id=subscription_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/customer-portal/seats",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsListSeatsSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:list_seats",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SeatsList, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["401", "403", "404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    def assign_seat(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsAssignSeatSecurity,
            models.CustomerPortalSeatsAssignSeatSecurityTypedDict,
        ],
        request: Union[models.SeatAssign, models.SeatAssignTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Assign Seat

        **Scopes**: `customer_portal:write`

        :param security:
        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.SeatAssign)
        request = cast(models.SeatAssign, request)

        req = self._build_request(
            method="POST",
            path="/v1/customer-portal/seats",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsAssignSeatSecurity
            ),
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SeatAssign
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:assign_seat",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["400", "401", "403", "404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def assign_seat_async(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsAssignSeatSecurity,
            models.CustomerPortalSeatsAssignSeatSecurityTypedDict,
        ],
        request: Union[models.SeatAssign, models.SeatAssignTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Assign Seat

        **Scopes**: `customer_portal:write`

        :param security:
        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.SeatAssign)
        request = cast(models.SeatAssign, request)

        req = self._build_request_async(
            method="POST",
            path="/v1/customer-portal/seats",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsAssignSeatSecurity
            ),
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SeatAssign
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:assign_seat",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["400", "401", "403", "404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    def revoke_seat(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsRevokeSeatSecurity,
            models.CustomerPortalSeatsRevokeSeatSecurityTypedDict,
        ],
        seat_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Revoke Seat

        **Scopes**: `customer_portal:write`

        :param security:
        :param seat_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsRevokeSeatRequest(
            seat_id=seat_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v1/customer-portal/seats/{seat_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsRevokeSeatSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:revoke_seat",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["401", "403", "404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def revoke_seat_async(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsRevokeSeatSecurity,
            models.CustomerPortalSeatsRevokeSeatSecurityTypedDict,
        ],
        seat_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Revoke Seat

        **Scopes**: `customer_portal:write`

        :param security:
        :param seat_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsRevokeSeatRequest(
            seat_id=seat_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v1/customer-portal/seats/{seat_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsRevokeSeatSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:revoke_seat",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["401", "403", "404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    def resend_invitation(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsResendInvitationSecurity,
            models.CustomerPortalSeatsResendInvitationSecurityTypedDict,
        ],
        seat_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Resend Invitation

        **Scopes**: `customer_portal:write`

        :param security:
        :param seat_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsResendInvitationRequest(
            seat_id=seat_id,
        )

        req = self._build_request(
            method="POST",
            path="/v1/customer-portal/seats/{seat_id}/resend",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsResendInvitationSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:resend_invitation",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["400", "401", "403", "404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def resend_invitation_async(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsResendInvitationSecurity,
            models.CustomerPortalSeatsResendInvitationSecurityTypedDict,
        ],
        seat_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CustomerSeat:
        r"""Resend Invitation

        **Scopes**: `customer_portal:write`

        :param security:
        :param seat_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CustomerPortalSeatsResendInvitationRequest(
            seat_id=seat_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/customer-portal/seats/{seat_id}/resend",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsResendInvitationSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:resend_invitation",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CustomerSeat, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                models.HTTPValidationErrorData, http_res
            )
            raise models.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, ["400", "401", "403", "404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    def list_claimed_subscriptions(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsListClaimedSubscriptionsSecurity,
            models.CustomerPortalSeatsListClaimedSubscriptionsSecurityTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.CustomerSubscription]:
        r"""List Claimed Subscriptions

        List all subscriptions where the authenticated customer has claimed a seat.

        **Scopes**: `customer_portal:read` `customer_portal:write`

        :param security:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        req = self._build_request(
            method="GET",
            path="/v1/customer-portal/seats/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=None,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsListClaimedSubscriptionsSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:list_claimed_subscriptions",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(List[models.CustomerSubscription], http_res)
        if utils.match_response(http_res, ["401", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)

    async def list_claimed_subscriptions_async(
        self,
        *,
        security: Union[
            models.CustomerPortalSeatsListClaimedSubscriptionsSecurity,
            models.CustomerPortalSeatsListClaimedSubscriptionsSecurityTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.CustomerSubscription]:
        r"""List Claimed Subscriptions

        List all subscriptions where the authenticated customer has claimed a seat.

        **Scopes**: `customer_portal:read` `customer_portal:write`

        :param security:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)
        req = self._build_request_async(
            method="GET",
            path="/v1/customer-portal/seats/subscriptions",
            base_url=base_url,
            url_variables=url_variables,
            request=None,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=utils.get_pydantic_model(
                security, models.CustomerPortalSeatsListClaimedSubscriptionsSecurity
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="customer_portal:seats:list_claimed_subscriptions",
                oauth2_scopes=None,
                security_source=security,
            ),
            request=req,
            error_status_codes=["401", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(List[models.CustomerSubscription], http_res)
        if utils.match_response(http_res, ["401", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)

        raise models.SDKError("Unexpected response received", http_res)
