(function(){"use strict";RB.UploadDiffModel=Backbone.Model.extend({defaults:{basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,repository:null,reviewRequest:null,state:0},State:{PROMPT_FOR_DIFF:0,PROMPT_FOR_BASEDIR:1,PROPMT_FOR_CHANGE_NUMBER:2,PROCESSING_DIFF:3,UPLOADING:4,PROMPT_FOR_PARENT_DIFF:5,ERROR:6},initialize(){Backbone.Model.prototype.initialize.apply(this,arguments);this.on("change:diffFile change:parentDiffFile change:basedir "+"change:changeNumber change:diffValid",this._updateState,this)},startOver(){this.set({basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,state:this.State.PROMPT_FOR_DIFF})},handleFiles(files){switch(this.get("state")){case this.State.PROMPT_FOR_DIFF:this.set("diffFile",files[0]);break;case this.State.PROMPT_FOR_PARENT_DIFF:this.set("parentDiffFile",files[0]);break;default:console.assert("File received in wrong state");break}},_updateState(){const basedir=this.get("basedir");const changeNumber=this.get("changeNumber");const diff=this.get("diffFile");const diffValid=this.get("diffValid");const parentDiff=this.get("parentDiffFile");const repository=this.get("repository");const requiresBasedir=repository.get("requiresBasedir");const requiresChangeNumber=repository.get("requiresChangeNumber");const state=this.get("state");switch(state){case this.State.PROMPT_FOR_DIFF:if(diff){if(requiresBasedir&&!basedir){this.set("state",this.State.PROMPT_FOR_BASEDIR)}else if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_PARENT_DIFF:if(diff&&parentDiff){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROMPT_FOR_BASEDIR:console.assert(diff,"cannot be in basedir prompt state without a diff");if(basedir){if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_CHANGE_NUMBER:console.assert(diff,"cannot be in changenum prompt state without a diff");if(changeNumber){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROCESSING_DIFF:if(diffValid){this.set("state",this.State.UPLOADING);if(this.get("reviewRequest")===null){this._createReviewRequest()}else{this._createDiff()}}break;case this.State.UPLOADING:break;case this.State.ERROR:break}},_tryValidate(){this.set("diffValid",false);const diff=this.get("diffFile");console.assert(diff);const parentDiff=this.get("parentDiffFile");const repository=this.get("repository");const uploader=new RB.ValidateDiffModel;uploader.set({repository:repository.get("id"),localSitePrefix:repository.get("localSitePrefix"),basedir:this.get("basedir"),diff:diff,parentDiff:parentDiff});uploader.save({success:_.bind(this._onValidateSuccess,this),error:_.bind(this._onValidateError,this)})},_onValidateSuccess(){this.set("diffValid",true)},_onValidateError(model,xhr){const rsp=$.parseJSON(xhr.responseText);let newState=this.State.ERROR;let error;if(rsp!==null){switch(rsp.err.code){case RB.APIErrors.REPO_FILE_NOT_FOUND:if(this.get("repository").get("scmtoolName")==="Git"&&rsp.revision.length!==40){error=gettext("The uploaded diff uses short revisions, but Review Board requires full revisions.<br />Please generate a new diff using the <code>--full-index</code> parameter.")}else{error=interpolate(gettext('The file "%(file)s" (revision %(revision)s) was not found in the repository.'),{file:rsp.file,revision:rsp.revision},true);if(this.get("parentDiffFile")===null){newState=this.State.PROMPT_FOR_PARENT_DIFF}}break;case RB.APIErrors.DIFF_PARSE_ERROR:error=interpolate(gettext("%(error)s<br />Line %(line)s: %(reason)s"),{error:rsp.err.msg,line:rsp.linenum,reason:rsp.reason},true);break;default:error=rsp.err.msg;break}}else{error=gettext("Unknown error")}if(error){this.set({state:newState,error:error})}},_createReviewRequest(){const repository=this.get("repository");const reviewRequest=new RB.ReviewRequest({commitID:this.get("changeNumber"),localSitePrefix:repository.get("localSitePrefix"),repository:repository.get("id")});reviewRequest.save({success:()=>{this.set("reviewRequest",reviewRequest);this._createDiff()},error:this._onValidateError.bind(this)})},_createDiff(){const reviewRequest=this.get("reviewRequest");const diff=reviewRequest.createDiff();diff.set({basedir:this.get("basedir"),diff:this.get("diffFile"),parentDiff:this.get("parentDiffFile")});diff.url=reviewRequest.get("links").diffs.href;diff.save({success:()=>{window.location=reviewRequest.get("reviewURL")},error:this._onValidateError.bind(this)})}});"use strict";RB.PostCommitModel=Backbone.Model.extend({defaults:{branch:null,repository:null}});"use strict";RB.NewReviewRequest=RB.Page.extend({defaults(){return _.defaults(_.result(RB.Page.prototype.defaults),{repositories:null})},parse(rsp){return _.extend(RB.Page.prototype.parse.call(this,rsp),{repositories:new RB.RepositoryCollection(null,{repositories:rsp.repositories.map(repository=>new RB.Repository(repository)),localSitePrefix:rsp.localSitePrefix})})}});"use strict";RB.RepositoryCollection=RB.BaseCollection.extend({model:RB.Repository,initialize(models,options){this.collection=new RB.ResourceCollection(options.repositories,{extraQueryData:{},model:this.model});this.collection._fetchURL=SITE_ROOT+options.localSitePrefix+"api/repositories/";this._fileAttachmentRepo=new RB.Repository({name:gettext("(None - File attachments only)"),scmtoolName:"",localSitePrefix:options.localSitePrefix,supportsPostCommit:false,filesOnly:true});this.listenTo(this.collection,"add",this.add);this.listenTo(this.collection,"remove",this.remove);this.listenTo(this.collection,"reset",this._rebuild);this._rebuild()},_rebuild(){this.reset([this._fileAttachmentRepo].concat(this.collection.models))},search(query){this.collection.extraQueryData.q=query;this.collection.fetch({success:()=>this._rebuild()})}});"use strict";RB.UploadDiffView=Backbone.View.extend({events:{"dragenter .dnd":"_onDragEnter","dragover .dnd":"_onDragOver","dragleave .dnd":"_onDragLeave","drop .dnd":"_onDrop","submit #basedir-form":"_onBasedirSubmit","submit #changenum-form":"_onChangenumSubmit","click .startover":"_onStartOverClicked","click #select-diff-file":"_onSelectFileClicked","click #select-parent-diff-file":"_onSelectFileClicked"},initialize(){this.listenTo(this.model,"change:state",this._onStateChanged);this.listenTo(this.model,"change:error",this._onErrorChanged)},render(){let selectDiffText;let selectParentDiffText;if(this._canDragDrop()){selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> or drag and drop a diff file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> or drag and drop a parent diff file if you have one')}else{selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> a file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> a parent diff file if you have one')}this.$el.html(this.template({pendingChangeHeader:gettext("Create from a local change"),tipHeader:gettext("Tip:"),tip:gettext('Use <tt>rbt post</tt> from <a href="https://www.reviewboard.org/downloads/rbtools/">RBTools</a> to more easily create and update review requests.'),selectDiff:selectDiffText,selectParentDiff:selectParentDiffText,baseDir:gettext("What is the base directory for this diff?"),changeNum:gettext("What is the change number for this diff?"),startOver:gettext("Start Over"),ok:gettext("OK")}));this._$fileInput=$('<input type="file">').hide().appendTo(this.$el).change(()=>this.model.handleFiles(this._$fileInput.get(0).files));this._$diffRevisionError=this.$("#parent-diff-error-contents");this._$error=this.$("#error-indicator").hide();this._$errorContents=this.$("#error-contents");this._$processingDiff=this.$("#processing-diff").hide();this._$promptForBasedir=this.$("#prompt-for-basedir").hide();this._$promptForChangeNumber=this.$("#prompt-for-change-number").hide();this._$promptForDiff=this.$("#prompt-for-diff").hide();this._$promptForParentDiff=this.$("#prompt-for-parent-diff").hide();this._$uploading=this.$("#uploading-diffs").hide();this._onStateChanged(this.model,this.model.get("state"));return this},_canDragDrop(){return("draggable"in this.el||"ondragstart"in this.el&&"ondrop"in this.el)&&!navigator.userAgent.match("iPhone OS")&&!navigator.userAgent.match("iPad")},_onErrorChanged(model,error){const errorHTML='<div class="rb-icon rb-icon-warning"></div> '.concat(error);this._$errorContents.html(errorHTML);this._$diffRevisionError.html(errorHTML);const innerHeight=this._$errorContents.height();const outerHeight=this._$error.height();this._$errorContents.css({top:Math.floor((outerHeight-innerHeight)/2)+"px"})},_onStateChanged(model,state){this._$promptForDiff.setVisible(state===this.model.State.PROMPT_FOR_DIFF);this._$promptForParentDiff.setVisible(state===this.model.State.PROMPT_FOR_PARENT_DIFF);this._$promptForBasedir.setVisible(state===this.model.State.PROMPT_FOR_BASEDIR);this._$processingDiff.setVisible(state===this.model.State.PROCESSING_DIFF);this._$promptForChangeNumber.setVisible(state===this.model.State.PROMPT_FOR_CHANGE_NUMBER);this._$uploading.setVisible(state===this.model.State.UPLOADING);this._$error.setVisible(state===this.model.State.ERROR)},_onDragEnter(event){event.stopPropagation();event.preventDefault();this.$(".dnd").addClass("drag-hover")},_onDragOver(event){event.stopPropagation();event.preventDefault();const dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="copy"}},_onDragLeave(event){event.stopPropagation();event.preventDefault();this.$(".dnd").removeClass("drag-hover");const dt=event.originalEvent.dataTransfer;if(dt){dt.dropEffect="none"}},_onDrop(event){event.stopPropagation();event.preventDefault();const dt=event.originalEvent.dataTransfer;const files=dt&&dt.files;if(files){this.model.handleFiles(files)}},_onBasedirSubmit(event){event.stopPropagation();event.preventDefault();const basedir=this.$("#basedir-input").val();if(basedir){this.model.set("basedir",basedir)}},_onChangenumSubmit(){const changenum=this.$("#changenum-input").val();if(changenum){this.model.set("changeNumber",changenum)}},_onStartOverClicked(){const $input=this._$fileInput.clone(true);this._$fileInput.replaceWith($input);this._$fileInput=$input;this.model.startOver()},_onSelectFileClicked(){this._$fileInput.click()}});"use strict";RB.BranchView=Backbone.View.extend({tagName:"option",render(){this.$el.text(this.model.get("name")).attr("selected",this.model.get("isDefault"));return this}});"use strict";RB.BranchesView=RB.CollectionView.extend({tagName:"select",itemViewType:RB.BranchView,events:{change:"_onChange"},render:function(){RB.CollectionView.prototype.render.apply(this,arguments);this.collection.each(branch=>{if(branch.get("isDefault")){this.trigger("selected",branch)}});return this},_onAdded(branch){RB.CollectionView.prototype._onAdded.apply(this,arguments);if(this._rendered&&branch.get("isDefault")){this.trigger("selected",branch)}},_onChange(){const selectedIx=this.$el.prop("selectedIndex");this.trigger("selected",this.collection.models[selectedIx])}});"use strict";RB.CommitView=Backbone.View.extend({className:"commit",template:_.template('<div class="progress">\n <span class="fa fa-spinner fa-pulse"></span>\n</div>\n<% if (accessible) { %>\n <div class="summary">\n  <% if (reviewRequestURL) { %>\n   <span class="fa fa-arrow-circle-right jump-to-commit"/>\n  <% } %>\n  <%- summary %>\n </div>\n<% } %>\n<div class="commit-info">\n <span class="revision">\n  <span class="fa fa-code-fork"></span>\n  <%- revision %>\n  <% if (!accessible) { %>\n   <%- RB.CommitView.strings.COMMIT_NOT_ACCESSIBLE %>\n  <% } %>\n </span>\n <% if (accessible && author) { %>\n  <span class="author">\n   <span class="fa fa-user"></span>\n   <%- author %>\n  </span>\n <% } %>\n <% if (date) { %>\n  <span class="time">\n   <span class="fa fa-clock-o"></span>\n   <time class="timesince" datetime="<%- date %>"></time>\n  </span>\n <% } %>\n</div>'),_dialogBodyTemplate:_.template("<p><%- prefixText %></p>\n<p><code><%- commitID %>: <%- summary %></code></p>\n<p><%- suffixText %></p>"),events:{click:"_onClick"},render:function(){if(!this.model.get("accessible")){this.$el.addClass("disabled")}let commitID=this.model.get("id");if(commitID.length===40){commitID=commitID.slice(0,7)}if(this.model.get("reviewRequestURL")){this.$el.addClass("has-review-request")}const date=this.model.get("date");this.$el.html(this.template(_.defaults({revision:commitID,author:this.model.get("authorName")||gettext("<unknown>"),date:date?date.toISOString():null},this.model.attributes)));if(date){this.$(".timesince").timesince()}return this},_onClick(){let commitID=this.model.get("id");if(commitID.length>7){commitID=commitID.slice(0,7)}const dialogView=new RB.DialogView({title:gettext("Create Review Request?"),body:this._dialogBodyTemplate({prefixText:gettext("You are creating a new review request from the following published commit:"),commitID:commitID,summary:this.model.get("summary"),suffixText:gettext("Are you sure you want to continue?")}),buttons:[{id:"cancel",label:gettext("Cancel")},{id:"create",label:gettext("Create Review Request"),primary:true,onClick:this._createReviewRequest.bind(this)}]});dialogView.show()},_createReviewRequest(){if(this.model.get("accessible")){const url=this.model.get("reviewRequestURL");if(url){window.location=url}else{this.model.trigger("create",this.model)}}},showProgress(){this.$(".progress").show()},cancelProgress(){this.$(".progress").hide()}},{strings:{COMMIT_NOT_ACCESSIBLE:gettext("(not accessible on this repository)")}});"use strict";RB.CommitsView=RB.CollectionView.extend({className:"commits",itemViewType:RB.CommitView,initialize(options){RB.CollectionView.prototype.initialize.call(this,options);this._$scrollContainer=options.$scrollContainer;this._fetchingCommits=false},render(){RB.CollectionView.prototype.render.call(this);this._$scrollContainer.scroll(this.checkFetchNext.bind(this));return this},setPending(commit){this.views.forEach(view=>{if(view.model===commit){view.showProgress()}else{view.cancelProgress()}})},cancelPending(){this.views.forEach(view=>view.cancelProgress())},checkFetchNext(){if(this._fetchingCommits){return}const collection=this.collection;const scrollContainerEl=this._$scrollContainer[0];const scrollThresholdPx=50;if(collection.canFetchNext()&&scrollContainerEl.scrollTop+scrollContainerEl.offsetHeight>scrollContainerEl.scrollHeight-scrollThresholdPx){this._fetchingCommits=true;collection.fetchNext({success:()=>{this._fetchingCommits=false;if(collection.canFetchNext()){this.checkFetchNext()}},error:(collection,xhr)=>{this._fetchingCommits=false;this.trigger("loadError",xhr)}})}}});"use strict";RB.RepositoryView=Backbone.View.extend({tagName:"li",className:"rb-c-sidebar__nav-item repository",template:_.template('<span class="rb-c-sidebar__item-label"><%- name %></span>'),events:{click:"_onClick"},render(){this.$el.html(this.template(this.model.attributes));return this},_onClick(){this.model.trigger("selected",this.model)}});"use strict";RB.RepositorySelectionView=RB.CollectionView.extend({tagName:"ul",className:"rb-c-sidebar__items repository-selector",itemViewType:RB.RepositoryView,template:_.template('<li class="rb-c-sidebar__section -no-icons">\n <header class="rb-c-sidebar__section-header">\n  <%- repositoriesLabel %>\n </header>\n <ul class="rb-c-sidebar__items">\n  <li class="rb-c-sidebar__item">\n   <div class="rb-c-sidebar__item-label">\n    <div class="rb-c-search-field">\n     <span class="fa fa-search"></span>\n     <input class="rb-c-search-field__input"\n            placeholder="<%- filterLabel %>" />\n    </div>\n   </div>\n  </li>\n </ul>\n <ul class="rb-c-sidebar__items\n            rb-c-new-review-request__repository-items">\n</li>'),events:{"input .rb-c-search-field__input":"_onSearchChanged"},initialize(){RB.CollectionView.prototype.initialize.apply(this,arguments);this._selected=null;this._searchActive=false;this._onSearchChanged=_.throttle(this._onSearchChanged.bind(this),100);this.listenTo(this.collection,"selected",this._onRepositorySelected)},render(){this.$el.html(this.template({repositoriesLabel:gettext("Repositories"),filterLabel:gettext("Filter")}));this.$container=this.$(".rb-c-new-review-request__repository-items");this._$searchBox=this.$(".rb-c-search-field__input");RB.CollectionView.prototype.render.apply(this,arguments);return this},unselect(){this.views.forEach(view=>{if(view.model===this._selected){view.$el.removeClass("active")}});this._selected=null;this.trigger("selected",null)},_onRepositorySelected(item){this._selected=item;this.views.forEach(view=>{if(view.model===item){view.$el.addClass("-is-active")}else{view.$el.removeClass("-is-active")}});this.trigger("selected",item)},_onSearchChanged(){const searchTerm=this._$searchBox.val().toLowerCase();console.log("search",searchTerm);this.collection.search(searchTerm)}});"use strict";RB.PostCommitView=Backbone.View.extend({className:"post-commit",loadErrorTemplate:_.template('<div class="error">\n <p><%- errorLoadingText %></p>\n <p class="error-text">\n  <% _.each(errorLines, function(line) { %><%- line %><br /><% }); %>\n </p>\n <p>\n  <%- temporaryFailureText %>\n  <a href="#" id="reload_<%- reloadID %>"><%- tryAgainText %></a>\n </p>\n</div>'),events:{"click #reload_branches":"_loadBranches","click #reload_commits":"_loadCommits"},initialize(options){const model=this.model;const repository=model.get("repository");const branches=repository.branches;this._$scrollContainer=options.$scrollContainer;this._$error=null;this._branchesView=new RB.BranchesView({collection:branches});this._branchesView.on("selected",branch=>model.set("branch",branch));this.listenTo(model,"change:branch",this._onBranchChanged);if(!branches.loaded){this._loadBranches()}},render(){this._rendered=true;$("<div/>").addClass("branches section-header").append($("<span/>").text(gettext("Create from an existing commit on:"))).append(this._branchesView.render().el).appendTo(this.$el);if(this._commitsView){this.$el.append(this._commitsView.render().el)}return this},_loadBranches(){this._clearLoadError();const branches=this.model.get("repository").branches;branches.fetch({success:()=>{branches.loaded=true;this._branchesView.$el.show();if(this._commitsView){this._commitsView.$el.show()}},error:(collection,xhr)=>{this._branchesView.$el.hide();if(this._commitsView){this._commitsView.$el.hide()}this._showLoadError("branches",xhr)}})},_loadCommits(){this._clearLoadError();this._commitsCollection.fetch({success:()=>{this._commitsView.$el.show();this._commitsView.checkFetchNext()},error:(collection,xhr)=>{this._commitsView.$el.hide();this._showLoadError("commits",xhr)}})},_clearLoadError(){if(this._$error){this._$error.remove();this._$error=null}},_showLoadError(reloadID,xhr){this._clearLoadError();this._$error=$(this.loadErrorTemplate({errorLoadingText:gettext("There was an error loading information from this repository:"),temporaryFailureText:gettext("This may be a temporary failure."),tryAgainText:gettext("Try again"),errorLines:xhr.errorText.split("\n"),reloadID:reloadID})).appendTo(this.$el)},_onBranchChanged(model,branch){if(this._commitsView){this.stopListening(this._commitsCollection);this._commitsView.remove()}this._commitsCollection=this.model.get("repository").getCommits({branch:branch.id,start:branch.get("commit")});this.listenTo(this._commitsCollection,"create",this._onCreateReviewRequest);this._commitsView=new RB.CommitsView({collection:this._commitsCollection,$scrollContainer:this._$scrollContainer});this.listenTo(this._commitsView,"loadError",xhr=>{this._showLoadError("commits",xhr)});if(this._rendered){this.$el.append(this._commitsView.render().el)}this._loadCommits()},_onCreateReviewRequest(commit){if(this._createPending){return}this._createPending=true;this._commitsView.setPending(commit);const repository=this.model.get("repository");const reviewRequest=new RB.ReviewRequest({repository:repository.id,localSitePrefix:repository.get("localSitePrefix")});reviewRequest.createFromCommit({commitID:commit.id,success:()=>{window.location=reviewRequest.get("reviewURL")},error:(model,xhr)=>{this._commitsView.setPending(null);this._createPending=false;alert(xhr.errorText)}})}});"use strict";RB.PreCommitView=RB.UploadDiffView.extend({className:"pre-commit",template:_.template('<div class="section-header"><%- pendingChangeHeader %></div>\n<div class="tip">\n <strong><%- tipHeader %></strong>\n <%= tip %>\n</div>\n<div class="input dnd" id="prompt-for-diff">\n <form>\n  <%= selectDiff %>\n </form>\n</div>\n<div class="input dnd" id="prompt-for-parent-diff">\n <form>\n  <div id="parent-diff-error-contents" />\n  <%= selectParentDiff %>\n </form>\n <a href="#" class="startover"><%- startOver %></a>\n</div>\n<div class="input" id="prompt-for-basedir">\n <form id="basedir-form">\n  <%- baseDir %>\n  <input id="basedir-input" />\n  <input type="submit" value="<%- ok %>" />\n </form>\n <a href="#" class="startover"><%- startOver %></a>\n</div>\n<div class="input" id="prompt-for-change-number">\n <form id="changenum-form">\n  <%- changeNum %>\n  <input type="number" step="1" id="changenum-input" />\n  <input type="submit" value="<%- ok %>" />\n </form>\n <a href="#" class="startover"><%- startOver %></a>\n</div>\n<div class="input" id="processing-diff">\n <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>\n</div>\n<div class="input" id="uploading-diffs">\n <div><span class="fa fa-spinner fa-pulse"></div>\n</div>\n<div class="input" id="error-indicator">\n <div id="error-contents" />\n <a href="#" class="startover"><%- startOver %></a>\n</div>')});"use strict";(function(){const FilesOnlyPreCommitModel=Backbone.Model.extend({defaults:_.defaults({repository:null})});const FilesOnlyPreCommitView=Backbone.View.extend({className:"files-only",template:_.template('<p><%- description %></p>\n<input type="submit" class="primary large" id="files-only-create"\n       value="<%- buttonText %>" />'),events:{"click #files-only-create":"_onCreateClicked"},render(){this.$el.html(this.template({description:gettext("You won't be able to add any diffs to this review request. The review request will only be usable for reviewing graphics, screenshots and file attachments."),buttonText:gettext("Create Review Request")}));return this},_onCreateClicked(ev){ev.preventDefault();ev.stopPropagation();const repository=this.model.get("repository");const reviewRequest=new RB.ReviewRequest({localSitePrefix:repository.get("localSitePrefix")});reviewRequest.save({success:()=>{window.location=reviewRequest.get("reviewURL")},error:()=>{}})}});RB.NewReviewRequestView=RB.PageView.extend({el:"#new-review-request",template:_.template('<div class="rb-c-new-review-request">\n <div class="rb-c-sidebar -no-icons"></div>\n <div class="rb-c-new-review-request__repo-pane">\n  <a href="#" class="rb-c-new-review-request__show-repositories">\n   <span class="fa fa-chevron-left"></span>\n   <%- repositoriesLabel %>\n  </a>\n  <div class="rb-c-new-review-request__repo-detail">\n   <div class="rb-c-new-review-request__main">\n    <div class="rb-c-new-review-request__hint"><%- hint %></div>\n   </div>\n  </div>\n </div>\n</div>'),events:{"click .rb-c-new-review-request__show-repositories":"_onShowRepositoriesClicked"},renderPage(){this.$pageContent.html(this.template({hint:gettext("Select a repository"),repositoriesLabel:gettext("Repositories")}));this._$newReviewRequestContainer=this.$pageContent.find(".rb-c-new-review-request");this._$repoPane=this.$pageContent.find(".rb-c-new-review-request__repo-pane");this._$repoDetailContainer=this._$repoPane.find(".rb-c-new-review-request__repo-detail");this._$repoSelectorContainer=this._$newReviewRequestContainer.find(".rb-c-sidebar");this._$content=this._$repoDetailContainer.find(".rb-c-new-review-request__main");this._$hint=this._$repoDetailContainer.find(".rb-c-new-review-request__hint");this._repositorySelectionView=new RB.RepositorySelectionView({collection:this.model.get("repositories")});this._repositorySelectionView.render();this.listenTo(this._repositorySelectionView,"selected",repository=>this.model.set("repository",repository));this.listenTo(this.model,"change:repository",this._onRepositoryChanged);if(this._preCommitView){this._$hint.hide();this._$content.append(this._preCommitView.render().el)}if(this._postCommitView){this._$hint.hide();this._$content.append(this._postCommitView.render().el)}const repositories=this.model.get("repositories").models;if(repositories.length===2){repositories[1].trigger("selected",repositories[1])}return this},onMobileModeChanged(inMobileMode){this._repositorySelectionView.$el.detach().appendTo(inMobileMode?this._$repoSelectorContainer:this.$mainSidebar)},_onRepositoryChanged(){const repository=this.model.get("repository");if(repository===null){this._$newReviewRequestContainer.removeClass("js-repository-selected");if(this.inMobileMode){_.delay(this._removeCommitViews.bind(this),400)}else{this._removeCommitViews()}}else{this._$newReviewRequestContainer.addClass("js-repository-selected");this._removeCommitViews();if(repository.get("filesOnly")){this._preCommitView=new FilesOnlyPreCommitView({model:new FilesOnlyPreCommitModel({repository:repository})})}else{this._preCommitView=new RB.PreCommitView({model:new RB.UploadDiffModel({repository:repository})});if(repository.get("supportsPostCommit")){this._postCommitView=new RB.PostCommitView({model:new RB.PostCommitModel({repository:repository}),$scrollContainer:this._$content})}}this._$hint.hide();this._$content.append(this._preCommitView.render().el);if(this._postCommitView){this._$content.append(this._postCommitView.render().el)}}},_removeCommitViews(){if(this._preCommitView){this._preCommitView.remove();this._preCommitView=null}if(this._postCommitView){this._postCommitView.remove();this._postCommitView=null}},_onShowRepositoriesClicked(){this._repositorySelectionView.unselect()}})})()}).call(this);
