# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, Dict, Mapping, cast
from typing_extensions import Self, Literal, override

import httpx

from . import _exceptions
from ._qs import Querystring
from ._types import (
    Omit,
    Timeout,
    NotGiven,
    Transport,
    ProxiesTypes,
    RequestOptions,
    not_given,
)
from ._utils import is_given, get_async_library
from ._version import __version__
from .resources import orders, wallet, merchants
from ._streaming import Stream as Stream, AsyncStream as AsyncStream
from ._exceptions import HenrySDKError, APIStatusError
from ._base_client import (
    DEFAULT_MAX_RETRIES,
    SyncAPIClient,
    AsyncAPIClient,
)
from .resources.cart import cart
from .resources.checkout import checkout
from .resources.products import products

__all__ = [
    "ENVIRONMENTS",
    "Timeout",
    "Transport",
    "ProxiesTypes",
    "RequestOptions",
    "HenrySDK",
    "AsyncHenrySDK",
    "Client",
    "AsyncClient",
]

ENVIRONMENTS: Dict[str, str] = {
    "production": "https://api.henrylabs.ai/v0",
    "sandbox": "https://api.sandbox.henrylabs.ai/v0",
}


class HenrySDK(SyncAPIClient):
    products: products.ProductsResource
    cart: cart.CartResource
    checkout: checkout.CheckoutResource
    orders: orders.OrdersResource
    wallet: wallet.WalletResource
    merchants: merchants.MerchantsResource
    with_raw_response: HenrySDKWithRawResponse
    with_streaming_response: HenrySDKWithStreamedResponse

    # client options
    api_key: str
    access_token: str

    _environment: Literal["production", "sandbox"] | NotGiven

    def __init__(
        self,
        *,
        api_key: str | None = None,
        access_token: str | None = None,
        environment: Literal["production", "sandbox"] | NotGiven = not_given,
        base_url: str | httpx.URL | None | NotGiven = not_given,
        timeout: float | Timeout | None | NotGiven = not_given,
        max_retries: int = DEFAULT_MAX_RETRIES,
        default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        # Configure a custom httpx client.
        # We provide a `DefaultHttpxClient` class that you can pass to retain the default values we use for `limits`, `timeout` & `follow_redirects`.
        # See the [httpx documentation](https://www.python-httpx.org/api/#client) for more details.
        http_client: httpx.Client | None = None,
        # Enable or disable schema validation for data returned by the API.
        # When enabled an error APIResponseValidationError is raised
        # if the API responds with invalid data for the expected schema.
        #
        # This parameter may be removed or changed in the future.
        # If you rely on this feature, please open a GitHub issue
        # outlining your use-case to help us decide if it should be
        # part of our public interface in the future.
        _strict_response_validation: bool = False,
    ) -> None:
        """Construct a new synchronous HenrySDK client instance.

        This automatically infers the following arguments from their corresponding environment variables if they are not provided:
        - `api_key` from `HENRY_SDK_API_KEY`
        - `access_token` from `HENRY_SDK_ACCESS_TOKEN`
        """
        if api_key is None:
            api_key = os.environ.get("HENRY_SDK_API_KEY")
        if api_key is None:
            raise HenrySDKError(
                "The api_key client option must be set either by passing api_key to the client or by setting the HENRY_SDK_API_KEY environment variable"
            )
        self.api_key = api_key

        if access_token is None:
            access_token = os.environ.get("HENRY_SDK_ACCESS_TOKEN")
        if access_token is None:
            raise HenrySDKError(
                "The access_token client option must be set either by passing access_token to the client or by setting the HENRY_SDK_ACCESS_TOKEN environment variable"
            )
        self.access_token = access_token

        self._environment = environment

        base_url_env = os.environ.get("HENRY_SDK_BASE_URL")
        if is_given(base_url) and base_url is not None:
            # cast required because mypy doesn't understand the type narrowing
            base_url = cast("str | httpx.URL", base_url)  # pyright: ignore[reportUnnecessaryCast]
        elif is_given(environment):
            if base_url_env and base_url is not None:
                raise ValueError(
                    "Ambiguous URL; The `HENRY_SDK_BASE_URL` env var and the `environment` argument are given. If you want to use the environment, you must pass base_url=None",
                )

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc
        elif base_url_env is not None:
            base_url = base_url_env
        else:
            self._environment = environment = "production"

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc

        super().__init__(
            version=__version__,
            base_url=base_url,
            max_retries=max_retries,
            timeout=timeout,
            http_client=http_client,
            custom_headers=default_headers,
            custom_query=default_query,
            _strict_response_validation=_strict_response_validation,
        )

        self.products = products.ProductsResource(self)
        self.cart = cart.CartResource(self)
        self.checkout = checkout.CheckoutResource(self)
        self.orders = orders.OrdersResource(self)
        self.wallet = wallet.WalletResource(self)
        self.merchants = merchants.MerchantsResource(self)
        self.with_raw_response = HenrySDKWithRawResponse(self)
        self.with_streaming_response = HenrySDKWithStreamedResponse(self)

    @property
    @override
    def qs(self) -> Querystring:
        return Querystring(array_format="comma")

    @property
    @override
    def auth_headers(self) -> dict[str, str]:
        return {**self._api_key_auth, **self._access_token_auth}

    @property
    def _api_key_auth(self) -> dict[str, str]:
        api_key = self.api_key
        return {"x-api-key": api_key}

    @property
    def _access_token_auth(self) -> dict[str, str]:
        access_token = self.access_token
        return {"x-access-token": access_token}

    @property
    @override
    def default_headers(self) -> dict[str, str | Omit]:
        return {
            **super().default_headers,
            "X-Stainless-Async": "false",
            **self._custom_headers,
        }

    def copy(
        self,
        *,
        api_key: str | None = None,
        access_token: str | None = None,
        environment: Literal["production", "sandbox"] | None = None,
        base_url: str | httpx.URL | None = None,
        timeout: float | Timeout | None | NotGiven = not_given,
        http_client: httpx.Client | None = None,
        max_retries: int | NotGiven = not_given,
        default_headers: Mapping[str, str] | None = None,
        set_default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        set_default_query: Mapping[str, object] | None = None,
        _extra_kwargs: Mapping[str, Any] = {},
    ) -> Self:
        """
        Create a new client instance re-using the same options given to the current client with optional overriding.
        """
        if default_headers is not None and set_default_headers is not None:
            raise ValueError("The `default_headers` and `set_default_headers` arguments are mutually exclusive")

        if default_query is not None and set_default_query is not None:
            raise ValueError("The `default_query` and `set_default_query` arguments are mutually exclusive")

        headers = self._custom_headers
        if default_headers is not None:
            headers = {**headers, **default_headers}
        elif set_default_headers is not None:
            headers = set_default_headers

        params = self._custom_query
        if default_query is not None:
            params = {**params, **default_query}
        elif set_default_query is not None:
            params = set_default_query

        http_client = http_client or self._client
        return self.__class__(
            api_key=api_key or self.api_key,
            access_token=access_token or self.access_token,
            base_url=base_url or self.base_url,
            environment=environment or self._environment,
            timeout=self.timeout if isinstance(timeout, NotGiven) else timeout,
            http_client=http_client,
            max_retries=max_retries if is_given(max_retries) else self.max_retries,
            default_headers=headers,
            default_query=params,
            **_extra_kwargs,
        )

    # Alias for `copy` for nicer inline usage, e.g.
    # client.with_options(timeout=10).foo.create(...)
    with_options = copy

    @override
    def _make_status_error(
        self,
        err_msg: str,
        *,
        body: object,
        response: httpx.Response,
    ) -> APIStatusError:
        if response.status_code == 400:
            return _exceptions.BadRequestError(err_msg, response=response, body=body)

        if response.status_code == 401:
            return _exceptions.AuthenticationError(err_msg, response=response, body=body)

        if response.status_code == 403:
            return _exceptions.PermissionDeniedError(err_msg, response=response, body=body)

        if response.status_code == 404:
            return _exceptions.NotFoundError(err_msg, response=response, body=body)

        if response.status_code == 409:
            return _exceptions.ConflictError(err_msg, response=response, body=body)

        if response.status_code == 422:
            return _exceptions.UnprocessableEntityError(err_msg, response=response, body=body)

        if response.status_code == 429:
            return _exceptions.RateLimitError(err_msg, response=response, body=body)

        if response.status_code >= 500:
            return _exceptions.InternalServerError(err_msg, response=response, body=body)
        return APIStatusError(err_msg, response=response, body=body)


class AsyncHenrySDK(AsyncAPIClient):
    products: products.AsyncProductsResource
    cart: cart.AsyncCartResource
    checkout: checkout.AsyncCheckoutResource
    orders: orders.AsyncOrdersResource
    wallet: wallet.AsyncWalletResource
    merchants: merchants.AsyncMerchantsResource
    with_raw_response: AsyncHenrySDKWithRawResponse
    with_streaming_response: AsyncHenrySDKWithStreamedResponse

    # client options
    api_key: str
    access_token: str

    _environment: Literal["production", "sandbox"] | NotGiven

    def __init__(
        self,
        *,
        api_key: str | None = None,
        access_token: str | None = None,
        environment: Literal["production", "sandbox"] | NotGiven = not_given,
        base_url: str | httpx.URL | None | NotGiven = not_given,
        timeout: float | Timeout | None | NotGiven = not_given,
        max_retries: int = DEFAULT_MAX_RETRIES,
        default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        # Configure a custom httpx client.
        # We provide a `DefaultAsyncHttpxClient` class that you can pass to retain the default values we use for `limits`, `timeout` & `follow_redirects`.
        # See the [httpx documentation](https://www.python-httpx.org/api/#asyncclient) for more details.
        http_client: httpx.AsyncClient | None = None,
        # Enable or disable schema validation for data returned by the API.
        # When enabled an error APIResponseValidationError is raised
        # if the API responds with invalid data for the expected schema.
        #
        # This parameter may be removed or changed in the future.
        # If you rely on this feature, please open a GitHub issue
        # outlining your use-case to help us decide if it should be
        # part of our public interface in the future.
        _strict_response_validation: bool = False,
    ) -> None:
        """Construct a new async AsyncHenrySDK client instance.

        This automatically infers the following arguments from their corresponding environment variables if they are not provided:
        - `api_key` from `HENRY_SDK_API_KEY`
        - `access_token` from `HENRY_SDK_ACCESS_TOKEN`
        """
        if api_key is None:
            api_key = os.environ.get("HENRY_SDK_API_KEY")
        if api_key is None:
            raise HenrySDKError(
                "The api_key client option must be set either by passing api_key to the client or by setting the HENRY_SDK_API_KEY environment variable"
            )
        self.api_key = api_key

        if access_token is None:
            access_token = os.environ.get("HENRY_SDK_ACCESS_TOKEN")
        if access_token is None:
            raise HenrySDKError(
                "The access_token client option must be set either by passing access_token to the client or by setting the HENRY_SDK_ACCESS_TOKEN environment variable"
            )
        self.access_token = access_token

        self._environment = environment

        base_url_env = os.environ.get("HENRY_SDK_BASE_URL")
        if is_given(base_url) and base_url is not None:
            # cast required because mypy doesn't understand the type narrowing
            base_url = cast("str | httpx.URL", base_url)  # pyright: ignore[reportUnnecessaryCast]
        elif is_given(environment):
            if base_url_env and base_url is not None:
                raise ValueError(
                    "Ambiguous URL; The `HENRY_SDK_BASE_URL` env var and the `environment` argument are given. If you want to use the environment, you must pass base_url=None",
                )

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc
        elif base_url_env is not None:
            base_url = base_url_env
        else:
            self._environment = environment = "production"

            try:
                base_url = ENVIRONMENTS[environment]
            except KeyError as exc:
                raise ValueError(f"Unknown environment: {environment}") from exc

        super().__init__(
            version=__version__,
            base_url=base_url,
            max_retries=max_retries,
            timeout=timeout,
            http_client=http_client,
            custom_headers=default_headers,
            custom_query=default_query,
            _strict_response_validation=_strict_response_validation,
        )

        self.products = products.AsyncProductsResource(self)
        self.cart = cart.AsyncCartResource(self)
        self.checkout = checkout.AsyncCheckoutResource(self)
        self.orders = orders.AsyncOrdersResource(self)
        self.wallet = wallet.AsyncWalletResource(self)
        self.merchants = merchants.AsyncMerchantsResource(self)
        self.with_raw_response = AsyncHenrySDKWithRawResponse(self)
        self.with_streaming_response = AsyncHenrySDKWithStreamedResponse(self)

    @property
    @override
    def qs(self) -> Querystring:
        return Querystring(array_format="comma")

    @property
    @override
    def auth_headers(self) -> dict[str, str]:
        return {**self._api_key_auth, **self._access_token_auth}

    @property
    def _api_key_auth(self) -> dict[str, str]:
        api_key = self.api_key
        return {"x-api-key": api_key}

    @property
    def _access_token_auth(self) -> dict[str, str]:
        access_token = self.access_token
        return {"x-access-token": access_token}

    @property
    @override
    def default_headers(self) -> dict[str, str | Omit]:
        return {
            **super().default_headers,
            "X-Stainless-Async": f"async:{get_async_library()}",
            **self._custom_headers,
        }

    def copy(
        self,
        *,
        api_key: str | None = None,
        access_token: str | None = None,
        environment: Literal["production", "sandbox"] | None = None,
        base_url: str | httpx.URL | None = None,
        timeout: float | Timeout | None | NotGiven = not_given,
        http_client: httpx.AsyncClient | None = None,
        max_retries: int | NotGiven = not_given,
        default_headers: Mapping[str, str] | None = None,
        set_default_headers: Mapping[str, str] | None = None,
        default_query: Mapping[str, object] | None = None,
        set_default_query: Mapping[str, object] | None = None,
        _extra_kwargs: Mapping[str, Any] = {},
    ) -> Self:
        """
        Create a new client instance re-using the same options given to the current client with optional overriding.
        """
        if default_headers is not None and set_default_headers is not None:
            raise ValueError("The `default_headers` and `set_default_headers` arguments are mutually exclusive")

        if default_query is not None and set_default_query is not None:
            raise ValueError("The `default_query` and `set_default_query` arguments are mutually exclusive")

        headers = self._custom_headers
        if default_headers is not None:
            headers = {**headers, **default_headers}
        elif set_default_headers is not None:
            headers = set_default_headers

        params = self._custom_query
        if default_query is not None:
            params = {**params, **default_query}
        elif set_default_query is not None:
            params = set_default_query

        http_client = http_client or self._client
        return self.__class__(
            api_key=api_key or self.api_key,
            access_token=access_token or self.access_token,
            base_url=base_url or self.base_url,
            environment=environment or self._environment,
            timeout=self.timeout if isinstance(timeout, NotGiven) else timeout,
            http_client=http_client,
            max_retries=max_retries if is_given(max_retries) else self.max_retries,
            default_headers=headers,
            default_query=params,
            **_extra_kwargs,
        )

    # Alias for `copy` for nicer inline usage, e.g.
    # client.with_options(timeout=10).foo.create(...)
    with_options = copy

    @override
    def _make_status_error(
        self,
        err_msg: str,
        *,
        body: object,
        response: httpx.Response,
    ) -> APIStatusError:
        if response.status_code == 400:
            return _exceptions.BadRequestError(err_msg, response=response, body=body)

        if response.status_code == 401:
            return _exceptions.AuthenticationError(err_msg, response=response, body=body)

        if response.status_code == 403:
            return _exceptions.PermissionDeniedError(err_msg, response=response, body=body)

        if response.status_code == 404:
            return _exceptions.NotFoundError(err_msg, response=response, body=body)

        if response.status_code == 409:
            return _exceptions.ConflictError(err_msg, response=response, body=body)

        if response.status_code == 422:
            return _exceptions.UnprocessableEntityError(err_msg, response=response, body=body)

        if response.status_code == 429:
            return _exceptions.RateLimitError(err_msg, response=response, body=body)

        if response.status_code >= 500:
            return _exceptions.InternalServerError(err_msg, response=response, body=body)
        return APIStatusError(err_msg, response=response, body=body)


class HenrySDKWithRawResponse:
    def __init__(self, client: HenrySDK) -> None:
        self.products = products.ProductsResourceWithRawResponse(client.products)
        self.cart = cart.CartResourceWithRawResponse(client.cart)
        self.checkout = checkout.CheckoutResourceWithRawResponse(client.checkout)
        self.orders = orders.OrdersResourceWithRawResponse(client.orders)
        self.wallet = wallet.WalletResourceWithRawResponse(client.wallet)
        self.merchants = merchants.MerchantsResourceWithRawResponse(client.merchants)


class AsyncHenrySDKWithRawResponse:
    def __init__(self, client: AsyncHenrySDK) -> None:
        self.products = products.AsyncProductsResourceWithRawResponse(client.products)
        self.cart = cart.AsyncCartResourceWithRawResponse(client.cart)
        self.checkout = checkout.AsyncCheckoutResourceWithRawResponse(client.checkout)
        self.orders = orders.AsyncOrdersResourceWithRawResponse(client.orders)
        self.wallet = wallet.AsyncWalletResourceWithRawResponse(client.wallet)
        self.merchants = merchants.AsyncMerchantsResourceWithRawResponse(client.merchants)


class HenrySDKWithStreamedResponse:
    def __init__(self, client: HenrySDK) -> None:
        self.products = products.ProductsResourceWithStreamingResponse(client.products)
        self.cart = cart.CartResourceWithStreamingResponse(client.cart)
        self.checkout = checkout.CheckoutResourceWithStreamingResponse(client.checkout)
        self.orders = orders.OrdersResourceWithStreamingResponse(client.orders)
        self.wallet = wallet.WalletResourceWithStreamingResponse(client.wallet)
        self.merchants = merchants.MerchantsResourceWithStreamingResponse(client.merchants)


class AsyncHenrySDKWithStreamedResponse:
    def __init__(self, client: AsyncHenrySDK) -> None:
        self.products = products.AsyncProductsResourceWithStreamingResponse(client.products)
        self.cart = cart.AsyncCartResourceWithStreamingResponse(client.cart)
        self.checkout = checkout.AsyncCheckoutResourceWithStreamingResponse(client.checkout)
        self.orders = orders.AsyncOrdersResourceWithStreamingResponse(client.orders)
        self.wallet = wallet.AsyncWalletResourceWithStreamingResponse(client.wallet)
        self.merchants = merchants.AsyncMerchantsResourceWithStreamingResponse(client.merchants)


Client = HenrySDK

AsyncClient = AsyncHenrySDK
