# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountLoginsResult',
    'AwaitableGetAccountLoginsResult',
    'get_account_logins',
    'get_account_logins_output',
]

@pulumi.output_type
class GetAccountLoginsResult:
    """
    A collection of values returned by getAccountLogins.
    """
    def __init__(__self__, filters=None, id=None, logins=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logins and not isinstance(logins, list):
            raise TypeError("Expected argument 'logins' to be a list")
        pulumi.set(__self__, "logins", logins)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAccountLoginsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique ID of this login object.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def logins(self) -> Optional[Sequence['outputs.GetAccountLoginsLoginResult']]:
        return pulumi.get(self, "logins")


class AwaitableGetAccountLoginsResult(GetAccountLoginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountLoginsResult(
            filters=self.filters,
            id=self.id,
            logins=self.logins)


def get_account_logins(filters: Optional[Sequence[Union['GetAccountLoginsFilterArgs', 'GetAccountLoginsFilterArgsDict']]] = None,
                       logins: Optional[Sequence[Union['GetAccountLoginsLoginArgs', 'GetAccountLoginsLoginArgsDict']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountLoginsResult:
    """
    Provides information about Linode account logins that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-account-logins).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode account login.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_account_logins = linode.get_account_logins(filters=[
        {
            "name": "restricted",
            "values": ["true"],
        },
        {
            "name": "username",
            "values": ["myUsername"],
        },
    ])
    pulumi.export("loginIds", [__item.id for __item in filtered_account_logins.logins])
    ```

    ## Filterable Fields

    * `ip`

    * `restricted`

    * `username`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['logins'] = logins
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getAccountLogins:getAccountLogins', __args__, opts=opts, typ=GetAccountLoginsResult).value

    return AwaitableGetAccountLoginsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        logins=pulumi.get(__ret__, 'logins'))
def get_account_logins_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAccountLoginsFilterArgs', 'GetAccountLoginsFilterArgsDict']]]]] = None,
                              logins: Optional[pulumi.Input[Optional[Sequence[Union['GetAccountLoginsLoginArgs', 'GetAccountLoginsLoginArgsDict']]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountLoginsResult]:
    """
    Provides information about Linode account logins that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-account-logins).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode account login.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_account_logins = linode.get_account_logins(filters=[
        {
            "name": "restricted",
            "values": ["true"],
        },
        {
            "name": "username",
            "values": ["myUsername"],
        },
    ])
    pulumi.export("loginIds", [__item.id for __item in filtered_account_logins.logins])
    ```

    ## Filterable Fields

    * `ip`

    * `restricted`

    * `username`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['logins'] = logins
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getAccountLogins:getAccountLogins', __args__, opts=opts, typ=GetAccountLoginsResult)
    return __ret__.apply(lambda __response__: GetAccountLoginsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        logins=pulumi.get(__response__, 'logins')))
