# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcSubnetsResult',
    'AwaitableGetVpcSubnetsResult',
    'get_vpc_subnets',
    'get_vpc_subnets_output',
]

@pulumi.output_type
class GetVpcSubnetsResult:
    """
    A collection of values returned by getVpcSubnets.
    """
    def __init__(__self__, filters=None, id=None, vpc_id=None, vpc_subnets=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if vpc_id and not isinstance(vpc_id, int):
            raise TypeError("Expected argument 'vpc_id' to be a int")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_subnets and not isinstance(vpc_subnets, list):
            raise TypeError("Expected argument 'vpc_subnets' to be a list")
        pulumi.set(__self__, "vpc_subnets", vpc_subnets)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcSubnetsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique id of the VPC subnet.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.int:
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcSubnets")
    def vpc_subnets(self) -> Optional[Sequence['outputs.GetVpcSubnetsVpcSubnetResult']]:
        return pulumi.get(self, "vpc_subnets")


class AwaitableGetVpcSubnetsResult(GetVpcSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcSubnetsResult(
            filters=self.filters,
            id=self.id,
            vpc_id=self.vpc_id,
            vpc_subnets=self.vpc_subnets)


def get_vpc_subnets(filters: Optional[Sequence[Union['GetVpcSubnetsFilterArgs', 'GetVpcSubnetsFilterArgsDict']]] = None,
                    vpc_id: Optional[_builtins.int] = None,
                    vpc_subnets: Optional[Sequence[Union['GetVpcSubnetsVpcSubnetArgs', 'GetVpcSubnetsVpcSubnetArgsDict']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcSubnetsResult:
    """
    Provides information about a list of Linode VPC subnets that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpc-subnets).

    ## Example Usage

    The following example shows how one might use this data source to list VPC subnets.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_subnets = linode.get_vpc_subnets(vpc_id=123,
        filters=[{
            "name": "label",
            "values": ["test"],
        }])
    pulumi.export("vpcSubnets", filtered_subnets.vpc_subnets)
    ```

    ## Filterable Fields

    * `id`

    * `label`

    * `ipv4`


    :param _builtins.int vpc_id: The id of the parent VPC for the list of VPCs.
           
           * `filter` - (Optional) A set of filters used to select Linode VPC subnets that meet certain requirements.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vpcId'] = vpc_id
    __args__['vpcSubnets'] = vpc_subnets
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getVpcSubnets:getVpcSubnets', __args__, opts=opts, typ=GetVpcSubnetsResult).value

    return AwaitableGetVpcSubnetsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_subnets=pulumi.get(__ret__, 'vpc_subnets'))
def get_vpc_subnets_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcSubnetsFilterArgs', 'GetVpcSubnetsFilterArgsDict']]]]] = None,
                           vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                           vpc_subnets: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcSubnetsVpcSubnetArgs', 'GetVpcSubnetsVpcSubnetArgsDict']]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcSubnetsResult]:
    """
    Provides information about a list of Linode VPC subnets that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpc-subnets).

    ## Example Usage

    The following example shows how one might use this data source to list VPC subnets.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_subnets = linode.get_vpc_subnets(vpc_id=123,
        filters=[{
            "name": "label",
            "values": ["test"],
        }])
    pulumi.export("vpcSubnets", filtered_subnets.vpc_subnets)
    ```

    ## Filterable Fields

    * `id`

    * `label`

    * `ipv4`


    :param _builtins.int vpc_id: The id of the parent VPC for the list of VPCs.
           
           * `filter` - (Optional) A set of filters used to select Linode VPC subnets that meet certain requirements.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vpcId'] = vpc_id
    __args__['vpcSubnets'] = vpc_subnets
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getVpcSubnets:getVpcSubnets', __args__, opts=opts, typ=GetVpcSubnetsResult)
    return __ret__.apply(lambda __response__: GetVpcSubnetsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpc_subnets=pulumi.get(__response__, 'vpc_subnets')))
