# Generated by ariadne-codegen
# Source: http://localhost:8000/graphql/

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ChartMetric,
    ChartType,
    CustomMetricReviewType,
    DateFilterEnum,
    RunResultSortField,
    RunReviewStatusEnum,
    RunReviewTableSortField,
    RunStatus,
    SortOrder,
    TemplateType,
    TestResultCheckErrorEnum,
    TestResultReviewSortField,
    TestResultReviewStatusEnum,
    TestSuiteSortField,
)


class CustomMetricFilterOptions(BaseModel):
    archived: bool
    limit: int
    offset: int
    project_id: Optional[str] = Field(alias="projectId", default=None)


class CustomOperatorFilterOptions(BaseModel):
    archived: Optional[bool] = None
    limit: int
    offset: int
    project_id: Optional[str] = Field(alias="projectId", default=None)


class ResolveApiKeysFilterOptions(BaseModel):
    limit: int
    offset: int
    associated_users: Optional[List[str]] = Field(alias="associatedUsers", default=None)
    older_than: DateFilterEnum = Field(alias="olderThan")


class HumanReviewTemplateFilterOptionsInput(BaseModel):
    limit: Optional[int] = None
    offset: Optional[int] = None
    archived: Optional[bool] = None
    comparative: Optional[bool] = None
    project_id: Optional[str] = Field(alias="projectId", default=None)


class RunReviewTableFilterOptionsInput(BaseModel):
    limit: int
    offset: int
    search: Optional[str] = None
    sort_by: Optional[RunReviewTableSortField] = Field(alias="sortBy", default=None)
    sort_order: Optional[SortOrder] = Field(alias="sortOrder", default=None)
    status: Optional[RunReviewStatusEnum] = None
    project_id: Optional[str] = Field(alias="projectId", default=None)


class TestReviewFilterOptionsInput(BaseModel):
    limit: int
    offset: int
    search: Optional[str] = None
    sort_by: Optional[TestResultReviewSortField] = Field(alias="sortBy", default=None)
    sort_order: Optional[SortOrder] = Field(alias="sortOrder", default=None)
    status: Optional[TestResultReviewStatusEnum] = None


class RunResultFilterOptionsInput(BaseModel):
    project_id: str = Field(alias="projectId")
    limit: Optional[int] = None
    offset: Optional[int] = None
    search: Optional[str] = None
    status: Optional[List[Optional[RunStatus]]] = None
    archived: Optional[bool] = None
    run_by: Optional[List[str]] = Field(alias="runBy", default=None)
    models_under_test: Optional[List[str]] = Field(
        alias="modelsUnderTest", default=None
    )
    suite_id: Optional[str] = Field(alias="suiteId", default=None)
    suite_ids: Optional[List[str]] = Field(alias="suiteIds", default=None)
    sort_by: Optional[RunResultSortField] = Field(alias="sortBy", default=None)
    sort_order: Optional[SortOrder] = Field(alias="sortOrder", default=None)
    tags: Optional[List[Optional[str]]] = None
    check_error: Optional[TestResultCheckErrorEnum] = Field(
        alias="checkError", default=None
    )


class TestResultFilterOptions(BaseModel):
    search: Optional[str] = None
    tags: Optional[List[Optional[str]]] = None
    check_error: Optional[TestResultCheckErrorEnum] = Field(
        alias="checkError", default=None
    )
    offset: Optional[int] = None
    limit: Optional[int] = None


class QuestionAnswerPairsFilterOptions(BaseModel):
    search: Optional[str] = None
    tags: Optional[List[Optional[str]]] = None
    offset: Optional[int] = None
    limit: Optional[int] = None


class FilterOptionsInput(BaseModel):
    limit: Optional[int] = None
    offset: Optional[int] = None
    search: Optional[str] = None
    folder_id: Optional[str] = Field(alias="folderId", default=None)
    test_suite_id: Optional[str] = Field(alias="testSuiteId", default=None)
    sort_by: Optional[TestSuiteSortField] = Field(alias="sortBy", default=None)
    sort_order: Optional[SortOrder] = Field(alias="sortOrder", default=None)
    project_id: Optional[str] = Field(alias="projectId", default=None)


class TestFilterOptions(BaseModel):
    search: Optional[str] = None
    tags: Optional[List[Optional[str]]] = None
    offset: Optional[int] = None
    limit: Optional[int] = None


class ProjectsWithCountFilterType(BaseModel):
    search: str
    archived: bool
    offset: int
    limit: int


class CheckInputType(BaseModel):
    operator: str
    criteria: Optional[str] = None
    modifiers: Optional["CheckModifiersInputType"] = None


class CheckModifiersInputType(BaseModel):
    optional: bool
    severity: Optional[float] = None
    display_metrics: bool = Field(alias="displayMetrics")
    examples: List["ExampleInputType"]
    extractor: Optional[str] = None
    conditional: Optional["ConditionalCheckInputType"] = None
    category: Optional[str] = None


class ExampleInputType(BaseModel):
    type: str
    text: str


class ConditionalCheckInputType(BaseModel):
    operator: str
    criteria: str


class TestMutationInfo(BaseModel):
    test_suite_id: str = Field(alias="testSuiteId")
    test_id: str = Field(alias="testId")
    input_under_test: str = Field(alias="inputUnderTest")
    checks: List["CheckInputType"]
    golden_output: Optional[str] = Field(alias="goldenOutput", default=None)
    file_ids: Optional[List[Optional[str]]] = Field(alias="fileIds", default=None)
    context: Optional[str] = None
    typed_context: Optional[Any] = Field(alias="typedContext", default=None)
    tags: Optional[List[Optional[str]]] = None


class ParameterInputType(BaseModel):
    eval_model: str = Field(alias="evalModel")
    maximum_threads: int = Field(alias="maximumThreads")
    run_confidence_evaluation: bool = Field(alias="runConfidenceEvaluation")
    heavyweight_factor: int = Field(alias="heavyweightFactor")
    create_text_summary: bool = Field(alias="createTextSummary")
    retry_failed_calls_indefinitely: bool = Field(alias="retryFailedCallsIndefinitely")
    detect_refusals: bool = Field(alias="detectRefusals")
    model_under_test: str = Field(alias="modelUnderTest")
    temperature: float
    max_output_tokens: int = Field(alias="maxOutputTokens")
    system_prompt: str = Field(alias="systemPrompt")
    as_batch: bool = Field(alias="asBatch")
    custom_parameters: Any = Field(alias="customParameters")


class FixedOutputInputType(BaseModel):
    label: str
    text: str


class QuestionAnswerPairInputType(BaseModel):
    input_under_test: str = Field(alias="inputUnderTest")
    file_ids: Optional[List[Optional[str]]] = Field(alias="fileIds", default=None)
    context: Optional[Any] = None
    output_context: Optional[Any] = Field(alias="outputContext", default=None)
    llm_output: str = Field(alias="llmOutput")
    metadata: Optional["MetadataType"] = None
    test_id: Optional[str] = Field(alias="testId", default=None)
    status: Optional[str] = None


class MetadataType(BaseModel):
    in_tokens: int = Field(alias="inTokens")
    out_tokens: int = Field(alias="outTokens")
    duration_seconds: float = Field(alias="durationSeconds")


class LocalEvalUploadInputType(BaseModel):
    question_answer_pair_id: str = Field(alias="questionAnswerPairId")
    name: str
    score: float
    feedback: str


class CustomHumanReviewValueInputType(BaseModel):
    template_id: str = Field(alias="templateId")
    value: str
    review_type: CustomMetricReviewType = Field(alias="reviewType")


class PerCheckTestReviewInputType(BaseModel):
    id: int
    binary_human_eval: Optional[int] = Field(alias="binaryHumanEval", default=None)
    is_flagged: Optional[bool] = Field(alias="isFlagged", default=None)


class HumanReviewTemplateInput(BaseModel):
    id: Optional[str] = None
    name: str
    instructions: str
    optional: bool
    min_value: Optional[int] = Field(alias="minValue", default=None)
    max_value: Optional[int] = Field(alias="maxValue", default=None)
    categories: Optional[List[Optional[str]]] = None
    type: TemplateType
    comparative: Optional[bool] = None


class ChartConfigInput(BaseModel):
    id: str
    title: str
    subtitle: Optional[str] = None
    metric: ChartMetric
    filters: "ChartFilterInput"
    chart_type: ChartType = Field(alias="chartType")


class ChartFilterInput(BaseModel):
    test_suite_id: Optional[str] = Field(alias="testSuiteId", default=None)
    comparison_test_suite_ids: Optional[List[Optional[str]]] = Field(
        alias="comparisonTestSuiteIds", default=None
    )
    model_name: Optional[str] = Field(alias="modelName", default=None)
    comparison_model_names: Optional[List[Optional[str]]] = Field(
        alias="comparisonModelNames", default=None
    )
    run_ids: Optional[List[Optional[str]]] = Field(alias="runIds", default=None)
    run_count: int = Field(alias="runCount")


CheckInputType.model_rebuild()
CheckModifiersInputType.model_rebuild()
TestMutationInfo.model_rebuild()
QuestionAnswerPairInputType.model_rebuild()
ChartConfigInput.model_rebuild()
