# Generated by ariadne-codegen
# Source: vals/graphql/

from datetime import datetime
from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import RunStatus


class PullRun(BaseModel):
    run: "PullRunRun"


class PullRunRun(BaseModel):
    qa_set: Optional["PullRunRunQaSet"] = Field(alias="qaSet")
    run_id: str = Field(alias="runId")
    single_pending_or_completed_run_review: Optional[
        "PullRunRunSinglePendingOrCompletedRunReview"
    ] = Field(alias="singlePendingOrCompletedRunReview")
    pass_percentage: Optional[float] = Field(alias="passPercentage")
    status: RunStatus
    text_summary: str = Field(alias="textSummary")
    timestamp: datetime
    completed_at: Optional[datetime] = Field(alias="completedAt")
    archived: bool
    name: str
    parameters: "PullRunRunParameters"
    pass_rate: Optional["PullRunRunPassRate"] = Field(alias="passRate")
    success_rate: Optional["PullRunRunSuccessRate"] = Field(alias="successRate")
    custom_metrics: List["PullRunRunCustomMetrics"] = Field(alias="customMetrics")
    test_suite: "PullRunRunTestSuite" = Field(alias="testSuite")
    project: "PullRunRunProject"


class PullRunRunQaSet(BaseModel):
    id: Any


class PullRunRunSinglePendingOrCompletedRunReview(BaseModel):
    id: Any


class PullRunRunParameters(BaseModel):
    eval_model: str = Field(alias="evalModel")
    maximum_threads: int = Field(alias="maximumThreads")
    run_confidence_evaluation: bool = Field(alias="runConfidenceEvaluation")
    heavyweight_factor: int = Field(alias="heavyweightFactor")
    create_text_summary: bool = Field(alias="createTextSummary")
    model_under_test: str = Field(alias="modelUnderTest")
    temperature: float
    max_output_tokens: int = Field(alias="maxOutputTokens")
    system_prompt: str = Field(alias="systemPrompt")
    custom_parameters: Any = Field(alias="customParameters")


class PullRunRunPassRate(BaseModel):
    value: float
    error: float


class PullRunRunSuccessRate(BaseModel):
    value: float
    error: float


class PullRunRunCustomMetrics(BaseModel):
    metric_id: str = Field(alias="metricId")
    name: str
    pass_rate: float = Field(alias="passRate")
    error: Optional[str]


class PullRunRunTestSuite(BaseModel):
    id: str
    title: str


class PullRunRunProject(BaseModel):
    slug: str


PullRun.model_rebuild()
PullRunRun.model_rebuild()
