"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .requeststatus import RequestStatus
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, Optional
from typing_extensions import NotRequired, TypedDict


class InsightsTypedDict(TypedDict):
    pass


class Insights(BaseModel):
    pass


class CommunicationRequestResultTypedDict(TypedDict):
    reference_id: str
    r"""ID for target outreach (unique within batch)"""
    target: str
    r"""Target phone number"""
    request_variables: Dict[str, str]
    r"""Variables for request"""
    channel_manager_sid: NotRequired[Nullable[str]]
    r"""Channel manager SID"""
    created_at: NotRequired[datetime]
    r"""Timestamp of request creation"""
    sent_at: NotRequired[Nullable[datetime]]
    r"""Timestamp at which request was sent"""
    attempt_count: NotRequired[int]
    r"""Number of attempts for request"""
    session_id: NotRequired[Nullable[int]]
    r"""Unique ID for call session"""
    conversation_id: NotRequired[Nullable[int]]
    r"""Unique ID for conversation"""
    request_status: NotRequired[RequestStatus]
    r"""Status of a communication request."""
    channel_manager_status: NotRequired[Nullable[str]]
    r"""Status of request in channel manager"""
    insights_status: NotRequired[Nullable[str]]
    r"""Status of session in insight workflow"""
    insights: NotRequired[Nullable[InsightsTypedDict]]
    r"""Insights from call"""


class CommunicationRequestResult(BaseModel):
    reference_id: str
    r"""ID for target outreach (unique within batch)"""

    target: str
    r"""Target phone number"""

    request_variables: Dict[str, str]
    r"""Variables for request"""

    channel_manager_sid: OptionalNullable[str] = UNSET
    r"""Channel manager SID"""

    created_at: Optional[datetime] = None
    r"""Timestamp of request creation"""

    sent_at: OptionalNullable[datetime] = UNSET
    r"""Timestamp at which request was sent"""

    attempt_count: Optional[int] = 0
    r"""Number of attempts for request"""

    session_id: OptionalNullable[int] = UNSET
    r"""Unique ID for call session"""

    conversation_id: OptionalNullable[int] = UNSET
    r"""Unique ID for conversation"""

    request_status: Optional[RequestStatus] = None
    r"""Status of a communication request."""

    channel_manager_status: OptionalNullable[str] = UNSET
    r"""Status of request in channel manager"""

    insights_status: OptionalNullable[str] = UNSET
    r"""Status of session in insight workflow"""

    insights: OptionalNullable[Insights] = UNSET
    r"""Insights from call"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "channel_manager_sid",
            "created_at",
            "sent_at",
            "attempt_count",
            "session_id",
            "conversation_id",
            "request_status",
            "channel_manager_status",
            "insights_status",
            "insights",
        ]
        nullable_fields = [
            "channel_manager_sid",
            "sent_at",
            "session_id",
            "conversation_id",
            "channel_manager_status",
            "insights_status",
            "insights",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
