"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class ConversationTypedDict(TypedDict):
    r"""A conversation is a record of messages between a user and an agent, and is composed of one or
    more sessions.
    """

    timestamp: datetime
    r"""Timestamp of the conversation"""
    conversation_id: str
    r"""ID of the conversation"""
    agent_id: NotRequired[Nullable[str]]
    r"""ID of the agent with which the conversation occurred"""
    agent_name: NotRequired[Nullable[str]]
    r"""Name of the agent with which the conversation occurred"""
    agent_type: NotRequired[Nullable[str]]
    r"""Value of the \"type\" field of the agent with which the conversation occurred"""
    prompt_id: NotRequired[Nullable[str]]
    r"""ID of the prompt used in the conversation"""
    prompt_name: NotRequired[Nullable[str]]
    r"""Name of the prompt used in the conversation"""
    prompt_version: NotRequired[Nullable[str]]
    r"""Version of the prompt used in the conversation"""
    llm_provider: NotRequired[Nullable[str]]
    r"""Provider for the LLM used in the conversation (see PromptResponse.llm_config.provider)"""
    llm_model: NotRequired[Nullable[str]]
    r"""Model for the LLM used in the conversation (see PromptResponse.llm_config.model)"""
    llm_version: NotRequired[Nullable[str]]
    r"""Version for the LLM used in the conversation (see PromptResponse.llm_config.version)"""
    llm_temperature: NotRequired[Nullable[float]]
    r"""Temperature for the LLM used in the conversation (see PromptResponse.llm_config.temperature)"""
    llm_seed: NotRequired[Nullable[int]]
    r"""Seed for the LLM used in the conversation (see PromptResponse.llm_config.seed)."""
    is_legacy: NotRequired[Nullable[bool]]
    r"""Whether the conversation occurred on the legacy Syllable system"""


class Conversation(BaseModel):
    r"""A conversation is a record of messages between a user and an agent, and is composed of one or
    more sessions.
    """

    timestamp: datetime
    r"""Timestamp of the conversation"""

    conversation_id: str
    r"""ID of the conversation"""

    agent_id: OptionalNullable[str] = UNSET
    r"""ID of the agent with which the conversation occurred"""

    agent_name: OptionalNullable[str] = UNSET
    r"""Name of the agent with which the conversation occurred"""

    agent_type: OptionalNullable[str] = UNSET
    r"""Value of the \"type\" field of the agent with which the conversation occurred"""

    prompt_id: OptionalNullable[str] = UNSET
    r"""ID of the prompt used in the conversation"""

    prompt_name: OptionalNullable[str] = UNSET
    r"""Name of the prompt used in the conversation"""

    prompt_version: OptionalNullable[str] = UNSET
    r"""Version of the prompt used in the conversation"""

    llm_provider: OptionalNullable[str] = UNSET
    r"""Provider for the LLM used in the conversation (see PromptResponse.llm_config.provider)"""

    llm_model: OptionalNullable[str] = UNSET
    r"""Model for the LLM used in the conversation (see PromptResponse.llm_config.model)"""

    llm_version: OptionalNullable[str] = UNSET
    r"""Version for the LLM used in the conversation (see PromptResponse.llm_config.version)"""

    llm_temperature: OptionalNullable[float] = UNSET
    r"""Temperature for the LLM used in the conversation (see PromptResponse.llm_config.temperature)"""

    llm_seed: OptionalNullable[int] = UNSET
    r"""Seed for the LLM used in the conversation (see PromptResponse.llm_config.seed)."""

    is_legacy: OptionalNullable[bool] = UNSET
    r"""Whether the conversation occurred on the legacy Syllable system"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "agent_id",
            "agent_name",
            "agent_type",
            "prompt_id",
            "prompt_name",
            "prompt_version",
            "llm_provider",
            "llm_model",
            "llm_version",
            "llm_temperature",
            "llm_seed",
            "is_legacy",
        ]
        nullable_fields = [
            "agent_id",
            "agent_name",
            "agent_type",
            "prompt_id",
            "prompt_name",
            "prompt_version",
            "llm_provider",
            "llm_model",
            "llm_version",
            "llm_temperature",
            "llm_seed",
            "is_legacy",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
