"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .custommessagerule import CustomMessageRule, CustomMessageRuleTypedDict
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CustomMessageResponseTypedDict(TypedDict):
    r"""Response model for custom message operations.
    A custom message is a pre-configured message delivered by an agent as a greeting at the
    beginning of a conversation. Multiple agents can use the same custom mesasage. A custom message
    has one or more rules defined, which allow for different messages to be dynamically selected and
    delivered at runtime based on the current time and either date or day of the week. For more
    information, see [Console docs](https://docs.syllable.ai/Resources/Messages).
    """

    name: str
    r"""The name of the custom message"""
    text: str
    r"""The default message that the agent will deliver if no rules are set or no rules match the current timestamp."""
    id: int
    r"""The ID of the custom message"""
    updated_at: datetime
    r"""Timestamp of the most recent update to the custom message"""
    last_updated_by: str
    r"""The email address of the user who most recently updated the custom message"""
    label: NotRequired[Nullable[str]]
    r"""The label of the custom message"""
    rules: NotRequired[List[CustomMessageRuleTypedDict]]
    r"""Rules for time-specific message variants"""
    agent_count: NotRequired[Nullable[int]]
    r"""The number of agents using the custom message"""
    type: NotRequired[str]
    r"""Type of the custom message (must be \"greeting\" for now)"""


class CustomMessageResponse(BaseModel):
    r"""Response model for custom message operations.
    A custom message is a pre-configured message delivered by an agent as a greeting at the
    beginning of a conversation. Multiple agents can use the same custom mesasage. A custom message
    has one or more rules defined, which allow for different messages to be dynamically selected and
    delivered at runtime based on the current time and either date or day of the week. For more
    information, see [Console docs](https://docs.syllable.ai/Resources/Messages).
    """

    name: str
    r"""The name of the custom message"""

    text: str
    r"""The default message that the agent will deliver if no rules are set or no rules match the current timestamp."""

    id: int
    r"""The ID of the custom message"""

    updated_at: datetime
    r"""Timestamp of the most recent update to the custom message"""

    last_updated_by: str
    r"""The email address of the user who most recently updated the custom message"""

    label: OptionalNullable[str] = UNSET
    r"""The label of the custom message"""

    rules: Optional[List[CustomMessageRule]] = None
    r"""Rules for time-specific message variants"""

    agent_count: OptionalNullable[int] = UNSET
    r"""The number of agents using the custom message"""

    type: Optional[str] = "greeting"
    r"""Type of the custom message (must be \"greeting\" for now)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["label", "rules", "agent_count", "type"]
        nullable_fields = ["label", "agent_count"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
