"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


JSONValueTypedDict = TypeAliasType("JSONValueTypedDict", Union[str, int, float])


JSONValue = TypeAliasType("JSONValue", Union[str, int, float])


class InsightsOutputTypedDict(TypedDict):
    r"""Response model for an insight tool."""

    id: int
    r"""Unique ID of the insight"""
    insight_tool_id: int
    r"""Unique ID for insight tool configuration"""
    insight_tool_version: int
    r"""Version of insight tool configuration"""
    insight_key: str
    r"""Key for insight tool result"""
    json_value: Dict[str, JSONValueTypedDict]
    r"""JSON value of insight tool result"""
    session_id: NotRequired[Nullable[int]]
    r"""Unique ID for the session"""
    upload_file_id: NotRequired[Nullable[int]]
    r"""Unique ID for uploaded file"""
    string_value: NotRequired[Nullable[str]]
    r"""String value of insight tool result"""
    numeric_value: NotRequired[Nullable[float]]
    r"""Numeric value of insight tool result"""
    created_at: NotRequired[datetime]
    r"""Timestamp at which insight tool result was created"""
    updated_at: NotRequired[datetime]
    r"""Timestamp at which insight tool result was last updated"""


class InsightsOutput(BaseModel):
    r"""Response model for an insight tool."""

    id: int
    r"""Unique ID of the insight"""

    insight_tool_id: int
    r"""Unique ID for insight tool configuration"""

    insight_tool_version: int
    r"""Version of insight tool configuration"""

    insight_key: str
    r"""Key for insight tool result"""

    json_value: Dict[str, JSONValue]
    r"""JSON value of insight tool result"""

    session_id: OptionalNullable[int] = UNSET
    r"""Unique ID for the session"""

    upload_file_id: OptionalNullable[int] = UNSET
    r"""Unique ID for uploaded file"""

    string_value: OptionalNullable[str] = UNSET
    r"""String value of insight tool result"""

    numeric_value: OptionalNullable[float] = UNSET
    r"""Numeric value of insight tool result"""

    created_at: Optional[datetime] = None
    r"""Timestamp at which insight tool result was created"""

    updated_at: Optional[datetime] = None
    r"""Timestamp at which insight tool result was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "session_id",
            "upload_file_id",
            "string_value",
            "numeric_value",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "session_id",
            "upload_file_id",
            "string_value",
            "numeric_value",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
