"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .telephonyconfigurations import (
    TelephonyConfigurations,
    TelephonyConfigurationsTypedDict,
)
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class OrganizationChannelConfigTypedDict(TypedDict):
    r"""Channel config information for creates / updates through the organizations API"""

    account_sid: NotRequired[Nullable[str]]
    r"""SID of the Twilio account"""
    auth_token: NotRequired[Nullable[str]]
    r"""The Twilio auth token"""
    telephony: NotRequired[Nullable[TelephonyConfigurationsTypedDict]]
    r"""Telephony configurations to be applied to the targets under the channel"""


class OrganizationChannelConfig(BaseModel):
    r"""Channel config information for creates / updates through the organizations API"""

    account_sid: OptionalNullable[str] = UNSET
    r"""SID of the Twilio account"""

    auth_token: OptionalNullable[str] = UNSET
    r"""The Twilio auth token"""

    telephony: OptionalNullable[TelephonyConfigurations] = UNSET
    r"""Telephony configurations to be applied to the targets under the channel"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["account_sid", "auth_token", "telephony"]
        nullable_fields = ["account_sid", "auth_token", "telephony"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
