"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class OrganizationResponseTypedDict(TypedDict):
    display_name: str
    r"""The human-readable display name of the organization."""
    id: int
    r"""The internal ID of the organization."""
    slug: str
    r"""The slug of the organization used for URLs in the Console UI"""
    last_updated: datetime
    r"""The timestamp of the most recent update to the organization"""
    description: NotRequired[Nullable[str]]
    r"""Description of the organization."""
    domains: NotRequired[Nullable[str]]
    r"""Comma-delimited list of domains that users at the organization may have in their email addresses."""
    saml_provider_id: NotRequired[Nullable[str]]
    r"""SAML provider ID for user authentication"""
    last_updated_comments: NotRequired[Nullable[str]]
    r"""Comments for the most recent edit to the organization."""
    last_updated_by: NotRequired[Nullable[str]]
    r"""The email of the user who most recently updated the organization"""
    logo_url: NotRequired[Nullable[str]]
    r"""CDN URL. The org will always have a logo, but this value will be null on a response to an update where no logo was provided on the request"""


class OrganizationResponse(BaseModel):
    display_name: str
    r"""The human-readable display name of the organization."""

    id: int
    r"""The internal ID of the organization."""

    slug: str
    r"""The slug of the organization used for URLs in the Console UI"""

    last_updated: datetime
    r"""The timestamp of the most recent update to the organization"""

    description: OptionalNullable[str] = UNSET
    r"""Description of the organization."""

    domains: OptionalNullable[str] = UNSET
    r"""Comma-delimited list of domains that users at the organization may have in their email addresses."""

    saml_provider_id: OptionalNullable[str] = UNSET
    r"""SAML provider ID for user authentication"""

    last_updated_comments: OptionalNullable[str] = UNSET
    r"""Comments for the most recent edit to the organization."""

    last_updated_by: OptionalNullable[str] = UNSET
    r"""The email of the user who most recently updated the organization"""

    logo_url: OptionalNullable[str] = UNSET
    r"""CDN URL. The org will always have a logo, but this value will be null on a response to an update where no logo was provided on the request"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "domains",
            "saml_provider_id",
            "last_updated_comments",
            "last_updated_by",
            "logo_url",
        ]
        nullable_fields = [
            "description",
            "domains",
            "saml_provider_id",
            "last_updated_comments",
            "last_updated_by",
            "logo_url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
