"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .daysofweek import DaysOfWeek
import pydantic
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OutboundCampaignInputTypedDict(TypedDict):
    campaign_name: str
    r"""Human readable name of campaign"""
    campaign_variables: Dict[str, str]
    r"""Variables for campaign"""
    caller_id: Nullable[str]
    r"""Caller ID for call"""
    active_days: List[DaysOfWeek]
    r"""Days of the week when campaign is active"""
    description: NotRequired[Nullable[str]]
    r"""Description of campaign"""
    mode: NotRequired[Nullable[str]]
    r"""Mode of the campaign (e.g. voice, sms)"""
    sms_session_ttl: NotRequired[Nullable[int]]
    r"""Time to live for SMS session in minutes"""
    label: NotRequired[Nullable[str]]
    r"""Label for campaign (DEPRECATED - use labels instead)"""
    labels: NotRequired[Nullable[List[str]]]
    r"""Labels for campaign"""
    daily_start_time: NotRequired[Nullable[str]]
    r"""Start time of campaign each day"""
    daily_end_time: NotRequired[Nullable[str]]
    r"""End time of campaign each day"""
    source: NotRequired[Nullable[str]]
    r"""Source phone number, email, or SMS number"""
    hourly_rate: NotRequired[int]
    r"""Target number of outreach calls per hour"""
    retry_count: NotRequired[int]
    r"""Number of retries per target"""
    retry_interval: NotRequired[Nullable[str]]
    r"""How long to wait before retrying"""
    voicemail_detection: NotRequired[Nullable[Dict[str, float]]]
    r"""Config for voicemail detection for voice campaigns"""


class OutboundCampaignInput(BaseModel):
    campaign_name: str
    r"""Human readable name of campaign"""

    campaign_variables: Dict[str, str]
    r"""Variables for campaign"""

    caller_id: Nullable[str]
    r"""Caller ID for call"""

    active_days: List[DaysOfWeek]
    r"""Days of the week when campaign is active"""

    description: OptionalNullable[str] = UNSET
    r"""Description of campaign"""

    mode: OptionalNullable[str] = UNSET
    r"""Mode of the campaign (e.g. voice, sms)"""

    sms_session_ttl: OptionalNullable[int] = UNSET
    r"""Time to live for SMS session in minutes"""

    label: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""Label for campaign (DEPRECATED - use labels instead)"""

    labels: OptionalNullable[List[str]] = UNSET
    r"""Labels for campaign"""

    daily_start_time: OptionalNullable[str] = UNSET
    r"""Start time of campaign each day"""

    daily_end_time: OptionalNullable[str] = UNSET
    r"""End time of campaign each day"""

    source: OptionalNullable[str] = UNSET
    r"""Source phone number, email, or SMS number"""

    hourly_rate: Optional[int] = 1
    r"""Target number of outreach calls per hour"""

    retry_count: Optional[int] = 0
    r"""Number of retries per target"""

    retry_interval: OptionalNullable[str] = UNSET
    r"""How long to wait before retrying"""

    voicemail_detection: OptionalNullable[Dict[str, float]] = UNSET
    r"""Config for voicemail detection for voice campaigns"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "mode",
            "sms_session_ttl",
            "label",
            "labels",
            "daily_start_time",
            "daily_end_time",
            "source",
            "hourly_rate",
            "retry_count",
            "retry_interval",
            "voicemail_detection",
        ]
        nullable_fields = [
            "description",
            "mode",
            "sms_session_ttl",
            "label",
            "labels",
            "daily_start_time",
            "daily_end_time",
            "source",
            "caller_id",
            "retry_interval",
            "voicemail_detection",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
