"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .prompthistorylinkedtool import (
    PromptHistoryLinkedTool,
    PromptHistoryLinkedToolTypedDict,
)
from .promptllmconfig import PromptLlmConfig, PromptLlmConfigTypedDict
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class PromptHistoryTypedDict(TypedDict):
    r"""Record of a specific version of a prompt."""

    timestamp: datetime
    r"""Timestamp of the change resulting in this version"""
    prompt_id: str
    r"""ID of the prompt"""
    version_number: int
    r"""Version number of this version. Starts at 1 when prompt is created, and incremented on each change."""
    prompt_text: str
    r"""Text of the prompt at this version"""
    prompt_name: str
    r"""Name of the prompt at this version"""
    user_email: str
    r"""Email address of the user who made the change that resulted in this version"""
    is_pre_enhancements: bool
    r"""Whether this version of the prompt was created before history of tool-prompt linking was tracked"""
    prompt_description: NotRequired[Nullable[str]]
    r"""Description of the prompt at this version"""
    llm_config: NotRequired[Nullable[PromptLlmConfigTypedDict]]
    r"""String representation of LLM config for the prompt at this version"""
    comments: NotRequired[Nullable[str]]
    r"""Comments describing the change that resulted in this version"""
    linked_tools: NotRequired[List[PromptHistoryLinkedToolTypedDict]]
    r"""Tools that were linked to this version of the prompt"""


class PromptHistory(BaseModel):
    r"""Record of a specific version of a prompt."""

    timestamp: datetime
    r"""Timestamp of the change resulting in this version"""

    prompt_id: str
    r"""ID of the prompt"""

    version_number: int
    r"""Version number of this version. Starts at 1 when prompt is created, and incremented on each change."""

    prompt_text: str
    r"""Text of the prompt at this version"""

    prompt_name: str
    r"""Name of the prompt at this version"""

    user_email: str
    r"""Email address of the user who made the change that resulted in this version"""

    is_pre_enhancements: bool
    r"""Whether this version of the prompt was created before history of tool-prompt linking was tracked"""

    prompt_description: OptionalNullable[str] = UNSET
    r"""Description of the prompt at this version"""

    llm_config: OptionalNullable[PromptLlmConfig] = UNSET
    r"""String representation of LLM config for the prompt at this version"""

    comments: OptionalNullable[str] = UNSET
    r"""Comments describing the change that resulted in this version"""

    linked_tools: Optional[List[PromptHistoryLinkedTool]] = None
    r"""Tools that were linked to this version of the prompt"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "prompt_description",
            "llm_config",
            "comments",
            "linked_tools",
        ]
        nullable_fields = ["prompt_description", "llm_config", "comments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
