"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class RoleUpdateRequestTypedDict(TypedDict):
    r"""Request model to update an existing role."""

    name: str
    r"""The name of the role."""
    permissions: List[str]
    r"""The permissions associated with the role. Available permissions can be found by calling `GET /permissions`."""
    id: int
    r"""The internal ID of the role."""
    description: NotRequired[Nullable[str]]
    r"""The description of the role."""
    last_updated_comments: NotRequired[Nullable[str]]
    r"""Comments for the most recent edit to the role."""


class RoleUpdateRequest(BaseModel):
    r"""Request model to update an existing role."""

    name: str
    r"""The name of the role."""

    permissions: List[str]
    r"""The permissions associated with the role. Available permissions can be found by calling `GET /permissions`."""

    id: int
    r"""The internal ID of the role."""

    description: OptionalNullable[str] = UNSET
    r"""The description of the role."""

    last_updated_comments: OptionalNullable[str] = UNSET
    r"""Comments for the most recent edit to the role."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "last_updated_comments"]
        nullable_fields = ["description", "last_updated_comments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
