"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class SessionTypedDict(TypedDict):
    r"""A session is a building block of a conversation."""

    timestamp: datetime
    r"""Timestamp of the session"""
    session_id: NotRequired[Nullable[str]]
    r"""Internal ID of the session, generated based on interaction details"""
    conversation_id: NotRequired[Nullable[str]]
    r"""ID of the conversation of which the session is a part"""
    channel_manager_service: NotRequired[Nullable[str]]
    r"""Name of the service used to facilitate the session"""
    channel_manager_type: NotRequired[Nullable[str]]
    r"""Type of the service used to facilitate the session"""
    channel_manager_sid: NotRequired[Nullable[str]]
    r"""Channel-manager-side ID of the session (different from session_id)"""
    agent_id: NotRequired[Nullable[str]]
    r"""ID of the agent with which the session occurred"""
    agent_name: NotRequired[Nullable[str]]
    r"""Name of the agent with which the session occurred"""
    agent_type: NotRequired[Nullable[str]]
    r"""Type of the agent with which the session occurred"""
    agent_timezone: NotRequired[Nullable[str]]
    r"""Timezone of the agent with which the session occurred"""
    prompt_id: NotRequired[Nullable[str]]
    r"""ID of the prompt used by the agent with which the session occurred"""
    prompt_name: NotRequired[Nullable[str]]
    r"""Name of the prompt used by the agent with which the session occurred"""
    prompt_version: NotRequired[Nullable[str]]
    r"""Legacy prompt version timestamp used by the agent with which the session occurred"""
    prompt_version_number: NotRequired[Nullable[int]]
    r"""Prompt version number used by the agent with which the session occurred (new system)"""
    duration: NotRequired[Nullable[float]]
    r"""Duration of the session in seconds"""
    session_label_id: NotRequired[Nullable[str]]
    r"""ID of the label (listing the quality of the session and any issues that occurred) associated with the session"""
    source: NotRequired[Nullable[str]]
    r"""Source of the session (e.g., for an inbound session, the user's phone number/username/email)"""
    target: NotRequired[Nullable[str]]
    r"""The name of the channel target associated with the agent at the time of the session (see ChannelTargetResponse.target)"""
    is_legacy: NotRequired[Nullable[bool]]
    r"""Whether the session occurred on the legacy Syllable system"""
    is_test: NotRequired[Nullable[bool]]
    r"""Whether the session is a test session"""


class Session(BaseModel):
    r"""A session is a building block of a conversation."""

    timestamp: datetime
    r"""Timestamp of the session"""

    session_id: OptionalNullable[str] = UNSET
    r"""Internal ID of the session, generated based on interaction details"""

    conversation_id: OptionalNullable[str] = UNSET
    r"""ID of the conversation of which the session is a part"""

    channel_manager_service: OptionalNullable[str] = UNSET
    r"""Name of the service used to facilitate the session"""

    channel_manager_type: OptionalNullable[str] = UNSET
    r"""Type of the service used to facilitate the session"""

    channel_manager_sid: OptionalNullable[str] = UNSET
    r"""Channel-manager-side ID of the session (different from session_id)"""

    agent_id: OptionalNullable[str] = UNSET
    r"""ID of the agent with which the session occurred"""

    agent_name: OptionalNullable[str] = UNSET
    r"""Name of the agent with which the session occurred"""

    agent_type: OptionalNullable[str] = UNSET
    r"""Type of the agent with which the session occurred"""

    agent_timezone: OptionalNullable[str] = UNSET
    r"""Timezone of the agent with which the session occurred"""

    prompt_id: OptionalNullable[str] = UNSET
    r"""ID of the prompt used by the agent with which the session occurred"""

    prompt_name: OptionalNullable[str] = UNSET
    r"""Name of the prompt used by the agent with which the session occurred"""

    prompt_version: OptionalNullable[str] = UNSET
    r"""Legacy prompt version timestamp used by the agent with which the session occurred"""

    prompt_version_number: OptionalNullable[int] = UNSET
    r"""Prompt version number used by the agent with which the session occurred (new system)"""

    duration: OptionalNullable[float] = UNSET
    r"""Duration of the session in seconds"""

    session_label_id: OptionalNullable[str] = UNSET
    r"""ID of the label (listing the quality of the session and any issues that occurred) associated with the session"""

    source: OptionalNullable[str] = UNSET
    r"""Source of the session (e.g., for an inbound session, the user's phone number/username/email)"""

    target: OptionalNullable[str] = UNSET
    r"""The name of the channel target associated with the agent at the time of the session (see ChannelTargetResponse.target)"""

    is_legacy: OptionalNullable[bool] = UNSET
    r"""Whether the session occurred on the legacy Syllable system"""

    is_test: OptionalNullable[bool] = UNSET
    r"""Whether the session is a test session"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "session_id",
            "conversation_id",
            "channel_manager_service",
            "channel_manager_type",
            "channel_manager_sid",
            "agent_id",
            "agent_name",
            "agent_type",
            "agent_timezone",
            "prompt_id",
            "prompt_name",
            "prompt_version",
            "prompt_version_number",
            "duration",
            "session_label_id",
            "source",
            "target",
            "is_legacy",
            "is_test",
        ]
        nullable_fields = [
            "session_id",
            "conversation_id",
            "channel_manager_service",
            "channel_manager_type",
            "channel_manager_sid",
            "agent_id",
            "agent_name",
            "agent_type",
            "agent_timezone",
            "prompt_id",
            "prompt_name",
            "prompt_version",
            "prompt_version_number",
            "duration",
            "session_label_id",
            "source",
            "target",
            "is_legacy",
            "is_test",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
