"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class SessionActionTypedDict(TypedDict):
    r"""Information about a given tool invocation as part of a session."""

    timestamp: datetime
    r"""Timestamp of the tool invocation"""
    tool_name: NotRequired[Nullable[str]]
    r"""Name of the tool that was invoked"""
    tool_request: NotRequired[Nullable[str]]
    r"""Request sent to the tool API, if applicable"""
    tool_result: NotRequired[Nullable[str]]
    r"""Response received from the tool API, if applicable"""
    tool_error: NotRequired[Nullable[str]]
    r"""Error received from the tool API, if applicable"""


class SessionAction(BaseModel):
    r"""Information about a given tool invocation as part of a session."""

    timestamp: datetime
    r"""Timestamp of the tool invocation"""

    tool_name: OptionalNullable[str] = UNSET
    r"""Name of the tool that was invoked"""

    tool_request: OptionalNullable[str] = UNSET
    r"""Request sent to the tool API, if applicable"""

    tool_result: OptionalNullable[str] = UNSET
    r"""Response received from the tool API, if applicable"""

    tool_error: OptionalNullable[str] = UNSET
    r"""Error received from the tool API, if applicable"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["tool_name", "tool_request", "tool_result", "tool_error"]
        nullable_fields = ["tool_name", "tool_request", "tool_result", "tool_error"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
