"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class SessionLabelTypedDict(TypedDict):
    r"""Response model for session label operations.
    A session label is associated with a given session and contains an evaluation of quality and
    descriptions of issues the user encountered in that session or other details.
    """

    session_id: int
    r"""The internal ID of the session (see Session.session_id)"""
    type: str
    r"""The type of the label (either \"auto-rating\" or \"human-rating\")"""
    code: str
    r"""A code describing the quality of the labeled session (either \"GOOD\", \"OK\", \"BAD\", or \"N/A\")"""
    user_email: str
    r"""The email of the user who created the label"""
    id: int
    r"""The internal ID of the label"""
    timestamp: str
    r"""The timestamp at which the label was created"""
    comments: NotRequired[Nullable[str]]
    r"""Comment string describing additional details about the session"""
    issue_categories: NotRequired[Nullable[List[str]]]
    r"""Descriptions of issues occurring in the labeled call"""


class SessionLabel(BaseModel):
    r"""Response model for session label operations.
    A session label is associated with a given session and contains an evaluation of quality and
    descriptions of issues the user encountered in that session or other details.
    """

    session_id: int
    r"""The internal ID of the session (see Session.session_id)"""

    type: str
    r"""The type of the label (either \"auto-rating\" or \"human-rating\")"""

    code: str
    r"""A code describing the quality of the labeled session (either \"GOOD\", \"OK\", \"BAD\", or \"N/A\")"""

    user_email: str
    r"""The email of the user who created the label"""

    id: int
    r"""The internal ID of the label"""

    timestamp: str
    r"""The timestamp at which the label was created"""

    comments: OptionalNullable[str] = UNSET
    r"""Comment string describing additional details about the session"""

    issue_categories: OptionalNullable[List[str]] = UNSET
    r"""Descriptions of issues occurring in the labeled call"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["comments", "issue_categories"]
        nullable_fields = ["comments", "issue_categories"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
