"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class SessionRecordingResponseTypedDict(TypedDict):
    r"""Recording URLs for a given session."""

    session_id: NotRequired[Nullable[str]]
    r"""The internal ID of the session"""
    recordings: NotRequired[Nullable[List[str]]]
    r"""List of recording URLs"""


class SessionRecordingResponse(BaseModel):
    r"""Recording URLs for a given session."""

    session_id: OptionalNullable[str] = UNSET
    r"""The internal ID of the session"""

    recordings: OptionalNullable[List[str]] = UNSET
    r"""List of recording URLs"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["session_id", "recordings"]
        nullable_fields = ["session_id", "recordings"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
