"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .statictoolparametertype import StaticToolParameterType
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Any
from typing_extensions import NotRequired, TypedDict


class StaticToolParameterTypedDict(TypedDict):
    r"""A parameter for the tool whose value should be set at config time."""

    name: str
    r"""The name of the parameter - must be unique within the tool."""
    required: bool
    r"""Whether the parameter is required to have a value assigned."""
    type: StaticToolParameterType
    r"""The expected type for a static tool parameter."""
    description: NotRequired[Nullable[str]]
    r"""The description of the parameter."""
    default: NotRequired[Nullable[Any]]
    r"""The default value for the parameter. If `type` is string, must be a string. If `type` is int, must be an int. If `type` is boolean, must be a boolean. If `type` is data_source_list, must be a list of strings (data source names)."""


class StaticToolParameter(BaseModel):
    r"""A parameter for the tool whose value should be set at config time."""

    name: str
    r"""The name of the parameter - must be unique within the tool."""

    required: bool
    r"""Whether the parameter is required to have a value assigned."""

    type: StaticToolParameterType
    r"""The expected type for a static tool parameter."""

    description: OptionalNullable[str] = UNSET
    r"""The description of the parameter."""

    default: OptionalNullable[Any] = UNSET
    r"""The default value for the parameter. If `type` is string, must be a string. If `type` is int, must be an int. If `type` is boolean, must be a boolean. If `type` is data_source_list, must be a list of strings (data source names)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "default"]
        nullable_fields = ["description", "default"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
