"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class TelephonyConfigurationsTypedDict(TypedDict):
    pre_input_timeout: NotRequired[Nullable[float]]
    r"""Pre input silence threshold"""
    post_speech_input_timeout: NotRequired[Nullable[float]]
    r"""Post speech silence timeout to determine input as ended."""
    post_dtmf_input_timeout: NotRequired[Nullable[float]]
    r"""Post dtmf silence timeout to determine input as ended."""
    overall_input_timeout: NotRequired[Nullable[float]]
    r"""Total input timeout"""
    output_padding: NotRequired[Nullable[float]]
    r"""Number of seconds to start listening to user input before assistant speech ends"""
    interruptibility: NotRequired[Nullable[str]]
    r"""Interruptibility setting for user input.Valid values: none, dtmf_only, speech_only, all"""
    passive_speech_input_enabled: NotRequired[Nullable[bool]]
    r"""Whether passive speech input is enabled (input while assistant is speaking)"""
    passive_input_start: NotRequired[Nullable[float]]
    r"""Waiting time to start passive input (in seconds) after start of assistant speech"""


class TelephonyConfigurations(BaseModel):
    pre_input_timeout: OptionalNullable[float] = UNSET
    r"""Pre input silence threshold"""

    post_speech_input_timeout: OptionalNullable[float] = UNSET
    r"""Post speech silence timeout to determine input as ended."""

    post_dtmf_input_timeout: OptionalNullable[float] = UNSET
    r"""Post dtmf silence timeout to determine input as ended."""

    overall_input_timeout: OptionalNullable[float] = UNSET
    r"""Total input timeout"""

    output_padding: OptionalNullable[float] = UNSET
    r"""Number of seconds to start listening to user input before assistant speech ends"""

    interruptibility: OptionalNullable[str] = UNSET
    r"""Interruptibility setting for user input.Valid values: none, dtmf_only, speech_only, all"""

    passive_speech_input_enabled: OptionalNullable[bool] = UNSET
    r"""Whether passive speech input is enabled (input while assistant is speaking)"""

    passive_input_start: OptionalNullable[float] = UNSET
    r"""Waiting time to start passive input (in seconds) after start of assistant speech"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "pre_input_timeout",
            "post_speech_input_timeout",
            "post_dtmf_input_timeout",
            "overall_input_timeout",
            "output_padding",
            "interruptibility",
            "passive_speech_input_enabled",
            "passive_input_start",
        ]
        nullable_fields = [
            "pre_input_timeout",
            "post_speech_input_timeout",
            "post_dtmf_input_timeout",
            "overall_input_timeout",
            "output_padding",
            "interruptibility",
            "passive_speech_input_enabled",
            "passive_input_start",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
