"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .internaltool import InternalTool, InternalToolTypedDict
from .statictoolparameter import StaticToolParameter, StaticToolParameterTypedDict
from .toolhttpendpoint import ToolHTTPEndpoint, ToolHTTPEndpointTypedDict
from .tooloptions import ToolOptions, ToolOptionsTypedDict
from .toolparameterdefault import ToolParameterDefault, ToolParameterDefaultTypedDict
from enum import Enum
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Any, Dict, List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


class Type(str, Enum):
    ACTION = "action"
    ENDPOINT = "endpoint"
    CONTEXT = "context"
    LOG = "log"


DefaultsTypedDict = TypeAliasType(
    "DefaultsTypedDict", Union[Any, Dict[str, ToolParameterDefaultTypedDict]]
)
r"""The default values for the parameters of the function/tool call."""


Defaults = TypeAliasType("Defaults", Union[Any, Dict[str, ToolParameterDefault]])
r"""The default values for the parameters of the function/tool call."""


class ToolDefinitionTypedDict(TypedDict):
    r"""A tool that can be called from an LLM during the conversation. See https://docs.syllable.ai/Resources/Tools."""

    tool: InternalToolTypedDict
    r"""A tool definition to be used by the OpenAI API."""
    type: NotRequired[Nullable[Type]]
    r"""The action to take when the LLM calls the tool."""
    endpoint: NotRequired[Nullable[ToolHTTPEndpointTypedDict]]
    r"""The configuration for an HTTP API call."""
    defaults: NotRequired[Nullable[DefaultsTypedDict]]
    r"""The default values for the parameters of the function/tool call."""
    static_parameters: NotRequired[Nullable[List[StaticToolParameterTypedDict]]]
    r"""Parameters for the tool whose values should be set at config time (i.e., not provided by the LLM)."""
    result: NotRequired[Nullable[Any]]
    r"""The optional result of the tool call."""
    options: NotRequired[Nullable[ToolOptionsTypedDict]]
    r"""The options for the tool. Ie allows to propagate the tool result to the caller via propagate_tool_result flag."""


class ToolDefinition(BaseModel):
    r"""A tool that can be called from an LLM during the conversation. See https://docs.syllable.ai/Resources/Tools."""

    tool: InternalTool
    r"""A tool definition to be used by the OpenAI API."""

    type: OptionalNullable[Type] = UNSET
    r"""The action to take when the LLM calls the tool."""

    endpoint: OptionalNullable[ToolHTTPEndpoint] = UNSET
    r"""The configuration for an HTTP API call."""

    defaults: OptionalNullable[Defaults] = UNSET
    r"""The default values for the parameters of the function/tool call."""

    static_parameters: OptionalNullable[List[StaticToolParameter]] = UNSET
    r"""Parameters for the tool whose values should be set at config time (i.e., not provided by the LLM)."""

    result: OptionalNullable[Any] = UNSET
    r"""The optional result of the tool call."""

    options: OptionalNullable[ToolOptions] = UNSET
    r"""The options for the tool. Ie allows to propagate the tool result to the caller via propagate_tool_result flag."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "endpoint",
            "defaults",
            "static_parameters",
            "result",
            "options",
        ]
        nullable_fields = [
            "type",
            "endpoint",
            "defaults",
            "static_parameters",
            "result",
            "options",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
