"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class UserUpdateRequestTypedDict(TypedDict):
    r"""Request model to update an existing user."""

    email: str
    r"""Email address of the user"""
    role_id: int
    r"""ID of the role assigned to the user"""
    first_name: NotRequired[Nullable[str]]
    r"""First name of the user"""
    last_name: NotRequired[Nullable[str]]
    r"""Last name of the user"""
    last_updated_comments: NotRequired[Nullable[str]]
    r"""Comments for the most recent edit to the user."""


class UserUpdateRequest(BaseModel):
    r"""Request model to update an existing user."""

    email: str
    r"""Email address of the user"""

    role_id: int
    r"""ID of the role assigned to the user"""

    first_name: OptionalNullable[str] = UNSET
    r"""First name of the user"""

    last_name: OptionalNullable[str] = UNSET
    r"""Last name of the user"""

    last_updated_comments: OptionalNullable[str] = UNSET
    r"""Comments for the most recent edit to the user."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["first_name", "last_name", "last_updated_comments"]
        nullable_fields = ["first_name", "last_name", "last_updated_comments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
