# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CertificateAuthorityCertificateAuthorityConfigurationArgs',
    'CertificateAuthorityCertificateAuthorityConfigurationArgsDict',
    'CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs',
    'CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsDict',
    'CertificateAuthorityRevocationConfigurationArgs',
    'CertificateAuthorityRevocationConfigurationArgsDict',
    'CertificateAuthorityRevocationConfigurationCrlConfigurationArgs',
    'CertificateAuthorityRevocationConfigurationCrlConfigurationArgsDict',
    'CertificateAuthorityRevocationConfigurationOcspConfigurationArgs',
    'CertificateAuthorityRevocationConfigurationOcspConfigurationArgsDict',
    'CertificateValidityArgs',
    'CertificateValidityArgsDict',
]

MYPY = False

if not MYPY:
    class CertificateAuthorityCertificateAuthorityConfigurationArgsDict(TypedDict):
        key_algorithm: pulumi.Input[_builtins.str]
        """
        Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        signing_algorithm: pulumi.Input[_builtins.str]
        """
        Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        subject: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsDict']
        """
        Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
        """
elif False:
    CertificateAuthorityCertificateAuthorityConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCertificateAuthorityConfigurationArgs:
    def __init__(__self__, *,
                 key_algorithm: pulumi.Input[_builtins.str],
                 signing_algorithm: pulumi.Input[_builtins.str],
                 subject: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs']):
        """
        :param pulumi.Input[_builtins.str] key_algorithm: Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        :param pulumi.Input[_builtins.str] signing_algorithm: Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        :param pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs'] subject: Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signing_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs']:
        """
        Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs']):
        pulumi.set(self, "subject", value)


if not MYPY:
    class CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsDict(TypedDict):
        common_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
        """
        country: NotRequired[pulumi.Input[_builtins.str]]
        """
        Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
        """
        distinguished_name_qualifier: NotRequired[pulumi.Input[_builtins.str]]
        """
        Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
        """
        generation_qualifier: NotRequired[pulumi.Input[_builtins.str]]
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
        """
        given_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        First name. Must be less than or equal to 16 characters in length.
        """
        initials: NotRequired[pulumi.Input[_builtins.str]]
        """
        Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
        """
        locality: NotRequired[pulumi.Input[_builtins.str]]
        """
        Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
        """
        organization: NotRequired[pulumi.Input[_builtins.str]]
        """
        Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        organizational_unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        pseudonym: NotRequired[pulumi.Input[_builtins.str]]
        """
        Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
        """
        surname: NotRequired[pulumi.Input[_builtins.str]]
        """
        Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
        """
        title: NotRequired[pulumi.Input[_builtins.str]]
        """
        Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
        """
elif False:
    CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs:
    def __init__(__self__, *,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 distinguished_name_qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 generation_qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 given_name: Optional[pulumi.Input[_builtins.str]] = None,
                 initials: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pseudonym: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 surname: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] common_name: Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
        :param pulumi.Input[_builtins.str] country: Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
        :param pulumi.Input[_builtins.str] distinguished_name_qualifier: Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
        :param pulumi.Input[_builtins.str] generation_qualifier: Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
        :param pulumi.Input[_builtins.str] given_name: First name. Must be less than or equal to 16 characters in length.
        :param pulumi.Input[_builtins.str] initials: Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
        :param pulumi.Input[_builtins.str] locality: Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[_builtins.str] organization: Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        :param pulumi.Input[_builtins.str] organizational_unit: Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        :param pulumi.Input[_builtins.str] pseudonym: Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[_builtins.str] state: State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[_builtins.str] surname: Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
        :param pulumi.Input[_builtins.str] title: Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "distinguished_name_qualifier")

    @distinguished_name_qualifier.setter
    def distinguished_name_qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distinguished_name_qualifier", value)

    @_builtins.property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
        """
        return pulumi.get(self, "generation_qualifier")

    @generation_qualifier.setter
    def generation_qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation_qualifier", value)

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        First name. Must be less than or equal to 16 characters in length.
        """
        return pulumi.get(self, "given_name")

    @given_name.setter
    def given_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "given_name", value)

    @_builtins.property
    @pulumi.getter
    def initials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
        """
        return pulumi.get(self, "initials")

    @initials.setter
    def initials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initials", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @_builtins.property
    @pulumi.getter
    def pseudonym(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "pseudonym")

    @pseudonym.setter
    def pseudonym(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pseudonym", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def surname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
        """
        return pulumi.get(self, "surname")

    @surname.setter
    def surname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "surname", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


if not MYPY:
    class CertificateAuthorityRevocationConfigurationArgsDict(TypedDict):
        crl_configuration: NotRequired[pulumi.Input['CertificateAuthorityRevocationConfigurationCrlConfigurationArgsDict']]
        """
        Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
        """
        ocsp_configuration: NotRequired[pulumi.Input['CertificateAuthorityRevocationConfigurationOcspConfigurationArgsDict']]
        """
        Nested argument containing configuration of
        the custom OCSP responder endpoint. Defined below.
        """
elif False:
    CertificateAuthorityRevocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityRevocationConfigurationArgs:
    def __init__(__self__, *,
                 crl_configuration: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationCrlConfigurationArgs']] = None,
                 ocsp_configuration: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationOcspConfigurationArgs']] = None):
        """
        :param pulumi.Input['CertificateAuthorityRevocationConfigurationCrlConfigurationArgs'] crl_configuration: Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
        :param pulumi.Input['CertificateAuthorityRevocationConfigurationOcspConfigurationArgs'] ocsp_configuration: Nested argument containing configuration of
               the custom OCSP responder endpoint. Defined below.
        """
        if crl_configuration is not None:
            pulumi.set(__self__, "crl_configuration", crl_configuration)
        if ocsp_configuration is not None:
            pulumi.set(__self__, "ocsp_configuration", ocsp_configuration)

    @_builtins.property
    @pulumi.getter(name="crlConfiguration")
    def crl_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationCrlConfigurationArgs']]:
        """
        Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
        """
        return pulumi.get(self, "crl_configuration")

    @crl_configuration.setter
    def crl_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationCrlConfigurationArgs']]):
        pulumi.set(self, "crl_configuration", value)

    @_builtins.property
    @pulumi.getter(name="ocspConfiguration")
    def ocsp_configuration(self) -> Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationOcspConfigurationArgs']]:
        """
        Nested argument containing configuration of
        the custom OCSP responder endpoint. Defined below.
        """
        return pulumi.get(self, "ocsp_configuration")

    @ocsp_configuration.setter
    def ocsp_configuration(self, value: Optional[pulumi.Input['CertificateAuthorityRevocationConfigurationOcspConfigurationArgs']]):
        pulumi.set(self, "ocsp_configuration", value)


if not MYPY:
    class CertificateAuthorityRevocationConfigurationCrlConfigurationArgsDict(TypedDict):
        custom_cname: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        """
        expiration_in_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of days until a certificate expires. Must be between 1 and 5000.
        """
        s3_bucket_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
        """
        s3_object_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
        """
elif False:
    CertificateAuthorityRevocationConfigurationCrlConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityRevocationConfigurationCrlConfigurationArgs:
    def __init__(__self__, *,
                 custom_cname: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 s3_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_object_acl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] custom_cname: Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
        :param pulumi.Input[_builtins.bool] enabled: Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.int] expiration_in_days: Number of days until a certificate expires. Must be between 1 and 5000.
        :param pulumi.Input[_builtins.str] s3_bucket_name: Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
        :param pulumi.Input[_builtins.str] s3_object_acl: Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
        """
        if custom_cname is not None:
            pulumi.set(__self__, "custom_cname", custom_cname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_acl is not None:
            pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @_builtins.property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
        """
        return pulumi.get(self, "custom_cname")

    @custom_cname.setter
    def custom_cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_cname", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days until a certificate expires. Must be between 1 and 5000.
        """
        return pulumi.get(self, "expiration_in_days")

    @expiration_in_days.setter
    def expiration_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_in_days", value)

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
        """
        return pulumi.get(self, "s3_object_acl")

    @s3_object_acl.setter
    def s3_object_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_object_acl", value)


if not MYPY:
    class CertificateAuthorityRevocationConfigurationOcspConfigurationArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Boolean value that specifies whether a custom OCSP responder is enabled.
        """
        ocsp_custom_cname: NotRequired[pulumi.Input[_builtins.str]]
        """
        CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
elif False:
    CertificateAuthorityRevocationConfigurationOcspConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateAuthorityRevocationConfigurationOcspConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 ocsp_custom_cname: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Boolean value that specifies whether a custom OCSP responder is enabled.
        :param pulumi.Input[_builtins.str] ocsp_custom_cname: CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        pulumi.set(__self__, "enabled", enabled)
        if ocsp_custom_cname is not None:
            pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Boolean value that specifies whether a custom OCSP responder is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        return pulumi.get(self, "ocsp_custom_cname")

    @ocsp_custom_cname.setter
    def ocsp_custom_cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_custom_cname", value)


if not MYPY:
    class CertificateValidityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
        """
        value: pulumi.Input[_builtins.str]
        """
        If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
        """
elif False:
    CertificateValidityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateValidityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] type: Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
        :param pulumi.Input[_builtins.str] value: If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


