# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateAuthorityCertificateAuthorityConfiguration',
    'CertificateAuthorityCertificateAuthorityConfigurationSubject',
    'CertificateAuthorityRevocationConfiguration',
    'CertificateAuthorityRevocationConfigurationCrlConfiguration',
    'CertificateAuthorityRevocationConfigurationOcspConfiguration',
    'CertificateValidity',
    'GetCertificateAuthorityRevocationConfigurationResult',
    'GetCertificateAuthorityRevocationConfigurationCrlConfigurationResult',
    'GetCertificateAuthorityRevocationConfigurationOcspConfigurationResult',
]

@pulumi.output_type
class CertificateAuthorityCertificateAuthorityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyAlgorithm":
            suggest = "key_algorithm"
        elif key == "signingAlgorithm":
            suggest = "signing_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCertificateAuthorityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCertificateAuthorityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCertificateAuthorityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_algorithm: _builtins.str,
                 signing_algorithm: _builtins.str,
                 subject: 'outputs.CertificateAuthorityCertificateAuthorityConfigurationSubject'):
        """
        :param _builtins.str key_algorithm: Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        :param _builtins.str signing_algorithm: Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        :param 'CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs' subject: Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> _builtins.str:
        """
        Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> _builtins.str:
        """
        Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
        """
        return pulumi.get(self, "signing_algorithm")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> 'outputs.CertificateAuthorityCertificateAuthorityConfigurationSubject':
        """
        Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class CertificateAuthorityCertificateAuthorityConfigurationSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "distinguishedNameQualifier":
            suggest = "distinguished_name_qualifier"
        elif key == "generationQualifier":
            suggest = "generation_qualifier"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCertificateAuthorityConfigurationSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCertificateAuthorityConfigurationSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCertificateAuthorityConfigurationSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[_builtins.str] = None,
                 country: Optional[_builtins.str] = None,
                 distinguished_name_qualifier: Optional[_builtins.str] = None,
                 generation_qualifier: Optional[_builtins.str] = None,
                 given_name: Optional[_builtins.str] = None,
                 initials: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 organizational_unit: Optional[_builtins.str] = None,
                 pseudonym: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 surname: Optional[_builtins.str] = None,
                 title: Optional[_builtins.str] = None):
        """
        :param _builtins.str common_name: Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
        :param _builtins.str country: Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
        :param _builtins.str distinguished_name_qualifier: Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
        :param _builtins.str generation_qualifier: Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
        :param _builtins.str given_name: First name. Must be less than or equal to 16 characters in length.
        :param _builtins.str initials: Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
        :param _builtins.str locality: Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
        :param _builtins.str organization: Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        :param _builtins.str organizational_unit: Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        :param _builtins.str pseudonym: Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
        :param _builtins.str state: State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
        :param _builtins.str surname: Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
        :param _builtins.str title: Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[_builtins.str]:
        """
        Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[_builtins.str]:
        """
        Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[_builtins.str]:
        """
        Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "distinguished_name_qualifier")

    @_builtins.property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[_builtins.str]:
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
        """
        return pulumi.get(self, "generation_qualifier")

    @_builtins.property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[_builtins.str]:
        """
        First name. Must be less than or equal to 16 characters in length.
        """
        return pulumi.get(self, "given_name")

    @_builtins.property
    @pulumi.getter
    def initials(self) -> Optional[_builtins.str]:
        """
        Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
        """
        return pulumi.get(self, "initials")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[_builtins.str]:
        """
        Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter
    def pseudonym(self) -> Optional[_builtins.str]:
        """
        Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "pseudonym")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def surname(self) -> Optional[_builtins.str]:
        """
        Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
        """
        return pulumi.get(self, "surname")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        """
        Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateAuthorityRevocationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlConfiguration":
            suggest = "crl_configuration"
        elif key == "ocspConfiguration":
            suggest = "ocsp_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityRevocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_configuration: Optional['outputs.CertificateAuthorityRevocationConfigurationCrlConfiguration'] = None,
                 ocsp_configuration: Optional['outputs.CertificateAuthorityRevocationConfigurationOcspConfiguration'] = None):
        """
        :param 'CertificateAuthorityRevocationConfigurationCrlConfigurationArgs' crl_configuration: Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
        :param 'CertificateAuthorityRevocationConfigurationOcspConfigurationArgs' ocsp_configuration: Nested argument containing configuration of
               the custom OCSP responder endpoint. Defined below.
        """
        if crl_configuration is not None:
            pulumi.set(__self__, "crl_configuration", crl_configuration)
        if ocsp_configuration is not None:
            pulumi.set(__self__, "ocsp_configuration", ocsp_configuration)

    @_builtins.property
    @pulumi.getter(name="crlConfiguration")
    def crl_configuration(self) -> Optional['outputs.CertificateAuthorityRevocationConfigurationCrlConfiguration']:
        """
        Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
        """
        return pulumi.get(self, "crl_configuration")

    @_builtins.property
    @pulumi.getter(name="ocspConfiguration")
    def ocsp_configuration(self) -> Optional['outputs.CertificateAuthorityRevocationConfigurationOcspConfiguration']:
        """
        Nested argument containing configuration of
        the custom OCSP responder endpoint. Defined below.
        """
        return pulumi.get(self, "ocsp_configuration")


@pulumi.output_type
class CertificateAuthorityRevocationConfigurationCrlConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customCname":
            suggest = "custom_cname"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectAcl":
            suggest = "s3_object_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityRevocationConfigurationCrlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityRevocationConfigurationCrlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityRevocationConfigurationCrlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_cname: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 expiration_in_days: Optional[_builtins.int] = None,
                 s3_bucket_name: Optional[_builtins.str] = None,
                 s3_object_acl: Optional[_builtins.str] = None):
        """
        :param _builtins.str custom_cname: Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
        :param _builtins.bool enabled: Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        :param _builtins.int expiration_in_days: Number of days until a certificate expires. Must be between 1 and 5000.
        :param _builtins.str s3_bucket_name: Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
        :param _builtins.str s3_object_acl: Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
        """
        if custom_cname is not None:
            pulumi.set(__self__, "custom_cname", custom_cname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_acl is not None:
            pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @_builtins.property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> Optional[_builtins.str]:
        """
        Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
        """
        return pulumi.get(self, "custom_cname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[_builtins.int]:
        """
        Number of days until a certificate expires. Must be between 1 and 5000.
        """
        return pulumi.get(self, "expiration_in_days")

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[_builtins.str]:
        """
        Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
        """
        return pulumi.get(self, "s3_bucket_name")

    @_builtins.property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> Optional[_builtins.str]:
        """
        Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
        """
        return pulumi.get(self, "s3_object_acl")


@pulumi.output_type
class CertificateAuthorityRevocationConfigurationOcspConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocspCustomCname":
            suggest = "ocsp_custom_cname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityRevocationConfigurationOcspConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityRevocationConfigurationOcspConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityRevocationConfigurationOcspConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 ocsp_custom_cname: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Boolean value that specifies whether a custom OCSP responder is enabled.
        :param _builtins.str ocsp_custom_cname: CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        pulumi.set(__self__, "enabled", enabled)
        if ocsp_custom_cname is not None:
            pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Boolean value that specifies whether a custom OCSP responder is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> Optional[_builtins.str]:
        """
        CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
        """
        return pulumi.get(self, "ocsp_custom_cname")


@pulumi.output_type
class CertificateValidity(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
        :param _builtins.str value: If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetCertificateAuthorityRevocationConfigurationResult(dict):
    def __init__(__self__, *,
                 crl_configurations: Sequence['outputs.GetCertificateAuthorityRevocationConfigurationCrlConfigurationResult'],
                 ocsp_configurations: Sequence['outputs.GetCertificateAuthorityRevocationConfigurationOcspConfigurationResult']):
        """
        :param Sequence['GetCertificateAuthorityRevocationConfigurationCrlConfigurationArgs'] crl_configurations: Nested attribute containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority.
        """
        pulumi.set(__self__, "crl_configurations", crl_configurations)
        pulumi.set(__self__, "ocsp_configurations", ocsp_configurations)

    @_builtins.property
    @pulumi.getter(name="crlConfigurations")
    def crl_configurations(self) -> Sequence['outputs.GetCertificateAuthorityRevocationConfigurationCrlConfigurationResult']:
        """
        Nested attribute containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority.
        """
        return pulumi.get(self, "crl_configurations")

    @_builtins.property
    @pulumi.getter(name="ocspConfigurations")
    def ocsp_configurations(self) -> Sequence['outputs.GetCertificateAuthorityRevocationConfigurationOcspConfigurationResult']:
        return pulumi.get(self, "ocsp_configurations")


@pulumi.output_type
class GetCertificateAuthorityRevocationConfigurationCrlConfigurationResult(dict):
    def __init__(__self__, *,
                 custom_cname: _builtins.str,
                 enabled: _builtins.bool,
                 expiration_in_days: _builtins.int,
                 s3_bucket_name: _builtins.str,
                 s3_object_acl: _builtins.str):
        """
        :param _builtins.str custom_cname: Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point.
        :param _builtins.bool enabled: Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
        :param _builtins.int expiration_in_days: Number of days until a certificate expires.
        :param _builtins.str s3_bucket_name: Name of the S3 bucket that contains the CRL.
        :param _builtins.str s3_object_acl: Whether the CRL is publicly readable or privately held in the CRL Amazon S3 bucket.
        """
        pulumi.set(__self__, "custom_cname", custom_cname)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @_builtins.property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> _builtins.str:
        """
        Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point.
        """
        return pulumi.get(self, "custom_cname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> _builtins.int:
        """
        Number of days until a certificate expires.
        """
        return pulumi.get(self, "expiration_in_days")

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> _builtins.str:
        """
        Name of the S3 bucket that contains the CRL.
        """
        return pulumi.get(self, "s3_bucket_name")

    @_builtins.property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> _builtins.str:
        """
        Whether the CRL is publicly readable or privately held in the CRL Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_object_acl")


@pulumi.output_type
class GetCertificateAuthorityRevocationConfigurationOcspConfigurationResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 ocsp_custom_cname: _builtins.str):
        """
        :param _builtins.bool enabled: Boolean value that specifies whether a custom OCSP responder is enabled.
        :param _builtins.str ocsp_custom_cname: A CNAME specifying a customized OCSP domain.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Boolean value that specifies whether a custom OCSP responder is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> _builtins.str:
        """
        A CNAME specifying a customized OCSP domain.
        """
        return pulumi.get(self, "ocsp_custom_cname")


