# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWorkspaceResult',
    'AwaitableGetWorkspaceResult',
    'get_workspace',
    'get_workspace_output',
]

@pulumi.output_type
class GetWorkspaceResult:
    """
    A collection of values returned by getWorkspace.
    """
    def __init__(__self__, alias=None, arn=None, created_date=None, id=None, kms_key_arn=None, prometheus_endpoint=None, region=None, status=None, tags=None, workspace_id=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if prometheus_endpoint and not isinstance(prometheus_endpoint, str):
            raise TypeError("Expected argument 'prometheus_endpoint' to be a str")
        pulumi.set(__self__, "prometheus_endpoint", prometheus_endpoint)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> _builtins.str:
        """
        Prometheus workspace alias.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Prometheus workspace.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Creation date of the Prometheus workspace.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        """
        ARN of the KMS key used to encrypt data in the Prometheus workspace.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="prometheusEndpoint")
    def prometheus_endpoint(self) -> _builtins.str:
        """
        Endpoint of the Prometheus workspace.
        """
        return pulumi.get(self, "prometheus_endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Prometheus workspace.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceResult(GetWorkspaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceResult(
            alias=self.alias,
            arn=self.arn,
            created_date=self.created_date,
            id=self.id,
            kms_key_arn=self.kms_key_arn,
            prometheus_endpoint=self.prometheus_endpoint,
            region=self.region,
            status=self.status,
            tags=self.tags,
            workspace_id=self.workspace_id)


def get_workspace(region: Optional[_builtins.str] = None,
                  tags: Optional[Mapping[str, _builtins.str]] = None,
                  workspace_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceResult:
    """
    Provides an Amazon Managed Prometheus workspace data source.

    ## Example Usage

    ### Basic configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.amp.get_workspace(workspace_id="ws-41det8a1-2c67-6a1a-9381-9b83d3d78ef7")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Tags assigned to the resource.
    :param _builtins.str workspace_id: Prometheus workspace ID.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:amp/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult).value

    return AwaitableGetWorkspaceResult(
        alias=pulumi.get(__ret__, 'alias'),
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        prometheus_endpoint=pulumi.get(__ret__, 'prometheus_endpoint'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceResult]:
    """
    Provides an Amazon Managed Prometheus workspace data source.

    ## Example Usage

    ### Basic configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.amp.get_workspace(workspace_id="ws-41det8a1-2c67-6a1a-9381-9b83d3d78ef7")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Tags assigned to the resource.
    :param _builtins.str workspace_id: Prometheus workspace ID.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:amp/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult)
    return __ret__.apply(lambda __response__: GetWorkspaceResult(
        alias=pulumi.get(__response__, 'alias'),
        arn=pulumi.get(__response__, 'arn'),
        created_date=pulumi.get(__response__, 'created_date'),
        id=pulumi.get(__response__, 'id'),
        kms_key_arn=pulumi.get(__response__, 'kms_key_arn'),
        prometheus_endpoint=pulumi.get(__response__, 'prometheus_endpoint'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
