# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourcePolicyArgs', 'ResourcePolicy']

@pulumi.input_type
class ResourcePolicyArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ResourcePolicy resource.
        :param pulumi.Input[_builtins.str] policy_document: The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace to attach the resource-based policy to.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: The revision ID of the current resource-based policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[_builtins.str]:
        """
        The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace to attach the resource-based policy to.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revision ID of the current resource-based policy.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ResourcePolicyState:
    def __init__(__self__, *,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourcePolicy resources.
        :param pulumi.Input[_builtins.str] policy_document: The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: The revision ID of the current resource-based policy.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace to attach the resource-based policy to.
        """
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revision ID of the current resource-based policy.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResourcePolicyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace to attach the resource-based policy to.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("aws:amp/resourcePolicy:ResourcePolicy")
class ResourcePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourcePolicyTimeoutsArgs', 'ResourcePolicyTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Amazon Managed Service for Prometheus (AMP) Resource Policy.

        Resource-based policies allow you to grant permissions to other AWS accounts or services to access your Prometheus workspace. This enables cross-account access and fine-grained permissions for workspace sharing.

        ## Example Usage

        ### Basic Resource Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example_workspace = aws.amp.Workspace("example", alias="example-workspace")
        current = aws.get_caller_identity()
        example = example_workspace.arn.apply(lambda arn: aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [current.account_id],
            }],
            "actions": [
                "aps:RemoteWrite",
                "aps:QueryMetrics",
                "aps:GetSeries",
                "aps:GetLabels",
                "aps:GetMetricMetadata",
            ],
            "resources": [arn],
        }]))
        example_resource_policy = aws.amp.ResourcePolicy("example",
            workspace_id=example_workspace.id,
            policy_document=example.json)
        ```

        ### Cross-Account Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example-workspace")
        cross_account = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["arn:aws:iam::123456789012:root"],
            }],
            "actions": [
                "aps:RemoteWrite",
                "aps:QueryMetrics",
            ],
            "resources": [example.arn],
        }])
        cross_account_resource_policy = aws.amp.ResourcePolicy("cross_account",
            workspace_id=example.id,
            policy_document=cross_account.json)
        ```

        ### Service-Specific Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example-workspace")
        service_access = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["grafana.amazonaws.com"],
            }],
            "actions": [
                "aps:QueryMetrics",
                "aps:GetSeries",
                "aps:GetLabels",
                "aps:GetMetricMetadata",
            ],
            "resources": [example.arn],
        }])
        service_access_resource_policy = aws.amp.ResourcePolicy("service_access",
            workspace_id=example.id,
            policy_document=service_access.json)
        ```

        ## Supported Actions

        The following actions are supported in resource policies for Prometheus workspaces:

        * `aps:RemoteWrite` - Allows writing metrics to the workspace
        * `aps:QueryMetrics` - Allows querying metrics from the workspace
        * `aps:GetSeries` - Allows retrieving time series data
        * `aps:GetLabels` - Allows retrieving label names and values
        * `aps:GetMetricMetadata` - Allows retrieving metric metadata

        ## Notes

        * Only Prometheus-compatible APIs can be used for workspace sharing. Non-Prometheus-compatible APIs added to the policy will be ignored.
        * If your workspace uses customer-managed KMS keys for encryption, you must grant the principals in your resource-based policy access to those KMS keys through KMS grants.
        * The resource ARN in the policy document must match the workspace ARN that the policy is being attached to.
        * Resource policies enable cross-account access and fine-grained permissions for Prometheus workspaces.

        ## Import

        Using `pulumi import`, import AMP Resource Policies using the workspace ID. For example:

        ```sh
        $ pulumi import aws:amp/resourcePolicy:ResourcePolicy example ws-12345678-90ab-cdef-1234-567890abcdef
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_document: The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: The revision ID of the current resource-based policy.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace to attach the resource-based policy to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourcePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon Managed Service for Prometheus (AMP) Resource Policy.

        Resource-based policies allow you to grant permissions to other AWS accounts or services to access your Prometheus workspace. This enables cross-account access and fine-grained permissions for workspace sharing.

        ## Example Usage

        ### Basic Resource Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example_workspace = aws.amp.Workspace("example", alias="example-workspace")
        current = aws.get_caller_identity()
        example = example_workspace.arn.apply(lambda arn: aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [current.account_id],
            }],
            "actions": [
                "aps:RemoteWrite",
                "aps:QueryMetrics",
                "aps:GetSeries",
                "aps:GetLabels",
                "aps:GetMetricMetadata",
            ],
            "resources": [arn],
        }]))
        example_resource_policy = aws.amp.ResourcePolicy("example",
            workspace_id=example_workspace.id,
            policy_document=example.json)
        ```

        ### Cross-Account Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example-workspace")
        cross_account = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["arn:aws:iam::123456789012:root"],
            }],
            "actions": [
                "aps:RemoteWrite",
                "aps:QueryMetrics",
            ],
            "resources": [example.arn],
        }])
        cross_account_resource_policy = aws.amp.ResourcePolicy("cross_account",
            workspace_id=example.id,
            policy_document=cross_account.json)
        ```

        ### Service-Specific Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example-workspace")
        service_access = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["grafana.amazonaws.com"],
            }],
            "actions": [
                "aps:QueryMetrics",
                "aps:GetSeries",
                "aps:GetLabels",
                "aps:GetMetricMetadata",
            ],
            "resources": [example.arn],
        }])
        service_access_resource_policy = aws.amp.ResourcePolicy("service_access",
            workspace_id=example.id,
            policy_document=service_access.json)
        ```

        ## Supported Actions

        The following actions are supported in resource policies for Prometheus workspaces:

        * `aps:RemoteWrite` - Allows writing metrics to the workspace
        * `aps:QueryMetrics` - Allows querying metrics from the workspace
        * `aps:GetSeries` - Allows retrieving time series data
        * `aps:GetLabels` - Allows retrieving label names and values
        * `aps:GetMetricMetadata` - Allows retrieving metric metadata

        ## Notes

        * Only Prometheus-compatible APIs can be used for workspace sharing. Non-Prometheus-compatible APIs added to the policy will be ignored.
        * If your workspace uses customer-managed KMS keys for encryption, you must grant the principals in your resource-based policy access to those KMS keys through KMS grants.
        * The resource ARN in the policy document must match the workspace ARN that the policy is being attached to.
        * Resource policies enable cross-account access and fine-grained permissions for Prometheus workspaces.

        ## Import

        Using `pulumi import`, import AMP Resource Policies using the workspace ID. For example:

        ```sh
        $ pulumi import aws:amp/resourcePolicy:ResourcePolicy example ws-12345678-90ab-cdef-1234-567890abcdef
        ```

        :param str resource_name: The name of the resource.
        :param ResourcePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResourcePolicyTimeoutsArgs', 'ResourcePolicyTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcePolicyArgs.__new__(ResourcePolicyArgs)

            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["region"] = region
            __props__.__dict__["revision_id"] = revision_id
            __props__.__dict__["timeouts"] = timeouts
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(ResourcePolicy, __self__).__init__(
            'aws:amp/resourcePolicy:ResourcePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ResourcePolicyTimeoutsArgs', 'ResourcePolicyTimeoutsArgsDict']]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ResourcePolicy':
        """
        Get an existing ResourcePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_document: The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: The revision ID of the current resource-based policy.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace to attach the resource-based policy to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourcePolicyState.__new__(_ResourcePolicyState)

        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["region"] = region
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["workspace_id"] = workspace_id
        return ResourcePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[_builtins.str]:
        """
        The JSON policy document to use as the resource-based policy. This policy defines the permissions that other AWS accounts or services have to access your workspace.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        The revision ID of the current resource-based policy.
        """
        return pulumi.get(self, "revision_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ResourcePolicyTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace to attach the resource-based policy to.
        """
        return pulumi.get(self, "workspace_id")

