# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DomainNameAccessAssociationArgs', 'DomainNameAccessAssociation']

@pulumi.input_type
class DomainNameAccessAssociationArgs:
    def __init__(__self__, *,
                 access_association_source: pulumi.Input[_builtins.str],
                 access_association_source_type: pulumi.Input[_builtins.str],
                 domain_name_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DomainNameAccessAssociation resource.
        :param pulumi.Input[_builtins.str] access_association_source: The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        :param pulumi.Input[_builtins.str] access_association_source_type: The type of the domain name access association source. Valid values are `VPCE`.
        :param pulumi.Input[_builtins.str] domain_name_arn: The ARN of the domain name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "access_association_source", access_association_source)
        pulumi.set(__self__, "access_association_source_type", access_association_source_type)
        pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessAssociationSource")
    def access_association_source(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        """
        return pulumi.get(self, "access_association_source")

    @access_association_source.setter
    def access_association_source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_association_source", value)

    @_builtins.property
    @pulumi.getter(name="accessAssociationSourceType")
    def access_association_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the domain name access association source. Valid values are `VPCE`.
        """
        return pulumi.get(self, "access_association_source_type")

    @access_association_source_type.setter
    def access_association_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_association_source_type", value)

    @_builtins.property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the domain name.
        """
        return pulumi.get(self, "domain_name_arn")

    @domain_name_arn.setter
    def domain_name_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainNameAccessAssociationState:
    def __init__(__self__, *,
                 access_association_source: Optional[pulumi.Input[_builtins.str]] = None,
                 access_association_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DomainNameAccessAssociation resources.
        :param pulumi.Input[_builtins.str] access_association_source: The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        :param pulumi.Input[_builtins.str] access_association_source_type: The type of the domain name access association source. Valid values are `VPCE`.
        :param pulumi.Input[_builtins.str] arn: ARN of the domain name access association.
        :param pulumi.Input[_builtins.str] domain_name_arn: The ARN of the domain name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_association_source is not None:
            pulumi.set(__self__, "access_association_source", access_association_source)
        if access_association_source_type is not None:
            pulumi.set(__self__, "access_association_source_type", access_association_source_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if domain_name_arn is not None:
            pulumi.set(__self__, "domain_name_arn", domain_name_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="accessAssociationSource")
    def access_association_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        """
        return pulumi.get(self, "access_association_source")

    @access_association_source.setter
    def access_association_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_association_source", value)

    @_builtins.property
    @pulumi.getter(name="accessAssociationSourceType")
    def access_association_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the domain name access association source. Valid values are `VPCE`.
        """
        return pulumi.get(self, "access_association_source_type")

    @access_association_source_type.setter
    def access_association_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_association_source_type", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the domain name access association.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the domain name.
        """
        return pulumi.get(self, "domain_name_arn")

    @domain_name_arn.setter
    def domain_name_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:apigateway/domainNameAccessAssociation:DomainNameAccessAssociation")
class DomainNameAccessAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_association_source: Optional[pulumi.Input[_builtins.str]] = None,
                 access_association_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates a domain name access association resource between an access association source and a private custom domain name.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainNameAccessAssociation("example",
            access_association_source=example_aws_vpc_endpoint["id"],
            access_association_source_type="VPCE",
            domain_name_arn=example_aws_api_gateway_domain_name["arn"])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the API Gateway domain name access association.

        Using `pulumi import`, import API Gateway domain name acces associations as using their `arn`. For example:

        console

        % pulumi import aws_api_gateway_domain_name_access_association.example arn:aws:apigateway:us-west-2:123456789012:/domainnameaccessassociations/domainname/12qmzgp2.9m7ilski.test+hykg7a12e7/vpcesource/vpce-05de3f8f82740a748

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_association_source: The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        :param pulumi.Input[_builtins.str] access_association_source_type: The type of the domain name access association source. Valid values are `VPCE`.
        :param pulumi.Input[_builtins.str] domain_name_arn: The ARN of the domain name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainNameAccessAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a domain name access association resource between an access association source and a private custom domain name.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigateway.DomainNameAccessAssociation("example",
            access_association_source=example_aws_vpc_endpoint["id"],
            access_association_source_type="VPCE",
            domain_name_arn=example_aws_api_gateway_domain_name["arn"])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the API Gateway domain name access association.

        Using `pulumi import`, import API Gateway domain name acces associations as using their `arn`. For example:

        console

        % pulumi import aws_api_gateway_domain_name_access_association.example arn:aws:apigateway:us-west-2:123456789012:/domainnameaccessassociations/domainname/12qmzgp2.9m7ilski.test+hykg7a12e7/vpcesource/vpce-05de3f8f82740a748

        :param str resource_name: The name of the resource.
        :param DomainNameAccessAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainNameAccessAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_association_source: Optional[pulumi.Input[_builtins.str]] = None,
                 access_association_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainNameAccessAssociationArgs.__new__(DomainNameAccessAssociationArgs)

            if access_association_source is None and not opts.urn:
                raise TypeError("Missing required property 'access_association_source'")
            __props__.__dict__["access_association_source"] = access_association_source
            if access_association_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'access_association_source_type'")
            __props__.__dict__["access_association_source_type"] = access_association_source_type
            if domain_name_arn is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name_arn'")
            __props__.__dict__["domain_name_arn"] = domain_name_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(DomainNameAccessAssociation, __self__).__init__(
            'aws:apigateway/domainNameAccessAssociation:DomainNameAccessAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_association_source: Optional[pulumi.Input[_builtins.str]] = None,
            access_association_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DomainNameAccessAssociation':
        """
        Get an existing DomainNameAccessAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_association_source: The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        :param pulumi.Input[_builtins.str] access_association_source_type: The type of the domain name access association source. Valid values are `VPCE`.
        :param pulumi.Input[_builtins.str] arn: ARN of the domain name access association.
        :param pulumi.Input[_builtins.str] domain_name_arn: The ARN of the domain name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainNameAccessAssociationState.__new__(_DomainNameAccessAssociationState)

        __props__.__dict__["access_association_source"] = access_association_source
        __props__.__dict__["access_association_source_type"] = access_association_source_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["domain_name_arn"] = domain_name_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return DomainNameAccessAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessAssociationSource")
    def access_association_source(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the domain name access association source. For a `VPCE`, the value is the VPC endpoint ID.
        """
        return pulumi.get(self, "access_association_source")

    @_builtins.property
    @pulumi.getter(name="accessAssociationSourceType")
    def access_association_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the domain name access association source. Valid values are `VPCE`.
        """
        return pulumi.get(self, "access_association_source_type")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the domain name access association.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="domainNameArn")
    def domain_name_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the domain name.
        """
        return pulumi.get(self, "domain_name_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

