# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExportResult',
    'AwaitableGetExportResult',
    'get_export',
    'get_export_output',
]

@pulumi.output_type
class GetExportResult:
    """
    A collection of values returned by getExport.
    """
    def __init__(__self__, accepts=None, body=None, content_disposition=None, content_type=None, export_type=None, id=None, parameters=None, region=None, rest_api_id=None, stage_name=None):
        if accepts and not isinstance(accepts, str):
            raise TypeError("Expected argument 'accepts' to be a str")
        pulumi.set(__self__, "accepts", accepts)
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if content_disposition and not isinstance(content_disposition, str):
            raise TypeError("Expected argument 'content_disposition' to be a str")
        pulumi.set(__self__, "content_disposition", content_disposition)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if export_type and not isinstance(export_type, str):
            raise TypeError("Expected argument 'export_type' to be a str")
        pulumi.set(__self__, "export_type", export_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if stage_name and not isinstance(stage_name, str):
            raise TypeError("Expected argument 'stage_name' to be a str")
        pulumi.set(__self__, "stage_name", stage_name)

    @_builtins.property
    @pulumi.getter
    def accepts(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "accepts")

    @_builtins.property
    @pulumi.getter
    def body(self) -> _builtins.str:
        """
        API Spec.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> _builtins.str:
        """
        Content-disposition header value in the HTTP response.
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        Content-type header value in the HTTP response.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="exportType")
    def export_type(self) -> _builtins.str:
        return pulumi.get(self, "export_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> _builtins.str:
        return pulumi.get(self, "rest_api_id")

    @_builtins.property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> _builtins.str:
        return pulumi.get(self, "stage_name")


class AwaitableGetExportResult(GetExportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExportResult(
            accepts=self.accepts,
            body=self.body,
            content_disposition=self.content_disposition,
            content_type=self.content_type,
            export_type=self.export_type,
            id=self.id,
            parameters=self.parameters,
            region=self.region,
            rest_api_id=self.rest_api_id,
            stage_name=self.stage_name)


def get_export(accepts: Optional[_builtins.str] = None,
               export_type: Optional[_builtins.str] = None,
               parameters: Optional[Mapping[str, _builtins.str]] = None,
               region: Optional[_builtins.str] = None,
               rest_api_id: Optional[_builtins.str] = None,
               stage_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExportResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_export(rest_api_id=example_aws_api_gateway_stage["restApiId"],
        stage_name=example_aws_api_gateway_stage["stageName"],
        export_type="oas30")
    ```


    :param _builtins.str accepts: Content-type of the export. Valid values are `application/json` and `application/yaml` are supported for `export_type` `ofoas30` and `swagger`.
    :param _builtins.str export_type: Type of export. Acceptable values are `oas30` for OpenAPI 3.0.x and `swagger` for Swagger/OpenAPI 2.0.
    :param Mapping[str, _builtins.str] parameters: Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: Identifier of the associated REST API.
    :param _builtins.str stage_name: Name of the Stage that will be exported.
    """
    __args__ = dict()
    __args__['accepts'] = accepts
    __args__['exportType'] = export_type
    __args__['parameters'] = parameters
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    __args__['stageName'] = stage_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getExport:getExport', __args__, opts=opts, typ=GetExportResult).value

    return AwaitableGetExportResult(
        accepts=pulumi.get(__ret__, 'accepts'),
        body=pulumi.get(__ret__, 'body'),
        content_disposition=pulumi.get(__ret__, 'content_disposition'),
        content_type=pulumi.get(__ret__, 'content_type'),
        export_type=pulumi.get(__ret__, 'export_type'),
        id=pulumi.get(__ret__, 'id'),
        parameters=pulumi.get(__ret__, 'parameters'),
        region=pulumi.get(__ret__, 'region'),
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'),
        stage_name=pulumi.get(__ret__, 'stage_name'))
def get_export_output(accepts: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      export_type: Optional[pulumi.Input[_builtins.str]] = None,
                      parameters: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                      stage_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExportResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_export(rest_api_id=example_aws_api_gateway_stage["restApiId"],
        stage_name=example_aws_api_gateway_stage["stageName"],
        export_type="oas30")
    ```


    :param _builtins.str accepts: Content-type of the export. Valid values are `application/json` and `application/yaml` are supported for `export_type` `ofoas30` and `swagger`.
    :param _builtins.str export_type: Type of export. Acceptable values are `oas30` for OpenAPI 3.0.x and `swagger` for Swagger/OpenAPI 2.0.
    :param Mapping[str, _builtins.str] parameters: Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: Identifier of the associated REST API.
    :param _builtins.str stage_name: Name of the Stage that will be exported.
    """
    __args__ = dict()
    __args__['accepts'] = accepts
    __args__['exportType'] = export_type
    __args__['parameters'] = parameters
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    __args__['stageName'] = stage_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:apigateway/getExport:getExport', __args__, opts=opts, typ=GetExportResult)
    return __ret__.apply(lambda __response__: GetExportResult(
        accepts=pulumi.get(__response__, 'accepts'),
        body=pulumi.get(__response__, 'body'),
        content_disposition=pulumi.get(__response__, 'content_disposition'),
        content_type=pulumi.get(__response__, 'content_type'),
        export_type=pulumi.get(__response__, 'export_type'),
        id=pulumi.get(__response__, 'id'),
        parameters=pulumi.get(__response__, 'parameters'),
        region=pulumi.get(__response__, 'region'),
        rest_api_id=pulumi.get(__response__, 'rest_api_id'),
        stage_name=pulumi.get(__response__, 'stage_name')))
