# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountThrottleSetting',
    'DocumentationPartLocation',
    'DomainNameEndpointConfiguration',
    'DomainNameMutualTlsAuthentication',
    'IntegrationTlsConfig',
    'MethodSettingsSettings',
    'RestApiEndpointConfiguration',
    'RestApiPutTimeouts',
    'StageAccessLogSettings',
    'StageCanarySettings',
    'UsagePlanApiStage',
    'UsagePlanApiStageThrottle',
    'UsagePlanQuotaSettings',
    'UsagePlanThrottleSettings',
    'GetApiKeysItemResult',
    'GetDomainNameEndpointConfigurationResult',
    'GetRestApiEndpointConfigurationResult',
]

@pulumi.output_type
class AccountThrottleSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burstLimit":
            suggest = "burst_limit"
        elif key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountThrottleSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountThrottleSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountThrottleSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burst_limit: _builtins.int,
                 rate_limit: _builtins.float):
        """
        :param _builtins.int burst_limit: Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
        :param _builtins.float rate_limit: Number of times API Gateway allows the API to be called per second on average (RPS).
        """
        pulumi.set(__self__, "burst_limit", burst_limit)
        pulumi.set(__self__, "rate_limit", rate_limit)

    @_builtins.property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> _builtins.int:
        """
        Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
        """
        return pulumi.get(self, "burst_limit")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> _builtins.float:
        """
        Number of times API Gateway allows the API to be called per second on average (RPS).
        """
        return pulumi.get(self, "rate_limit")


@pulumi.output_type
class DocumentationPartLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentationPartLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentationPartLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentationPartLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 method: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
        :param _builtins.str method: HTTP verb of a method. The default value is `*` for any method.
        :param _builtins.str name: Name of the targeted API entity.
        :param _builtins.str path: URL path of the target. The default value is `/` for the root resource.
        :param _builtins.str status_code: HTTP status code of a response. The default value is `*` for any status code.
        """
        pulumi.set(__self__, "type", type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        HTTP verb of a method. The default value is `*` for any method.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the targeted API entity.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        URL path of the target. The default value is `/` for the root resource.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.str]:
        """
        HTTP status code of a response. The default value is `*` for any status code.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class DomainNameEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressType":
            suggest = "ip_address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 types: _builtins.str,
                 ip_address_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str types: A list of endpoint types of an API or its custom domain name. For an edge-optimized API and its custom domain name, the endpoint type is `EDGE`. For a regional API and its custom domain name, the endpoint type is `REGIONAL`. For a private API, the endpoint type is `PRIVATE`.
        """
        pulumi.set(__self__, "types", types)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)

    @_builtins.property
    @pulumi.getter
    def types(self) -> _builtins.str:
        """
        A list of endpoint types of an API or its custom domain name. For an edge-optimized API and its custom domain name, the endpoint type is `EDGE`. For a regional API and its custom domain name, the endpoint type is `REGIONAL`. For a private API, the endpoint type is `PRIVATE`.
        """
        return pulumi.get(self, "types")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ip_address_type")


@pulumi.output_type
class DomainNameMutualTlsAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "truststoreUri":
            suggest = "truststore_uri"
        elif key == "truststoreVersion":
            suggest = "truststore_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameMutualTlsAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 truststore_uri: _builtins.str,
                 truststore_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str truststore_uri: Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        :param _builtins.str truststore_version: Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @_builtins.property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> _builtins.str:
        """
        Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        """
        return pulumi.get(self, "truststore_uri")

    @_builtins.property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[_builtins.str]:
        """
        Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")


@pulumi.output_type
class IntegrationTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insecureSkipVerification":
            suggest = "insecure_skip_verification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insecure_skip_verification: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool insecure_skip_verification: Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
        """
        if insecure_skip_verification is not None:
            pulumi.set(__self__, "insecure_skip_verification", insecure_skip_verification)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerification")
    def insecure_skip_verification(self) -> Optional[_builtins.bool]:
        """
        Whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a [supported certificate authority](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html). This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
        """
        return pulumi.get(self, "insecure_skip_verification")


@pulumi.output_type
class MethodSettingsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheDataEncrypted":
            suggest = "cache_data_encrypted"
        elif key == "cacheTtlInSeconds":
            suggest = "cache_ttl_in_seconds"
        elif key == "cachingEnabled":
            suggest = "caching_enabled"
        elif key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "metricsEnabled":
            suggest = "metrics_enabled"
        elif key == "requireAuthorizationForCacheControl":
            suggest = "require_authorization_for_cache_control"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"
        elif key == "unauthorizedCacheControlHeaderStrategy":
            suggest = "unauthorized_cache_control_header_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MethodSettingsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MethodSettingsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MethodSettingsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_data_encrypted: Optional[_builtins.bool] = None,
                 cache_ttl_in_seconds: Optional[_builtins.int] = None,
                 caching_enabled: Optional[_builtins.bool] = None,
                 data_trace_enabled: Optional[_builtins.bool] = None,
                 logging_level: Optional[_builtins.str] = None,
                 metrics_enabled: Optional[_builtins.bool] = None,
                 require_authorization_for_cache_control: Optional[_builtins.bool] = None,
                 throttling_burst_limit: Optional[_builtins.int] = None,
                 throttling_rate_limit: Optional[_builtins.float] = None,
                 unauthorized_cache_control_header_strategy: Optional[_builtins.str] = None):
        """
        :param _builtins.bool cache_data_encrypted: Whether the cached responses are encrypted.
        :param _builtins.int cache_ttl_in_seconds: Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        :param _builtins.bool caching_enabled: Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        :param _builtins.bool data_trace_enabled: Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
        :param _builtins.str logging_level: Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
        :param _builtins.bool metrics_enabled: Whether Amazon CloudWatch metrics are enabled for this method.
        :param _builtins.bool require_authorization_for_cache_control: Whether authorization is required for a cache invalidation request.
        :param _builtins.int throttling_burst_limit: Throttling burst limit. Default: `-1` (throttling disabled).
        :param _builtins.float throttling_rate_limit: Throttling rate limit. Default: `-1` (throttling disabled).
        :param _builtins.str unauthorized_cache_control_header_strategy: How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
        """
        if cache_data_encrypted is not None:
            pulumi.set(__self__, "cache_data_encrypted", cache_data_encrypted)
        if cache_ttl_in_seconds is not None:
            pulumi.set(__self__, "cache_ttl_in_seconds", cache_ttl_in_seconds)
        if caching_enabled is not None:
            pulumi.set(__self__, "caching_enabled", caching_enabled)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if metrics_enabled is not None:
            pulumi.set(__self__, "metrics_enabled", metrics_enabled)
        if require_authorization_for_cache_control is not None:
            pulumi.set(__self__, "require_authorization_for_cache_control", require_authorization_for_cache_control)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)
        if unauthorized_cache_control_header_strategy is not None:
            pulumi.set(__self__, "unauthorized_cache_control_header_strategy", unauthorized_cache_control_header_strategy)

    @_builtins.property
    @pulumi.getter(name="cacheDataEncrypted")
    def cache_data_encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether the cached responses are encrypted.
        """
        return pulumi.get(self, "cache_data_encrypted")

    @_builtins.property
    @pulumi.getter(name="cacheTtlInSeconds")
    def cache_ttl_in_seconds(self) -> Optional[_builtins.int]:
        """
        Time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
        """
        return pulumi.get(self, "cache_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="cachingEnabled")
    def caching_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
        """
        return pulumi.get(self, "caching_enabled")

    @_builtins.property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @_builtins.property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[_builtins.str]:
        """
        Logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs. The available levels are `OFF`, `ERROR`, and `INFO`.
        """
        return pulumi.get(self, "logging_level")

    @_builtins.property
    @pulumi.getter(name="metricsEnabled")
    def metrics_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether Amazon CloudWatch metrics are enabled for this method.
        """
        return pulumi.get(self, "metrics_enabled")

    @_builtins.property
    @pulumi.getter(name="requireAuthorizationForCacheControl")
    def require_authorization_for_cache_control(self) -> Optional[_builtins.bool]:
        """
        Whether authorization is required for a cache invalidation request.
        """
        return pulumi.get(self, "require_authorization_for_cache_control")

    @_builtins.property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[_builtins.int]:
        """
        Throttling burst limit. Default: `-1` (throttling disabled).
        """
        return pulumi.get(self, "throttling_burst_limit")

    @_builtins.property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[_builtins.float]:
        """
        Throttling rate limit. Default: `-1` (throttling disabled).
        """
        return pulumi.get(self, "throttling_rate_limit")

    @_builtins.property
    @pulumi.getter(name="unauthorizedCacheControlHeaderStrategy")
    def unauthorized_cache_control_header_strategy(self) -> Optional[_builtins.str]:
        """
        How to handle unauthorized requests for cache invalidation. The available values are `FAIL_WITH_403`, `SUCCEED_WITH_RESPONSE_HEADER`, `SUCCEED_WITHOUT_RESPONSE_HEADER`.
        """
        return pulumi.get(self, "unauthorized_cache_control_header_strategy")


@pulumi.output_type
class RestApiEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "vpcEndpointIds":
            suggest = "vpc_endpoint_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestApiEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestApiEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestApiEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 types: _builtins.str,
                 ip_address_type: Optional[_builtins.str] = None,
                 vpc_endpoint_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str types: List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        :param _builtins.str ip_address_type: The IP address types that can invoke an API (RestApi). Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke an API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API. For the `PRIVATE` endpoint type, only `dualstack` is supported. The provider performs drift detection for this argument only when the value is provided.
        :param Sequence[_builtins.str] vpc_endpoint_ids: Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
        """
        pulumi.set(__self__, "types", types)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if vpc_endpoint_ids is not None:
            pulumi.set(__self__, "vpc_endpoint_ids", vpc_endpoint_ids)

    @_builtins.property
    @pulumi.getter
    def types(self) -> _builtins.str:
        """
        List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
        """
        return pulumi.get(self, "types")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[_builtins.str]:
        """
        The IP address types that can invoke an API (RestApi). Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke an API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke an API. For the `PRIVATE` endpoint type, only `dualstack` is supported. The provider performs drift detection for this argument only when the value is provided.
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointIds")
    def vpc_endpoint_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
        """
        return pulumi.get(self, "vpc_endpoint_ids")


@pulumi.output_type
class RestApiPutTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class StageAccessLogSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageAccessLogSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageAccessLogSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageAccessLogSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: _builtins.str,
                 format: _builtins.str):
        """
        :param _builtins.str destination_arn: ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
        :param _builtins.str format: Formatting and values recorded in the logs.
               For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        pulumi.set(__self__, "format", format)

    @_builtins.property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> _builtins.str:
        """
        ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
        """
        return pulumi.get(self, "destination_arn")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        Formatting and values recorded in the logs.
        For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class StageCanarySettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentId":
            suggest = "deployment_id"
        elif key == "percentTraffic":
            suggest = "percent_traffic"
        elif key == "stageVariableOverrides":
            suggest = "stage_variable_overrides"
        elif key == "useStageCache":
            suggest = "use_stage_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageCanarySettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageCanarySettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageCanarySettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_id: _builtins.str,
                 percent_traffic: Optional[_builtins.float] = None,
                 stage_variable_overrides: Optional[Mapping[str, _builtins.str]] = None,
                 use_stage_cache: Optional[_builtins.bool] = None):
        """
        :param _builtins.str deployment_id: ID of the deployment that the canary points to.
        :param _builtins.float percent_traffic: Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
        :param Mapping[str, _builtins.str] stage_variable_overrides: Map of overridden stage `variables` (including new variables) for the canary deployment.
        :param _builtins.bool use_stage_cache: Whether the canary deployment uses the stage cache. Defaults to false.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        if percent_traffic is not None:
            pulumi.set(__self__, "percent_traffic", percent_traffic)
        if stage_variable_overrides is not None:
            pulumi.set(__self__, "stage_variable_overrides", stage_variable_overrides)
        if use_stage_cache is not None:
            pulumi.set(__self__, "use_stage_cache", use_stage_cache)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> _builtins.str:
        """
        ID of the deployment that the canary points to.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter(name="percentTraffic")
    def percent_traffic(self) -> Optional[_builtins.float]:
        """
        Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
        """
        return pulumi.get(self, "percent_traffic")

    @_builtins.property
    @pulumi.getter(name="stageVariableOverrides")
    def stage_variable_overrides(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of overridden stage `variables` (including new variables) for the canary deployment.
        """
        return pulumi.get(self, "stage_variable_overrides")

    @_builtins.property
    @pulumi.getter(name="useStageCache")
    def use_stage_cache(self) -> Optional[_builtins.bool]:
        """
        Whether the canary deployment uses the stage cache. Defaults to false.
        """
        return pulumi.get(self, "use_stage_cache")


@pulumi.output_type
class UsagePlanApiStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiId":
            suggest = "api_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsagePlanApiStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsagePlanApiStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsagePlanApiStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_id: _builtins.str,
                 stage: _builtins.str,
                 throttles: Optional[Sequence['outputs.UsagePlanApiStageThrottle']] = None):
        """
        :param _builtins.str api_id: API Id of the associated API stage in a usage plan.
        :param _builtins.str stage: API stage name of the associated API stage in a usage plan.
        :param Sequence['UsagePlanApiStageThrottleArgs'] throttles: The throttling limits of the usage plan.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "stage", stage)
        if throttles is not None:
            pulumi.set(__self__, "throttles", throttles)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> _builtins.str:
        """
        API Id of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter
    def stage(self) -> _builtins.str:
        """
        API stage name of the associated API stage in a usage plan.
        """
        return pulumi.get(self, "stage")

    @_builtins.property
    @pulumi.getter
    def throttles(self) -> Optional[Sequence['outputs.UsagePlanApiStageThrottle']]:
        """
        The throttling limits of the usage plan.
        """
        return pulumi.get(self, "throttles")


@pulumi.output_type
class UsagePlanApiStageThrottle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burstLimit":
            suggest = "burst_limit"
        elif key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsagePlanApiStageThrottle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsagePlanApiStageThrottle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsagePlanApiStageThrottle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 burst_limit: Optional[_builtins.int] = None,
                 rate_limit: Optional[_builtins.float] = None):
        """
        :param _builtins.str path: Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
        :param _builtins.int burst_limit: The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
        :param _builtins.float rate_limit: The API request steady-state rate limit.
        """
        pulumi.set(__self__, "path", path)
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[_builtins.int]:
        """
        The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
        """
        return pulumi.get(self, "burst_limit")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[_builtins.float]:
        """
        The API request steady-state rate limit.
        """
        return pulumi.get(self, "rate_limit")


@pulumi.output_type
class UsagePlanQuotaSettings(dict):
    def __init__(__self__, *,
                 limit: _builtins.int,
                 period: _builtins.str,
                 offset: Optional[_builtins.int] = None):
        """
        :param _builtins.int limit: Maximum number of requests that can be made in a given time period.
        :param _builtins.str period: Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        :param _builtins.int offset: Number of requests subtracted from the given limit in the initial time period.
        """
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "period", period)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)

    @_builtins.property
    @pulumi.getter
    def limit(self) -> _builtins.int:
        """
        Maximum number of requests that can be made in a given time period.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.str:
        """
        Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        """
        Number of requests subtracted from the given limit in the initial time period.
        """
        return pulumi.get(self, "offset")


@pulumi.output_type
class UsagePlanThrottleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burstLimit":
            suggest = "burst_limit"
        elif key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UsagePlanThrottleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UsagePlanThrottleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UsagePlanThrottleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burst_limit: Optional[_builtins.int] = None,
                 rate_limit: Optional[_builtins.float] = None):
        if burst_limit is not None:
            pulumi.set(__self__, "burst_limit", burst_limit)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)

    @_builtins.property
    @pulumi.getter(name="burstLimit")
    def burst_limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "burst_limit")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "rate_limit")


@pulumi.output_type
class GetApiKeysItemResult(dict):
    def __init__(__self__, *,
                 created_date: _builtins.str,
                 customer_id: _builtins.str,
                 description: _builtins.str,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 last_updated_date: _builtins.str,
                 name: _builtins.str,
                 stage_keys: Sequence[_builtins.str],
                 tags: Mapping[str, _builtins.str],
                 value: _builtins.str):
        """
        :param _builtins.str created_date: Date and time when the API Key was created.
        :param _builtins.str customer_id: Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
        :param _builtins.str description: Description of the API Key.
        :param _builtins.bool enabled: Whether the API Key is enabled.
        :param _builtins.str id: ID of the API Key.
        :param _builtins.str last_updated_date: Date and time when the API Key was last updated.
        :param _builtins.str name: Name of the API Key.
        :param Mapping[str, _builtins.str] tags: Map of tags for the resource.
        :param _builtins.str value: Value of the API Key.
        """
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "stage_keys", stage_keys)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Date and time when the API Key was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> _builtins.str:
        """
        Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
        """
        return pulumi.get(self, "customer_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the API Key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the API Key is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the API Key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> _builtins.str:
        """
        Date and time when the API Key was last updated.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the API Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="stageKeys")
    def stage_keys(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "stage_keys")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags for the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the API Key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainNameEndpointConfigurationResult(dict):
    def __init__(__self__, *,
                 ip_address_type: _builtins.str,
                 types: Sequence[_builtins.str]):
        """
        :param _builtins.str ip_address_type: The IP address types that can invoke an API (RestApi).
        :param Sequence[_builtins.str] types: List of endpoint types.
        """
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        pulumi.set(__self__, "types", types)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> _builtins.str:
        """
        The IP address types that can invoke an API (RestApi).
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Sequence[_builtins.str]:
        """
        List of endpoint types.
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class GetRestApiEndpointConfigurationResult(dict):
    def __init__(__self__, *,
                 ip_address_type: _builtins.str,
                 types: Sequence[_builtins.str],
                 vpc_endpoint_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str ip_address_type: The IP address types that can invoke an API (RestApi).
        :param Sequence[_builtins.str] types: List of endpoint types.
        :param Sequence[_builtins.str] vpc_endpoint_ids: Set of VPC Endpoint identifiers.
        """
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        pulumi.set(__self__, "types", types)
        pulumi.set(__self__, "vpc_endpoint_ids", vpc_endpoint_ids)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> _builtins.str:
        """
        The IP address types that can invoke an API (RestApi).
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Sequence[_builtins.str]:
        """
        List of endpoint types.
        """
        return pulumi.get(self, "types")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointIds")
    def vpc_endpoint_ids(self) -> Sequence[_builtins.str]:
        """
        Set of VPC Endpoint identifiers.
        """
        return pulumi.get(self, "vpc_endpoint_ids")


