# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UsagePlanKeyArgs', 'UsagePlanKey']

@pulumi.input_type
class UsagePlanKeyArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[_builtins.str],
                 key_type: pulumi.Input[_builtins.str],
                 usage_plan_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UsagePlanKey resource.
        :param pulumi.Input[_builtins.str] key_id: Identifier of the API key resource.
        :param pulumi.Input[_builtins.str] key_type: Type of the API key resource. Currently, the valid key type is API_KEY.
        :param pulumi.Input[_builtins.str] usage_plan_id: Id of the usage plan resource representing to associate the key to.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "usage_plan_id", usage_plan_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the API key resource.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the API key resource. Currently, the valid key type is API_KEY.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="usagePlanId")
    def usage_plan_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the usage plan resource representing to associate the key to.
        """
        return pulumi.get(self, "usage_plan_id")

    @usage_plan_id.setter
    def usage_plan_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "usage_plan_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UsagePlanKeyState:
    def __init__(__self__, *,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UsagePlanKey resources.
        :param pulumi.Input[_builtins.str] key_id: Identifier of the API key resource.
        :param pulumi.Input[_builtins.str] key_type: Type of the API key resource. Currently, the valid key type is API_KEY.
        :param pulumi.Input[_builtins.str] name: Name of a usage plan key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] usage_plan_id: Id of the usage plan resource representing to associate the key to.
        :param pulumi.Input[_builtins.str] value: Value of a usage plan key.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if usage_plan_id is not None:
            pulumi.set(__self__, "usage_plan_id", usage_plan_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the API key resource.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the API key resource. Currently, the valid key type is API_KEY.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a usage plan key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="usagePlanId")
    def usage_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the usage plan resource representing to associate the key to.
        """
        return pulumi.get(self, "usage_plan_id")

    @usage_plan_id.setter
    def usage_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_plan_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value of a usage plan key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("aws:apigateway/usagePlanKey:UsagePlanKey")
class UsagePlanKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an API Gateway Usage Plan Key.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.apigateway.RestApi("test", name="MyDemoAPI")
        # ...
        myusageplan = aws.apigateway.UsagePlan("myusageplan",
            name="my_usage_plan",
            api_stages=[{
                "api_id": test.id,
                "stage": foo["stageName"],
            }])
        mykey = aws.apigateway.ApiKey("mykey", name="my_key")
        main = aws.apigateway.UsagePlanKey("main",
            key_id=mykey.id,
            key_type="API_KEY",
            usage_plan_id=myusageplan.id)
        ```

        ## Import

        Using `pulumi import`, import AWS API Gateway Usage Plan Key using the `USAGE-PLAN-ID/USAGE-PLAN-KEY-ID`. For example:

        ```sh
        $ pulumi import aws:apigateway/usagePlanKey:UsagePlanKey key 12345abcde/zzz
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_id: Identifier of the API key resource.
        :param pulumi.Input[_builtins.str] key_type: Type of the API key resource. Currently, the valid key type is API_KEY.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] usage_plan_id: Id of the usage plan resource representing to associate the key to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsagePlanKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an API Gateway Usage Plan Key.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.apigateway.RestApi("test", name="MyDemoAPI")
        # ...
        myusageplan = aws.apigateway.UsagePlan("myusageplan",
            name="my_usage_plan",
            api_stages=[{
                "api_id": test.id,
                "stage": foo["stageName"],
            }])
        mykey = aws.apigateway.ApiKey("mykey", name="my_key")
        main = aws.apigateway.UsagePlanKey("main",
            key_id=mykey.id,
            key_type="API_KEY",
            usage_plan_id=myusageplan.id)
        ```

        ## Import

        Using `pulumi import`, import AWS API Gateway Usage Plan Key using the `USAGE-PLAN-ID/USAGE-PLAN-KEY-ID`. For example:

        ```sh
        $ pulumi import aws:apigateway/usagePlanKey:UsagePlanKey key 12345abcde/zzz
        ```

        :param str resource_name: The name of the resource.
        :param UsagePlanKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsagePlanKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsagePlanKeyArgs.__new__(UsagePlanKeyArgs)

            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["region"] = region
            if usage_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'usage_plan_id'")
            __props__.__dict__["usage_plan_id"] = usage_plan_id
            __props__.__dict__["name"] = None
            __props__.__dict__["value"] = None
        super(UsagePlanKey, __self__).__init__(
            'aws:apigateway/usagePlanKey:UsagePlanKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            usage_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'UsagePlanKey':
        """
        Get an existing UsagePlanKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_id: Identifier of the API key resource.
        :param pulumi.Input[_builtins.str] key_type: Type of the API key resource. Currently, the valid key type is API_KEY.
        :param pulumi.Input[_builtins.str] name: Name of a usage plan key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] usage_plan_id: Id of the usage plan resource representing to associate the key to.
        :param pulumi.Input[_builtins.str] value: Value of a usage plan key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsagePlanKeyState.__new__(_UsagePlanKeyState)

        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["usage_plan_id"] = usage_plan_id
        __props__.__dict__["value"] = value
        return UsagePlanKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the API key resource.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the API key resource. Currently, the valid key type is API_KEY.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of a usage plan key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="usagePlanId")
    def usage_plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the usage plan resource representing to associate the key to.
        """
        return pulumi.get(self, "usage_plan_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Value of a usage plan key.
        """
        return pulumi.get(self, "value")

