# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationProfileValidator',
    'EnvironmentMonitor',
    'EventIntegrationEventFilter',
    'ExtensionActionPoint',
    'ExtensionActionPointAction',
    'ExtensionParameter',
    'GetConfigurationProfileValidatorResult',
    'GetEnvironmentMonitorResult',
]

@pulumi.output_type
class ConfigurationProfileValidator(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 content: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        :param _builtins.str content: Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
        pulumi.set(__self__, "type", type)
        if content is not None:
            pulumi.set(__self__, "content", content)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
        return pulumi.get(self, "content")


@pulumi.output_type
class EnvironmentMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmArn":
            suggest = "alarm_arn"
        elif key == "alarmRoleArn":
            suggest = "alarm_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_arn: _builtins.str,
                 alarm_role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str alarm_arn: ARN of the Amazon CloudWatch alarm.
        :param _builtins.str alarm_role_arn: ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @_builtins.property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> _builtins.str:
        """
        ARN of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @_builtins.property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[_builtins.str]:
        """
        ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        return pulumi.get(self, "alarm_role_arn")


@pulumi.output_type
class EventIntegrationEventFilter(dict):
    def __init__(__self__, *,
                 source: _builtins.str):
        """
        :param _builtins.str source: Source of the events.
        """
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Source of the events.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class ExtensionActionPoint(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.ExtensionActionPointAction'],
                 point: _builtins.str):
        """
        :param Sequence['ExtensionActionPointActionArgs'] actions: An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
        :param _builtins.str point: The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "point", point)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.ExtensionActionPointAction']:
        """
        An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def point(self) -> _builtins.str:
        """
        The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
        """
        return pulumi.get(self, "point")


@pulumi.output_type
class ExtensionActionPointAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionActionPointAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionActionPointAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionActionPointAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 uri: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The action name.
        :param _builtins.str uri: The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
        :param _builtins.str description: Information about the action.
        :param _builtins.str role_arn: An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The action name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Information about the action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ExtensionParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 required: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The parameter name.
        :param _builtins.str description: Information about the parameter.
        :param _builtins.bool required: Determines if a parameter value must be specified in the extension association.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Information about the parameter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[_builtins.bool]:
        """
        Determines if a parameter value must be specified in the extension association.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GetConfigurationProfileValidatorResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str content: Either the JSON Schema content or the ARN of an AWS Lambda function.
        :param _builtins.str type: Type of validator. Valid values: JSON_SCHEMA and LAMBDA.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of validator. Valid values: JSON_SCHEMA and LAMBDA.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEnvironmentMonitorResult(dict):
    def __init__(__self__, *,
                 alarm_arn: _builtins.str,
                 alarm_role_arn: _builtins.str):
        """
        :param _builtins.str alarm_arn: ARN of the Amazon CloudWatch alarm.
        :param _builtins.str alarm_role_arn: ARN of an IAM role for AWS AppConfig to monitor.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @_builtins.property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> _builtins.str:
        """
        ARN of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @_builtins.property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> _builtins.str:
        """
        ARN of an IAM role for AWS AppConfig to monitor.
        """
        return pulumi.get(self, "alarm_role_arn")


