# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorProfileArgs', 'ConnectorProfile']

@pulumi.input_type
class ConnectorProfileArgs:
    def __init__(__self__, *,
                 connection_mode: pulumi.Input[_builtins.str],
                 connector_profile_config: pulumi.Input['ConnectorProfileConnectorProfileConfigArgs'],
                 connector_type: pulumi.Input[_builtins.str],
                 connector_label: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectorProfile resource.
        :param pulumi.Input[_builtins.str] connection_mode: Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        :param pulumi.Input['ConnectorProfileConnectorProfileConfigArgs'] connector_profile_config: Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        :param pulumi.Input[_builtins.str] connector_label: The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        pulumi.set(__self__, "connection_mode", connection_mode)
        pulumi.set(__self__, "connector_profile_config", connector_profile_config)
        pulumi.set(__self__, "connector_type", connector_type)
        if connector_label is not None:
            pulumi.set(__self__, "connector_label", connector_label)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectorProfileConfig")
    def connector_profile_config(self) -> pulumi.Input['ConnectorProfileConnectorProfileConfigArgs']:
        """
        Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        """
        return pulumi.get(self, "connector_profile_config")

    @connector_profile_config.setter
    def connector_profile_config(self, value: pulumi.Input['ConnectorProfileConnectorProfileConfigArgs']):
        pulumi.set(self, "connector_profile_config", value)

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connector_type", value)

    @_builtins.property
    @pulumi.getter(name="connectorLabel")
    def connector_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        """
        return pulumi.get(self, "connector_label")

    @connector_label.setter
    def connector_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_label", value)

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @kms_arn.setter
    def kms_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ConnectorProfileState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_label: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_profile_config: Optional[pulumi.Input['ConnectorProfileConnectorProfileConfigArgs']] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectorProfile resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the connector profile.
        :param pulumi.Input[_builtins.str] connection_mode: Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        :param pulumi.Input[_builtins.str] connector_label: The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        :param pulumi.Input['ConnectorProfileConnectorProfileConfigArgs'] connector_profile_config: Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        :param pulumi.Input[_builtins.str] credentials_arn: ARN of the connector profile credentials.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if connector_label is not None:
            pulumi.set(__self__, "connector_label", connector_label)
        if connector_profile_config is not None:
            pulumi.set(__self__, "connector_profile_config", connector_profile_config)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if credentials_arn is not None:
            pulumi.set(__self__, "credentials_arn", credentials_arn)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the connector profile.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectorLabel")
    def connector_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        """
        return pulumi.get(self, "connector_label")

    @connector_label.setter
    def connector_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_label", value)

    @_builtins.property
    @pulumi.getter(name="connectorProfileConfig")
    def connector_profile_config(self) -> Optional[pulumi.Input['ConnectorProfileConnectorProfileConfigArgs']]:
        """
        Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        """
        return pulumi.get(self, "connector_profile_config")

    @connector_profile_config.setter
    def connector_profile_config(self, value: Optional[pulumi.Input['ConnectorProfileConnectorProfileConfigArgs']]):
        pulumi.set(self, "connector_profile_config", value)

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_type", value)

    @_builtins.property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the connector profile credentials.
        """
        return pulumi.get(self, "credentials_arn")

    @credentials_arn.setter
    def credentials_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_arn", value)

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @kms_arn.setter
    def kms_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:appflow/connectorProfile:ConnectorProfile")
class ConnectorProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_label: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_profile_config: Optional[pulumi.Input[Union['ConnectorProfileConnectorProfileConfigArgs', 'ConnectorProfileConnectorProfileConfigArgsDict']]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an AppFlow connector profile resource.

        For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
        For specific information about creating an AppFlow connector profile, see the
        [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.get_policy(name="AmazonRedshiftAllCommandsFullAccess")
        example_role = aws.iam.Role("example",
            name="example_role",
            managed_policy_arns=[test["arn"]],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
            }))
        example_bucket = aws.s3.Bucket("example", bucket="example-bucket")
        example_cluster = aws.redshift.Cluster("example",
            cluster_identifier="example_cluster",
            database_name="example_db",
            master_username="exampleuser",
            master_password="examplePassword123!",
            node_type="dc1.large",
            cluster_type="single-node")
        example_connector_profile = aws.appflow.ConnectorProfile("example",
            name="example_profile",
            connector_type="Redshift",
            connection_mode="Public",
            connector_profile_config={
                "connector_profile_credentials": {
                    "redshift": {
                        "password": example_cluster.master_password,
                        "username": example_cluster.master_username,
                    },
                },
                "connector_profile_properties": {
                    "redshift": {
                        "bucket_name": example_bucket.name,
                        "database_url": pulumi.Output.all(
                            endpoint=example_cluster.endpoint,
                            database_name=example_cluster.database_name
        ).apply(lambda resolved_outputs: f"jdbc:redshift://{resolved_outputs['endpoint']}/{resolved_outputs['database_name']}")
        ,
                        "role_arn": example_role.arn,
                    },
                },
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `name` (String) Name of the Appflow connector profile.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import AppFlow Connector Profile using the connector profile `name`. For example:

        console

        % pulumi import aws_appflow_connector_profile.example example-profile

        [1]: https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html

        [2]: https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_mode: Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        :param pulumi.Input[_builtins.str] connector_label: The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        :param pulumi.Input[Union['ConnectorProfileConnectorProfileConfigArgs', 'ConnectorProfileConnectorProfileConfigArgsDict']] connector_profile_config: Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppFlow connector profile resource.

        For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
        For specific information about creating an AppFlow connector profile, see the
        [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.get_policy(name="AmazonRedshiftAllCommandsFullAccess")
        example_role = aws.iam.Role("example",
            name="example_role",
            managed_policy_arns=[test["arn"]],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
            }))
        example_bucket = aws.s3.Bucket("example", bucket="example-bucket")
        example_cluster = aws.redshift.Cluster("example",
            cluster_identifier="example_cluster",
            database_name="example_db",
            master_username="exampleuser",
            master_password="examplePassword123!",
            node_type="dc1.large",
            cluster_type="single-node")
        example_connector_profile = aws.appflow.ConnectorProfile("example",
            name="example_profile",
            connector_type="Redshift",
            connection_mode="Public",
            connector_profile_config={
                "connector_profile_credentials": {
                    "redshift": {
                        "password": example_cluster.master_password,
                        "username": example_cluster.master_username,
                    },
                },
                "connector_profile_properties": {
                    "redshift": {
                        "bucket_name": example_bucket.name,
                        "database_url": pulumi.Output.all(
                            endpoint=example_cluster.endpoint,
                            database_name=example_cluster.database_name
        ).apply(lambda resolved_outputs: f"jdbc:redshift://{resolved_outputs['endpoint']}/{resolved_outputs['database_name']}")
        ,
                        "role_arn": example_role.arn,
                    },
                },
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `name` (String) Name of the Appflow connector profile.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import AppFlow Connector Profile using the connector profile `name`. For example:

        console

        % pulumi import aws_appflow_connector_profile.example example-profile

        [1]: https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html

        [2]: https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html

        :param str resource_name: The name of the resource.
        :param ConnectorProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_label: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_profile_config: Optional[pulumi.Input[Union['ConnectorProfileConnectorProfileConfigArgs', 'ConnectorProfileConnectorProfileConfigArgsDict']]] = None,
                 connector_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorProfileArgs.__new__(ConnectorProfileArgs)

            if connection_mode is None and not opts.urn:
                raise TypeError("Missing required property 'connection_mode'")
            __props__.__dict__["connection_mode"] = connection_mode
            __props__.__dict__["connector_label"] = connector_label
            if connector_profile_config is None and not opts.urn:
                raise TypeError("Missing required property 'connector_profile_config'")
            __props__.__dict__["connector_profile_config"] = connector_profile_config
            if connector_type is None and not opts.urn:
                raise TypeError("Missing required property 'connector_type'")
            __props__.__dict__["connector_type"] = connector_type
            __props__.__dict__["kms_arn"] = kms_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["credentials_arn"] = None
        super(ConnectorProfile, __self__).__init__(
            'aws:appflow/connectorProfile:ConnectorProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connector_label: Optional[pulumi.Input[_builtins.str]] = None,
            connector_profile_config: Optional[pulumi.Input[Union['ConnectorProfileConnectorProfileConfigArgs', 'ConnectorProfileConnectorProfileConfigArgsDict']]] = None,
            connector_type: Optional[pulumi.Input[_builtins.str]] = None,
            credentials_arn: Optional[pulumi.Input[_builtins.str]] = None,
            kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConnectorProfile':
        """
        Get an existing ConnectorProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the connector profile.
        :param pulumi.Input[_builtins.str] connection_mode: Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        :param pulumi.Input[_builtins.str] connector_label: The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        :param pulumi.Input[Union['ConnectorProfileConnectorProfileConfigArgs', 'ConnectorProfileConnectorProfileConfigArgsDict']] connector_profile_config: Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        :param pulumi.Input[_builtins.str] connector_type: The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        :param pulumi.Input[_builtins.str] credentials_arn: ARN of the connector profile credentials.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorProfileState.__new__(_ConnectorProfileState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["connection_mode"] = connection_mode
        __props__.__dict__["connector_label"] = connector_label
        __props__.__dict__["connector_profile_config"] = connector_profile_config
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["credentials_arn"] = credentials_arn
        __props__.__dict__["kms_arn"] = kms_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return ConnectorProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the connector profile.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
        """
        return pulumi.get(self, "connection_mode")

    @_builtins.property
    @pulumi.getter(name="connectorLabel")
    def connector_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
        """
        return pulumi.get(self, "connector_label")

    @_builtins.property
    @pulumi.getter(name="connectorProfileConfig")
    def connector_profile_config(self) -> pulumi.Output['outputs.ConnectorProfileConnectorProfileConfig']:
        """
        Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
        """
        return pulumi.get(self, "connector_profile_config")

    @_builtins.property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
        """
        return pulumi.get(self, "connector_type")

    @_builtins.property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the connector profile credentials.
        """
        return pulumi.get(self, "credentials_arn")

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * `name ` (Required) - Name of the connector profile. The name is unique for each `ConnectorProfile` in your AWS account.
        """
        return pulumi.get(self, "region")

