# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualNodeResult',
    'AwaitableGetVirtualNodeResult',
    'get_virtual_node',
    'get_virtual_node_output',
]

@pulumi.output_type
class GetVirtualNodeResult:
    """
    A collection of values returned by getVirtualNode.
    """
    def __init__(__self__, arn=None, created_date=None, id=None, last_updated_date=None, mesh_name=None, mesh_owner=None, name=None, region=None, resource_owner=None, specs=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if mesh_name and not isinstance(mesh_name, str):
            raise TypeError("Expected argument 'mesh_name' to be a str")
        pulumi.set(__self__, "mesh_name", mesh_name)
        if mesh_owner and not isinstance(mesh_owner, str):
            raise TypeError("Expected argument 'mesh_owner' to be a str")
        pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_owner and not isinstance(resource_owner, str):
            raise TypeError("Expected argument 'resource_owner' to be a str")
        pulumi.set(__self__, "resource_owner", resource_owner)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the virtual node.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Creation date of the virtual node.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> _builtins.str:
        """
        Last update date of the virtual node.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> _builtins.str:
        return pulumi.get(self, "mesh_name")

    @_builtins.property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> _builtins.str:
        return pulumi.get(self, "mesh_owner")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> _builtins.str:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetVirtualNodeSpecResult']:
        """
        Virtual node specification. See the `appmesh.VirtualNode` resource for details.
        """
        return pulumi.get(self, "specs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVirtualNodeResult(GetVirtualNodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNodeResult(
            arn=self.arn,
            created_date=self.created_date,
            id=self.id,
            last_updated_date=self.last_updated_date,
            mesh_name=self.mesh_name,
            mesh_owner=self.mesh_owner,
            name=self.name,
            region=self.region,
            resource_owner=self.resource_owner,
            specs=self.specs,
            tags=self.tags)


def get_virtual_node(mesh_name: Optional[_builtins.str] = None,
                     mesh_owner: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNodeResult:
    """
    Data source for managing an AWS App Mesh Virtual Node.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.appmesh.get_virtual_node(name="serviceBv1",
        mesh_name="example-mesh")
    ```


    :param _builtins.str mesh_name: Name of the service mesh in which the virtual node exists.
    :param _builtins.str mesh_owner: AWS account ID of the service mesh's owner.
    :param _builtins.str name: Name of the virtual node.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['meshOwner'] = mesh_owner
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appmesh/getVirtualNode:getVirtualNode', __args__, opts=opts, typ=GetVirtualNodeResult).value

    return AwaitableGetVirtualNodeResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        mesh_name=pulumi.get(__ret__, 'mesh_name'),
        mesh_owner=pulumi.get(__ret__, 'mesh_owner'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        resource_owner=pulumi.get(__ret__, 'resource_owner'),
        specs=pulumi.get(__ret__, 'specs'),
        tags=pulumi.get(__ret__, 'tags'))
def get_virtual_node_output(mesh_name: Optional[pulumi.Input[_builtins.str]] = None,
                            mesh_owner: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNodeResult]:
    """
    Data source for managing an AWS App Mesh Virtual Node.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.appmesh.get_virtual_node(name="serviceBv1",
        mesh_name="example-mesh")
    ```


    :param _builtins.str mesh_name: Name of the service mesh in which the virtual node exists.
    :param _builtins.str mesh_owner: AWS account ID of the service mesh's owner.
    :param _builtins.str name: Name of the virtual node.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['meshOwner'] = mesh_owner
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:appmesh/getVirtualNode:getVirtualNode', __args__, opts=opts, typ=GetVirtualNodeResult)
    return __ret__.apply(lambda __response__: GetVirtualNodeResult(
        arn=pulumi.get(__response__, 'arn'),
        created_date=pulumi.get(__response__, 'created_date'),
        id=pulumi.get(__response__, 'id'),
        last_updated_date=pulumi.get(__response__, 'last_updated_date'),
        mesh_name=pulumi.get(__response__, 'mesh_name'),
        mesh_owner=pulumi.get(__response__, 'mesh_owner'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        resource_owner=pulumi.get(__response__, 'resource_owner'),
        specs=pulumi.get(__response__, 'specs'),
        tags=pulumi.get(__response__, 'tags')))
