# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNodeArgs', 'VirtualNode']

@pulumi.input_type
class VirtualNodeArgs:
    def __init__(__self__, *,
                 mesh_name: pulumi.Input[_builtins.str],
                 spec: pulumi.Input['VirtualNodeSpecArgs'],
                 mesh_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualNode resource.
        :param pulumi.Input[_builtins.str] mesh_name: Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input['VirtualNodeSpecArgs'] spec: Virtual node specification to apply.
        :param pulumi.Input[_builtins.str] mesh_owner: AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        :param pulumi.Input[_builtins.str] name: Name to use for the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "mesh_name", mesh_name)
        pulumi.set(__self__, "spec", spec)
        if mesh_owner is not None:
            pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "mesh_name")

    @mesh_name.setter
    def mesh_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mesh_name", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input['VirtualNodeSpecArgs']:
        """
        Virtual node specification to apply.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['VirtualNodeSpecArgs']):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        """
        return pulumi.get(self, "mesh_owner")

    @mesh_owner.setter
    def mesh_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mesh_owner", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to use for the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VirtualNodeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_date: Optional[pulumi.Input[_builtins.str]] = None,
                 mesh_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mesh_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['VirtualNodeSpecArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualNode resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the virtual node.
        :param pulumi.Input[_builtins.str] created_date: Creation date of the virtual node.
        :param pulumi.Input[_builtins.str] last_updated_date: Last update date of the virtual node.
        :param pulumi.Input[_builtins.str] mesh_name: Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] mesh_owner: AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        :param pulumi.Input[_builtins.str] name: Name to use for the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_owner: Resource owner's AWS account ID.
        :param pulumi.Input['VirtualNodeSpecArgs'] spec: Virtual node specification to apply.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if last_updated_date is not None:
            pulumi.set(__self__, "last_updated_date", last_updated_date)
        if mesh_name is not None:
            pulumi.set(__self__, "mesh_name", mesh_name)
        if mesh_owner is not None:
            pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_owner is not None:
            pulumi.set(__self__, "resource_owner", resource_owner)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the virtual node.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation date of the virtual node.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update date of the virtual node.
        """
        return pulumi.get(self, "last_updated_date")

    @last_updated_date.setter
    def last_updated_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_date", value)

    @_builtins.property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "mesh_name")

    @mesh_name.setter
    def mesh_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mesh_name", value)

    @_builtins.property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        """
        return pulumi.get(self, "mesh_owner")

    @mesh_owner.setter
    def mesh_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mesh_owner", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to use for the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @resource_owner.setter
    def resource_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_owner", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['VirtualNodeSpecArgs']]:
        """
        Virtual node specification to apply.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['VirtualNodeSpecArgs']]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:appmesh/virtualNode:VirtualNode")
class VirtualNode(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mesh_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mesh_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['VirtualNodeSpecArgs', 'VirtualNodeSpecArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an AWS App Mesh virtual node resource.

        ## Breaking Changes

        Because of backward incompatible API changes (read [here](https://github.com/awslabs/aws-app-mesh-examples/issues/92)), `appmesh.VirtualNode` resource definitions created with provider versions earlier than v2.3.0 will need to be modified:

        * Rename the `service_name` attribute of the `dns` object to `hostname`.

        * Replace the `backends` attribute of the `spec` object with one or more `backend` configuration blocks,
        setting `virtual_service_name` to the name of the service.

        The state associated with existing resources will automatically be migrated.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
            })
        ```

        ### AWS Cloud Map Service Discovery

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicediscovery.HttpNamespace("example", name="example-ns")
        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "aws_cloud_map": {
                        "attributes": {
                            "stack": "blue",
                        },
                        "service_name": "serviceb1",
                        "namespace_name": example.name,
                    },
                },
            })
        ```

        ### Listener Health Check

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                    "health_check": {
                        "protocol": "http",
                        "path": "/ping",
                        "healthy_threshold": 2,
                        "unhealthy_threshold": 2,
                        "timeout_millis": 2000,
                        "interval_millis": 5000,
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
            })
        ```

        ### Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
                "logging": {
                    "access_log": {
                        "file": {
                            "path": "/dev/stdout",
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import App Mesh virtual nodes using `mesh_name` together with the virtual node's `name`. For example:

        ```sh
        $ pulumi import aws:appmesh/virtualNode:VirtualNode serviceb1 simpleapp/serviceBv1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] mesh_name: Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] mesh_owner: AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        :param pulumi.Input[_builtins.str] name: Name to use for the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['VirtualNodeSpecArgs', 'VirtualNodeSpecArgsDict']] spec: Virtual node specification to apply.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS App Mesh virtual node resource.

        ## Breaking Changes

        Because of backward incompatible API changes (read [here](https://github.com/awslabs/aws-app-mesh-examples/issues/92)), `appmesh.VirtualNode` resource definitions created with provider versions earlier than v2.3.0 will need to be modified:

        * Rename the `service_name` attribute of the `dns` object to `hostname`.

        * Replace the `backends` attribute of the `spec` object with one or more `backend` configuration blocks,
        setting `virtual_service_name` to the name of the service.

        The state associated with existing resources will automatically be migrated.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
            })
        ```

        ### AWS Cloud Map Service Discovery

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicediscovery.HttpNamespace("example", name="example-ns")
        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "aws_cloud_map": {
                        "attributes": {
                            "stack": "blue",
                        },
                        "service_name": "serviceb1",
                        "namespace_name": example.name,
                    },
                },
            })
        ```

        ### Listener Health Check

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                    "health_check": {
                        "protocol": "http",
                        "path": "/ping",
                        "healthy_threshold": 2,
                        "unhealthy_threshold": 2,
                        "timeout_millis": 2000,
                        "interval_millis": 5000,
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
            })
        ```

        ### Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        serviceb1 = aws.appmesh.VirtualNode("serviceb1",
            name="serviceBv1",
            mesh_name=simple["id"],
            spec={
                "backends": [{
                    "virtual_service": {
                        "virtual_service_name": "servicea.simpleapp.local",
                    },
                }],
                "listeners": [{
                    "port_mapping": {
                        "port": 8080,
                        "protocol": "http",
                    },
                }],
                "service_discovery": {
                    "dns": {
                        "hostname": "serviceb.simpleapp.local",
                    },
                },
                "logging": {
                    "access_log": {
                        "file": {
                            "path": "/dev/stdout",
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import App Mesh virtual nodes using `mesh_name` together with the virtual node's `name`. For example:

        ```sh
        $ pulumi import aws:appmesh/virtualNode:VirtualNode serviceb1 simpleapp/serviceBv1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mesh_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mesh_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['VirtualNodeSpecArgs', 'VirtualNodeSpecArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNodeArgs.__new__(VirtualNodeArgs)

            if mesh_name is None and not opts.urn:
                raise TypeError("Missing required property 'mesh_name'")
            __props__.__dict__["mesh_name"] = mesh_name
            __props__.__dict__["mesh_owner"] = mesh_owner
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["last_updated_date"] = None
            __props__.__dict__["resource_owner"] = None
            __props__.__dict__["tags_all"] = None
        super(VirtualNode, __self__).__init__(
            'aws:appmesh/virtualNode:VirtualNode',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_date: Optional[pulumi.Input[_builtins.str]] = None,
            mesh_name: Optional[pulumi.Input[_builtins.str]] = None,
            mesh_owner: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_owner: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[Union['VirtualNodeSpecArgs', 'VirtualNodeSpecArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'VirtualNode':
        """
        Get an existing VirtualNode resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the virtual node.
        :param pulumi.Input[_builtins.str] created_date: Creation date of the virtual node.
        :param pulumi.Input[_builtins.str] last_updated_date: Last update date of the virtual node.
        :param pulumi.Input[_builtins.str] mesh_name: Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] mesh_owner: AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        :param pulumi.Input[_builtins.str] name: Name to use for the virtual node. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_owner: Resource owner's AWS account ID.
        :param pulumi.Input[Union['VirtualNodeSpecArgs', 'VirtualNodeSpecArgsDict']] spec: Virtual node specification to apply.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNodeState.__new__(_VirtualNodeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["last_updated_date"] = last_updated_date
        __props__.__dict__["mesh_name"] = mesh_name
        __props__.__dict__["mesh_owner"] = mesh_owner
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_owner"] = resource_owner
        __props__.__dict__["spec"] = spec
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return VirtualNode(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the virtual node.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        Creation date of the virtual node.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> pulumi.Output[_builtins.str]:
        """
        Last update date of the virtual node.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "mesh_name")

    @_builtins.property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> pulumi.Output[_builtins.str]:
        """
        AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
        """
        return pulumi.get(self, "mesh_owner")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name to use for the virtual node. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> pulumi.Output[_builtins.str]:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output['outputs.VirtualNodeSpec']:
        """
        Virtual node specification to apply.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

