# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DirectoryConfigArgs', 'DirectoryConfig']

@pulumi.input_type
class DirectoryConfigArgs:
    def __init__(__self__, *,
                 directory_name: pulumi.Input[_builtins.str],
                 organizational_unit_distinguished_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service_account_credentials: pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs'],
                 certificate_based_auth_properties: Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DirectoryConfig resource.
        :param pulumi.Input[_builtins.str] directory_name: Fully qualified name of the directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_unit_distinguished_names: Distinguished names of the organizational units for computer accounts.
        :param pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs'] service_account_credentials: Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        :param pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs'] certificate_based_auth_properties: Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "directory_name", directory_name)
        pulumi.set(__self__, "organizational_unit_distinguished_names", organizational_unit_distinguished_names)
        pulumi.set(__self__, "service_account_credentials", service_account_credentials)
        if certificate_based_auth_properties is not None:
            pulumi.set(__self__, "certificate_based_auth_properties", certificate_based_auth_properties)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> pulumi.Input[_builtins.str]:
        """
        Fully qualified name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnitDistinguishedNames")
    def organizational_unit_distinguished_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Distinguished names of the organizational units for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_names")

    @organizational_unit_distinguished_names.setter
    def organizational_unit_distinguished_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "organizational_unit_distinguished_names", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountCredentials")
    def service_account_credentials(self) -> pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs']:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        return pulumi.get(self, "service_account_credentials")

    @service_account_credentials.setter
    def service_account_credentials(self, value: pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs']):
        pulumi.set(self, "service_account_credentials", value)

    @_builtins.property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']]:
        """
        Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @certificate_based_auth_properties.setter
    def certificate_based_auth_properties(self, value: Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']]):
        pulumi.set(self, "certificate_based_auth_properties", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DirectoryConfigState:
    def __init__(__self__, *,
                 certificate_based_auth_properties: Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit_distinguished_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_credentials: Optional[pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs']] = None):
        """
        Input properties used for looking up and filtering DirectoryConfig resources.
        :param pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs'] certificate_based_auth_properties: Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the directory config was created.
        :param pulumi.Input[_builtins.str] directory_name: Fully qualified name of the directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_unit_distinguished_names: Distinguished names of the organizational units for computer accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs'] service_account_credentials: Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        if certificate_based_auth_properties is not None:
            pulumi.set(__self__, "certificate_based_auth_properties", certificate_based_auth_properties)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_names is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_names", organizational_unit_distinguished_names)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_account_credentials is not None:
            pulumi.set(__self__, "service_account_credentials", service_account_credentials)

    @_builtins.property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']]:
        """
        Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @certificate_based_auth_properties.setter
    def certificate_based_auth_properties(self, value: Optional[pulumi.Input['DirectoryConfigCertificateBasedAuthPropertiesArgs']]):
        pulumi.set(self, "certificate_based_auth_properties", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the directory config was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnitDistinguishedNames")
    def organizational_unit_distinguished_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Distinguished names of the organizational units for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_names")

    @organizational_unit_distinguished_names.setter
    def organizational_unit_distinguished_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizational_unit_distinguished_names", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountCredentials")
    def service_account_credentials(self) -> Optional[pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs']]:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        return pulumi.get(self, "service_account_credentials")

    @service_account_credentials.setter
    def service_account_credentials(self, value: Optional[pulumi.Input['DirectoryConfigServiceAccountCredentialsArgs']]):
        pulumi.set(self, "service_account_credentials", value)


@pulumi.type_token("aws:appstream/directoryConfig:DirectoryConfig")
class DirectoryConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryConfigCertificateBasedAuthPropertiesArgs', 'DirectoryConfigCertificateBasedAuthPropertiesArgsDict']]] = None,
                 directory_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit_distinguished_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_credentials: Optional[pulumi.Input[Union['DirectoryConfigServiceAccountCredentialsArgs', 'DirectoryConfigServiceAccountCredentialsArgsDict']]] = None,
                 __props__=None):
        """
        Provides an AppStream Directory Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.DirectoryConfig("example",
            directory_name="NAME OF DIRECTORY",
            organizational_unit_distinguished_names=["DISTINGUISHED NAME"],
            service_account_credentials={
                "account_name": "NAME OF ACCOUNT",
                "account_password": "PASSWORD OF ACCOUNT",
            },
            certificate_based_auth_properties={
                "certificate_authority_arn": "ARN OF CERTIFICATE AUTHORITY",
                "status": "STATUS OF CERTIFICATE BASED AUTHENTICATION",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_directory_config` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/directoryConfig:DirectoryConfig example directoryNameExample
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DirectoryConfigCertificateBasedAuthPropertiesArgs', 'DirectoryConfigCertificateBasedAuthPropertiesArgsDict']] certificate_based_auth_properties: Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        :param pulumi.Input[_builtins.str] directory_name: Fully qualified name of the directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_unit_distinguished_names: Distinguished names of the organizational units for computer accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['DirectoryConfigServiceAccountCredentialsArgs', 'DirectoryConfigServiceAccountCredentialsArgsDict']] service_account_credentials: Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectoryConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream Directory Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.DirectoryConfig("example",
            directory_name="NAME OF DIRECTORY",
            organizational_unit_distinguished_names=["DISTINGUISHED NAME"],
            service_account_credentials={
                "account_name": "NAME OF ACCOUNT",
                "account_password": "PASSWORD OF ACCOUNT",
            },
            certificate_based_auth_properties={
                "certificate_authority_arn": "ARN OF CERTIFICATE AUTHORITY",
                "status": "STATUS OF CERTIFICATE BASED AUTHENTICATION",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_directory_config` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/directoryConfig:DirectoryConfig example directoryNameExample
        ```

        :param str resource_name: The name of the resource.
        :param DirectoryConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectoryConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryConfigCertificateBasedAuthPropertiesArgs', 'DirectoryConfigCertificateBasedAuthPropertiesArgsDict']]] = None,
                 directory_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit_distinguished_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_credentials: Optional[pulumi.Input[Union['DirectoryConfigServiceAccountCredentialsArgs', 'DirectoryConfigServiceAccountCredentialsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectoryConfigArgs.__new__(DirectoryConfigArgs)

            __props__.__dict__["certificate_based_auth_properties"] = certificate_based_auth_properties
            if directory_name is None and not opts.urn:
                raise TypeError("Missing required property 'directory_name'")
            __props__.__dict__["directory_name"] = directory_name
            if organizational_unit_distinguished_names is None and not opts.urn:
                raise TypeError("Missing required property 'organizational_unit_distinguished_names'")
            __props__.__dict__["organizational_unit_distinguished_names"] = organizational_unit_distinguished_names
            __props__.__dict__["region"] = region
            if service_account_credentials is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_credentials'")
            __props__.__dict__["service_account_credentials"] = service_account_credentials
            __props__.__dict__["created_time"] = None
        super(DirectoryConfig, __self__).__init__(
            'aws:appstream/directoryConfig:DirectoryConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_based_auth_properties: Optional[pulumi.Input[Union['DirectoryConfigCertificateBasedAuthPropertiesArgs', 'DirectoryConfigCertificateBasedAuthPropertiesArgsDict']]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            directory_name: Optional[pulumi.Input[_builtins.str]] = None,
            organizational_unit_distinguished_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_credentials: Optional[pulumi.Input[Union['DirectoryConfigServiceAccountCredentialsArgs', 'DirectoryConfigServiceAccountCredentialsArgsDict']]] = None) -> 'DirectoryConfig':
        """
        Get an existing DirectoryConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DirectoryConfigCertificateBasedAuthPropertiesArgs', 'DirectoryConfigCertificateBasedAuthPropertiesArgsDict']] certificate_based_auth_properties: Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the directory config was created.
        :param pulumi.Input[_builtins.str] directory_name: Fully qualified name of the directory.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_unit_distinguished_names: Distinguished names of the organizational units for computer accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['DirectoryConfigServiceAccountCredentialsArgs', 'DirectoryConfigServiceAccountCredentialsArgsDict']] service_account_credentials: Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectoryConfigState.__new__(_DirectoryConfigState)

        __props__.__dict__["certificate_based_auth_properties"] = certificate_based_auth_properties
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["directory_name"] = directory_name
        __props__.__dict__["organizational_unit_distinguished_names"] = organizational_unit_distinguished_names
        __props__.__dict__["region"] = region
        __props__.__dict__["service_account_credentials"] = service_account_credentials
        return DirectoryConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateBasedAuthProperties")
    def certificate_based_auth_properties(self) -> pulumi.Output[Optional['outputs.DirectoryConfigCertificateBasedAuthProperties']]:
        """
        Configuration block for the certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory domain-joined streaming instances. See `certificate_based_auth_properties` below.
        """
        return pulumi.get(self, "certificate_based_auth_properties")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the directory config was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the directory.
        """
        return pulumi.get(self, "directory_name")

    @_builtins.property
    @pulumi.getter(name="organizationalUnitDistinguishedNames")
    def organizational_unit_distinguished_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Distinguished names of the organizational units for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_names")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceAccountCredentials")
    def service_account_credentials(self) -> pulumi.Output['outputs.DirectoryConfigServiceAccountCredentials']:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
        """
        return pulumi.get(self, "service_account_credentials")

