# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageBuilderArgs', 'ImageBuilder']

@pulumi.input_type
class ImageBuilderArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a ImageBuilder resource.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching the image builder.
        :param pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]] access_endpoints: Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        :param pulumi.Input[_builtins.str] appstream_agent_version: Version of the AppStream 2.0 agent to use for this image builder.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream image builder.
        :param pulumi.Input['ImageBuilderDomainJoinInfoArgs'] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the image builder.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the image builder.
        :param pulumi.Input[_builtins.str] name: Unique name for the image builder.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ImageBuilderVpcConfigArgs'] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if appstream_agent_version is not None:
            pulumi.set(__self__, "appstream_agent_version", appstream_agent_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_join_info is not None:
            pulumi.set(__self__, "domain_join_info", domain_join_info)
        if enable_default_internet_access is not None:
            pulumi.set(__self__, "enable_default_internet_access", enable_default_internet_access)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance type to use when launching the image builder.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]:
        """
        Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        """
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="appstreamAgentVersion")
    def appstream_agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the AppStream 2.0 agent to use for this image builder.
        """
        return pulumi.get(self, "appstream_agent_version")

    @appstream_agent_version.setter
    def appstream_agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "appstream_agent_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable friendly name for the AppStream image builder.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @domain_join_info.setter
    def domain_join_info(self, value: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]):
        pulumi.set(self, "domain_join_info", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables default internet access for the image builder.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @enable_default_internet_access.setter
    def enable_default_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to apply to the image builder.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image used to create the image builder.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the image builder.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _ImageBuilderState:
    def __init__(__self__, *,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ImageBuilder resources.
        :param pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]] access_endpoints: Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        :param pulumi.Input[_builtins.str] appstream_agent_version: Version of the AppStream 2.0 agent to use for this image builder.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream image builder.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the image builder was created.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream image builder.
        :param pulumi.Input['ImageBuilderDomainJoinInfoArgs'] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the image builder.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the image builder.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching the image builder.
        :param pulumi.Input[_builtins.str] name: Unique name for the image builder.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] state: State of the image builder. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ImageBuilder.html#AppStream2-Type-ImageBuilder-State).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['ImageBuilderVpcConfigArgs'] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if appstream_agent_version is not None:
            pulumi.set(__self__, "appstream_agent_version", appstream_agent_version)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_join_info is not None:
            pulumi.set(__self__, "domain_join_info", domain_join_info)
        if enable_default_internet_access is not None:
            pulumi.set(__self__, "enable_default_internet_access", enable_default_internet_access)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]:
        """
        Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        """
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageBuilderAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="appstreamAgentVersion")
    def appstream_agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the AppStream 2.0 agent to use for this image builder.
        """
        return pulumi.get(self, "appstream_agent_version")

    @appstream_agent_version.setter
    def appstream_agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "appstream_agent_version", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the appstream image builder.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the image builder was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable friendly name for the AppStream image builder.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @domain_join_info.setter
    def domain_join_info(self, value: Optional[pulumi.Input['ImageBuilderDomainJoinInfoArgs']]):
        pulumi.set(self, "domain_join_info", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables default internet access for the image builder.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @enable_default_internet_access.setter
    def enable_default_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to apply to the image builder.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image used to create the image builder.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type to use when launching the image builder.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the image builder.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the image builder. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ImageBuilder.html#AppStream2-Type-ImageBuilder-State).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ImageBuilderVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("aws:appstream/imageBuilder:ImageBuilder")
class ImageBuilder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides an AppStream image builder.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_fleet = aws.appstream.ImageBuilder("test_fleet",
            name="Name",
            description="Description of a ImageBuilder",
            display_name="Display name of a ImageBuilder",
            enable_default_internet_access=False,
            image_name="AppStream-WinServer2019-10-05-2022",
            instance_type="stream.standard.large",
            vpc_config={
                "subnet_ids": [example["id"]],
            },
            tags={
                "Name": "Example Image Builder",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_image_builder` using the `name`. For example:

        ```sh
        $ pulumi import aws:appstream/imageBuilder:ImageBuilder example imageBuilderExample
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]] access_endpoints: Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        :param pulumi.Input[_builtins.str] appstream_agent_version: Version of the AppStream 2.0 agent to use for this image builder.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream image builder.
        :param pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the image builder.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the image builder.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching the image builder.
        :param pulumi.Input[_builtins.str] name: Unique name for the image builder.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageBuilderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream image builder.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_fleet = aws.appstream.ImageBuilder("test_fleet",
            name="Name",
            description="Description of a ImageBuilder",
            display_name="Display name of a ImageBuilder",
            enable_default_internet_access=False,
            image_name="AppStream-WinServer2019-10-05-2022",
            instance_type="stream.standard.large",
            vpc_config={
                "subnet_ids": [example["id"]],
            },
            tags={
                "Name": "Example Image Builder",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_image_builder` using the `name`. For example:

        ```sh
        $ pulumi import aws:appstream/imageBuilder:ImageBuilder example imageBuilderExample
        ```

        :param str resource_name: The name of the resource.
        :param ImageBuilderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageBuilderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]]] = None,
                 appstream_agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageBuilderArgs.__new__(ImageBuilderArgs)

            __props__.__dict__["access_endpoints"] = access_endpoints
            __props__.__dict__["appstream_agent_version"] = appstream_agent_version
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain_join_info"] = domain_join_info
            __props__.__dict__["enable_default_internet_access"] = enable_default_internet_access
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["image_arn"] = image_arn
            __props__.__dict__["image_name"] = image_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(ImageBuilder, __self__).__init__(
            'aws:appstream/imageBuilder:ImageBuilder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]]] = None,
            appstream_agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_join_info: Optional[pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']]] = None,
            enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
            iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            image_arn: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_config: Optional[pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']]] = None) -> 'ImageBuilder':
        """
        Get an existing ImageBuilder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageBuilderAccessEndpointArgs', 'ImageBuilderAccessEndpointArgsDict']]]] access_endpoints: Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        :param pulumi.Input[_builtins.str] appstream_agent_version: Version of the AppStream 2.0 agent to use for this image builder.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream image builder.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the image builder was created.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream image builder.
        :param pulumi.Input[Union['ImageBuilderDomainJoinInfoArgs', 'ImageBuilderDomainJoinInfoArgsDict']] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the image builder.
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the image builder.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the image builder.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching the image builder.
        :param pulumi.Input[_builtins.str] name: Unique name for the image builder.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] state: State of the image builder. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ImageBuilder.html#AppStream2-Type-ImageBuilder-State).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['ImageBuilderVpcConfigArgs', 'ImageBuilderVpcConfigArgsDict']] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageBuilderState.__new__(_ImageBuilderState)

        __props__.__dict__["access_endpoints"] = access_endpoints
        __props__.__dict__["appstream_agent_version"] = appstream_agent_version
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_join_info"] = domain_join_info
        __props__.__dict__["enable_default_internet_access"] = enable_default_internet_access
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["image_arn"] = image_arn
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_config"] = vpc_config
        return ImageBuilder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.ImageBuilderAccessEndpoint']]]:
        """
        Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
        """
        return pulumi.get(self, "access_endpoints")

    @_builtins.property
    @pulumi.getter(name="appstreamAgentVersion")
    def appstream_agent_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the AppStream 2.0 agent to use for this image builder.
        """
        return pulumi.get(self, "appstream_agent_version")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the appstream image builder.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the image builder was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable friendly name for the AppStream image builder.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> pulumi.Output['outputs.ImageBuilderDomainJoinInfo']:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables or disables default internet access for the image builder.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role to apply to the image builder.
        """
        return pulumi.get(self, "iam_role_arn")

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the image used to create the image builder.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type to use when launching the image builder.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name for the image builder.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the image builder. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ImageBuilder.html#AppStream2-Type-ImageBuilder-State).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output['outputs.ImageBuilderVpcConfig']:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

