# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CapacityReservationTimeouts',
    'DatabaseAclConfiguration',
    'DatabaseEncryptionConfiguration',
    'WorkgroupConfiguration',
    'WorkgroupConfigurationEngineVersion',
    'WorkgroupConfigurationIdentityCenterConfiguration',
    'WorkgroupConfigurationResultConfiguration',
    'WorkgroupConfigurationResultConfigurationAclConfiguration',
    'WorkgroupConfigurationResultConfigurationEncryptionConfiguration',
]

@pulumi.output_type
class CapacityReservationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class DatabaseAclConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3AclOption":
            suggest = "s3_acl_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseAclConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseAclConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseAclConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_acl_option: _builtins.str):
        """
        :param _builtins.str s3_acl_option: Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
               
               > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
        """
        pulumi.set(__self__, "s3_acl_option", s3_acl_option)

    @_builtins.property
    @pulumi.getter(name="s3AclOption")
    def s3_acl_option(self) -> _builtins.str:
        """
        Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.

        > **NOTE:** When Athena queries are executed, result files may be created in the specified bucket. Consider using `force_destroy` on the bucket too in order to avoid any problems when destroying the bucket.
        """
        return pulumi.get(self, "s3_acl_option")


@pulumi.output_type
class DatabaseEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_option: _builtins.str,
                 kms_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str encryption_option: Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
        :param _builtins.str kms_key: KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
        """
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> _builtins.str:
        """
        Type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
        """
        return pulumi.get(self, "encryption_option")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class WorkgroupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesScannedCutoffPerQuery":
            suggest = "bytes_scanned_cutoff_per_query"
        elif key == "enforceWorkgroupConfiguration":
            suggest = "enforce_workgroup_configuration"
        elif key == "engineVersion":
            suggest = "engine_version"
        elif key == "executionRole":
            suggest = "execution_role"
        elif key == "identityCenterConfiguration":
            suggest = "identity_center_configuration"
        elif key == "publishCloudwatchMetricsEnabled":
            suggest = "publish_cloudwatch_metrics_enabled"
        elif key == "requesterPaysEnabled":
            suggest = "requester_pays_enabled"
        elif key == "resultConfiguration":
            suggest = "result_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_scanned_cutoff_per_query: Optional[_builtins.int] = None,
                 enforce_workgroup_configuration: Optional[_builtins.bool] = None,
                 engine_version: Optional['outputs.WorkgroupConfigurationEngineVersion'] = None,
                 execution_role: Optional[_builtins.str] = None,
                 identity_center_configuration: Optional['outputs.WorkgroupConfigurationIdentityCenterConfiguration'] = None,
                 publish_cloudwatch_metrics_enabled: Optional[_builtins.bool] = None,
                 requester_pays_enabled: Optional[_builtins.bool] = None,
                 result_configuration: Optional['outputs.WorkgroupConfigurationResultConfiguration'] = None):
        """
        :param _builtins.int bytes_scanned_cutoff_per_query: Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
        :param _builtins.bool enforce_workgroup_configuration: Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
        :param 'WorkgroupConfigurationEngineVersionArgs' engine_version: Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
        :param _builtins.str execution_role: Role used to access user resources in notebook sessions and IAM Identity Center enabled workgroups. The property is required for IAM Identity Center enabled workgroups.
        :param 'WorkgroupConfigurationIdentityCenterConfigurationArgs' identity_center_configuration: Configuration block to set up an IAM Identity Center enabled workgroup. See Identity Center Configuration below.
        :param _builtins.bool publish_cloudwatch_metrics_enabled: Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
        :param _builtins.bool requester_pays_enabled: If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
        :param 'WorkgroupConfigurationResultConfigurationArgs' result_configuration: Configuration block with result settings. See Result Configuration below.
        """
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if enforce_workgroup_configuration is not None:
            pulumi.set(__self__, "enforce_workgroup_configuration", enforce_workgroup_configuration)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if identity_center_configuration is not None:
            pulumi.set(__self__, "identity_center_configuration", identity_center_configuration)
        if publish_cloudwatch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloudwatch_metrics_enabled", publish_cloudwatch_metrics_enabled)
        if requester_pays_enabled is not None:
            pulumi.set(__self__, "requester_pays_enabled", requester_pays_enabled)
        if result_configuration is not None:
            pulumi.set(__self__, "result_configuration", result_configuration)

    @_builtins.property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[_builtins.int]:
        """
        Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
        """
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @_builtins.property
    @pulumi.getter(name="enforceWorkgroupConfiguration")
    def enforce_workgroup_configuration(self) -> Optional[_builtins.bool]:
        """
        Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
        """
        return pulumi.get(self, "enforce_workgroup_configuration")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional['outputs.WorkgroupConfigurationEngineVersion']:
        """
        Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[_builtins.str]:
        """
        Role used to access user resources in notebook sessions and IAM Identity Center enabled workgroups. The property is required for IAM Identity Center enabled workgroups.
        """
        return pulumi.get(self, "execution_role")

    @_builtins.property
    @pulumi.getter(name="identityCenterConfiguration")
    def identity_center_configuration(self) -> Optional['outputs.WorkgroupConfigurationIdentityCenterConfiguration']:
        """
        Configuration block to set up an IAM Identity Center enabled workgroup. See Identity Center Configuration below.
        """
        return pulumi.get(self, "identity_center_configuration")

    @_builtins.property
    @pulumi.getter(name="publishCloudwatchMetricsEnabled")
    def publish_cloudwatch_metrics_enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
        """
        return pulumi.get(self, "publish_cloudwatch_metrics_enabled")

    @_builtins.property
    @pulumi.getter(name="requesterPaysEnabled")
    def requester_pays_enabled(self) -> Optional[_builtins.bool]:
        """
        If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
        """
        return pulumi.get(self, "requester_pays_enabled")

    @_builtins.property
    @pulumi.getter(name="resultConfiguration")
    def result_configuration(self) -> Optional['outputs.WorkgroupConfigurationResultConfiguration']:
        """
        Configuration block with result settings. See Result Configuration below.
        """
        return pulumi.get(self, "result_configuration")


@pulumi.output_type
class WorkgroupConfigurationEngineVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveEngineVersion":
            suggest = "effective_engine_version"
        elif key == "selectedEngineVersion":
            suggest = "selected_engine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationEngineVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationEngineVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationEngineVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_engine_version: Optional[_builtins.str] = None,
                 selected_engine_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str effective_engine_version: The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
        :param _builtins.str selected_engine_version: Requested engine version. Defaults to `AUTO`.
        """
        if effective_engine_version is not None:
            pulumi.set(__self__, "effective_engine_version", effective_engine_version)
        if selected_engine_version is not None:
            pulumi.set(__self__, "selected_engine_version", selected_engine_version)

    @_builtins.property
    @pulumi.getter(name="effectiveEngineVersion")
    def effective_engine_version(self) -> Optional[_builtins.str]:
        """
        The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
        """
        return pulumi.get(self, "effective_engine_version")

    @_builtins.property
    @pulumi.getter(name="selectedEngineVersion")
    def selected_engine_version(self) -> Optional[_builtins.str]:
        """
        Requested engine version. Defaults to `AUTO`.
        """
        return pulumi.get(self, "selected_engine_version")


@pulumi.output_type
class WorkgroupConfigurationIdentityCenterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIdentityCenter":
            suggest = "enable_identity_center"
        elif key == "identityCenterInstanceArn":
            suggest = "identity_center_instance_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationIdentityCenterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationIdentityCenterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationIdentityCenterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_identity_center: Optional[_builtins.bool] = None,
                 identity_center_instance_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable_identity_center: Specifies whether the workgroup is IAM Identity Center supported.
        :param _builtins.str identity_center_instance_arn: The IAM Identity Center instance ARN that the workgroup associates to.
        """
        if enable_identity_center is not None:
            pulumi.set(__self__, "enable_identity_center", enable_identity_center)
        if identity_center_instance_arn is not None:
            pulumi.set(__self__, "identity_center_instance_arn", identity_center_instance_arn)

    @_builtins.property
    @pulumi.getter(name="enableIdentityCenter")
    def enable_identity_center(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the workgroup is IAM Identity Center supported.
        """
        return pulumi.get(self, "enable_identity_center")

    @_builtins.property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> Optional[_builtins.str]:
        """
        The IAM Identity Center instance ARN that the workgroup associates to.
        """
        return pulumi.get(self, "identity_center_instance_arn")


@pulumi.output_type
class WorkgroupConfigurationResultConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclConfiguration":
            suggest = "acl_configuration"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "expectedBucketOwner":
            suggest = "expected_bucket_owner"
        elif key == "outputLocation":
            suggest = "output_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationResultConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationResultConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationResultConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_configuration: Optional['outputs.WorkgroupConfigurationResultConfigurationAclConfiguration'] = None,
                 encryption_configuration: Optional['outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration'] = None,
                 expected_bucket_owner: Optional[_builtins.str] = None,
                 output_location: Optional[_builtins.str] = None):
        """
        :param 'WorkgroupConfigurationResultConfigurationAclConfigurationArgs' acl_configuration: That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
        :param 'WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs' encryption_configuration: Configuration block with encryption settings. See Encryption Configuration below.
        :param _builtins.str expected_bucket_owner: AWS account ID that you expect to be the owner of the Amazon S3 bucket.
        :param _builtins.str output_location: Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
        """
        if acl_configuration is not None:
            pulumi.set(__self__, "acl_configuration", acl_configuration)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)

    @_builtins.property
    @pulumi.getter(name="aclConfiguration")
    def acl_configuration(self) -> Optional['outputs.WorkgroupConfigurationResultConfigurationAclConfiguration']:
        """
        That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
        """
        return pulumi.get(self, "acl_configuration")

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration']:
        """
        Configuration block with encryption settings. See Encryption Configuration below.
        """
        return pulumi.get(self, "encryption_configuration")

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[_builtins.str]:
        """
        AWS account ID that you expect to be the owner of the Amazon S3 bucket.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @_builtins.property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[_builtins.str]:
        """
        Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
        """
        return pulumi.get(self, "output_location")


@pulumi.output_type
class WorkgroupConfigurationResultConfigurationAclConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3AclOption":
            suggest = "s3_acl_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationResultConfigurationAclConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationResultConfigurationAclConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationResultConfigurationAclConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_acl_option: _builtins.str):
        """
        :param _builtins.str s3_acl_option: Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
        """
        pulumi.set(__self__, "s3_acl_option", s3_acl_option)

    @_builtins.property
    @pulumi.getter(name="s3AclOption")
    def s3_acl_option(self) -> _builtins.str:
        """
        Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
        """
        return pulumi.get(self, "s3_acl_option")


@pulumi.output_type
class WorkgroupConfigurationResultConfigurationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationResultConfigurationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationResultConfigurationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationResultConfigurationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_option: Optional[_builtins.str] = None,
                 kms_key_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str encryption_option: Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        :param _builtins.str kms_key_arn: For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
        """
        if encryption_option is not None:
            pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @_builtins.property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> Optional[_builtins.str]:
        """
        Whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        """
        return pulumi.get(self, "encryption_option")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[_builtins.str]:
        """
        For `SSE_KMS` and `CSE_KMS`, this is the KMS key ARN.
        """
        return pulumi.get(self, "kms_key_arn")


