# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssessmentDelegationArgs', 'AssessmentDelegation']

@pulumi.input_type
class AssessmentDelegationArgs:
    def __init__(__self__, *,
                 assessment_id: pulumi.Input[_builtins.str],
                 control_set_id: pulumi.Input[_builtins.str],
                 role_arn: pulumi.Input[_builtins.str],
                 role_type: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AssessmentDelegation resource.
        :param pulumi.Input[_builtins.str] assessment_id: Identifier for the assessment.
        :param pulumi.Input[_builtins.str] control_set_id: Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input[_builtins.str] role_type: Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] comment: Comment describing the delegation request.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "assessment_id", assessment_id)
        pulumi.set(__self__, "control_set_id", control_set_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "role_type", role_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier for the assessment.
        """
        return pulumi.get(self, "assessment_id")

    @assessment_id.setter
    def assessment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "assessment_id", value)

    @_builtins.property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        """
        return pulumi.get(self, "control_set_id")

    @control_set_id.setter
    def control_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "control_set_id", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment describing the delegation request.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AssessmentDelegationState:
    def __init__(__self__, *,
                 assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 control_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delegation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AssessmentDelegation resources.
        :param pulumi.Input[_builtins.str] assessment_id: Identifier for the assessment.
        :param pulumi.Input[_builtins.str] comment: Comment describing the delegation request.
        :param pulumi.Input[_builtins.str] control_set_id: Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        :param pulumi.Input[_builtins.str] delegation_id: Unique identifier for the delegation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input[_builtins.str] role_type: Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] status: Status of the delegation.
        """
        if assessment_id is not None:
            pulumi.set(__self__, "assessment_id", assessment_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if control_set_id is not None:
            pulumi.set(__self__, "control_set_id", control_set_id)
        if delegation_id is not None:
            pulumi.set(__self__, "delegation_id", delegation_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the assessment.
        """
        return pulumi.get(self, "assessment_id")

    @assessment_id.setter
    def assessment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assessment_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment describing the delegation request.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        """
        return pulumi.get(self, "control_set_id")

    @control_set_id.setter
    def control_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_set_id", value)

    @_builtins.property
    @pulumi.getter(name="delegationId")
    def delegation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the delegation.
        """
        return pulumi.get(self, "delegation_id")

    @delegation_id.setter
    def delegation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegation_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the delegation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("aws:auditmanager/assessmentDelegation:AssessmentDelegation")
class AssessmentDelegation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 control_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Audit Manager Assessment Delegation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.auditmanager.AssessmentDelegation("example",
            assessment_id=example_aws_auditmanager_assessment["id"],
            role_arn=example_aws_iam_role["arn"],
            role_type="RESOURCE_OWNER",
            control_set_id="example")
        ```

        ## Import

        Using `pulumi import`, import Audit Manager Assessment Delegation using the `id`. For example:

        ```sh
        $ pulumi import aws:auditmanager/assessmentDelegation:AssessmentDelegation example abcdef-123456,arn:aws:iam::123456789012:role/example,example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assessment_id: Identifier for the assessment.
        :param pulumi.Input[_builtins.str] comment: Comment describing the delegation request.
        :param pulumi.Input[_builtins.str] control_set_id: Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input[_builtins.str] role_type: Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssessmentDelegationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Audit Manager Assessment Delegation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.auditmanager.AssessmentDelegation("example",
            assessment_id=example_aws_auditmanager_assessment["id"],
            role_arn=example_aws_iam_role["arn"],
            role_type="RESOURCE_OWNER",
            control_set_id="example")
        ```

        ## Import

        Using `pulumi import`, import Audit Manager Assessment Delegation using the `id`. For example:

        ```sh
        $ pulumi import aws:auditmanager/assessmentDelegation:AssessmentDelegation example abcdef-123456,arn:aws:iam::123456789012:role/example,example
        ```

        :param str resource_name: The name of the resource.
        :param AssessmentDelegationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssessmentDelegationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 control_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssessmentDelegationArgs.__new__(AssessmentDelegationArgs)

            if assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'assessment_id'")
            __props__.__dict__["assessment_id"] = assessment_id
            __props__.__dict__["comment"] = comment
            if control_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'control_set_id'")
            __props__.__dict__["control_set_id"] = control_set_id
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if role_type is None and not opts.urn:
                raise TypeError("Missing required property 'role_type'")
            __props__.__dict__["role_type"] = role_type
            __props__.__dict__["delegation_id"] = None
            __props__.__dict__["status"] = None
        super(AssessmentDelegation, __self__).__init__(
            'aws:auditmanager/assessmentDelegation:AssessmentDelegation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assessment_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            control_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            delegation_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            role_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'AssessmentDelegation':
        """
        Get an existing AssessmentDelegation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assessment_id: Identifier for the assessment.
        :param pulumi.Input[_builtins.str] comment: Comment describing the delegation request.
        :param pulumi.Input[_builtins.str] control_set_id: Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        :param pulumi.Input[_builtins.str] delegation_id: Unique identifier for the delegation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param pulumi.Input[_builtins.str] role_type: Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] status: Status of the delegation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssessmentDelegationState.__new__(_AssessmentDelegationState)

        __props__.__dict__["assessment_id"] = assessment_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["control_set_id"] = control_set_id
        __props__.__dict__["delegation_id"] = delegation_id
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["role_type"] = role_type
        __props__.__dict__["status"] = status
        return AssessmentDelegation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assessmentId")
    def assessment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the assessment.
        """
        return pulumi.get(self, "assessment_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment describing the delegation request.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="controlSetId")
    def control_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
        """
        return pulumi.get(self, "control_set_id")

    @_builtins.property
    @pulumi.getter(name="delegationId")
    def delegation_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the delegation.
        """
        return pulumi.get(self, "delegation_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the delegation.
        """
        return pulumi.get(self, "status")

