# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputeEnvironmentResult',
    'AwaitableGetComputeEnvironmentResult',
    'get_compute_environment',
    'get_compute_environment_output',
]

@pulumi.output_type
class GetComputeEnvironmentResult:
    """
    A collection of values returned by getComputeEnvironment.
    """
    def __init__(__self__, arn=None, ecs_cluster_arn=None, id=None, name=None, region=None, service_role=None, state=None, status=None, status_reason=None, tags=None, type=None, update_policies=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if ecs_cluster_arn and not isinstance(ecs_cluster_arn, str):
            raise TypeError("Expected argument 'ecs_cluster_arn' to be a str")
        pulumi.set(__self__, "ecs_cluster_arn", ecs_cluster_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_role and not isinstance(service_role, str):
            raise TypeError("Expected argument 'service_role' to be a str")
        pulumi.set(__self__, "service_role", service_role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_policies and not isinstance(update_policies, list):
            raise TypeError("Expected argument 'update_policies' to be a list")
        pulumi.set(__self__, "update_policies", update_policies)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the compute environment.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> _builtins.str:
        """
        ARN of the underlying Amazon ECS cluster used by the compute environment.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> _builtins.str:
        """
        ARN of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the compute environment (for example, `ENABLED` or `DISABLED`). If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Current status of the compute environment (for example, `CREATING` or `VALID`).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Short, human-readable string to provide additional details about the current status of the compute environment.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the compute environment (for example, `MANAGED` or `UNMANAGED`).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatePolicies")
    def update_policies(self) -> Sequence['outputs.GetComputeEnvironmentUpdatePolicyResult']:
        """
        Specifies the infrastructure update policy for the compute environment.
        """
        return pulumi.get(self, "update_policies")


class AwaitableGetComputeEnvironmentResult(GetComputeEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeEnvironmentResult(
            arn=self.arn,
            ecs_cluster_arn=self.ecs_cluster_arn,
            id=self.id,
            name=self.name,
            region=self.region,
            service_role=self.service_role,
            state=self.state,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags,
            type=self.type,
            update_policies=self.update_policies)


def get_compute_environment(name: Optional[_builtins.str] = None,
                            region: Optional[_builtins.str] = None,
                            tags: Optional[Mapping[str, _builtins.str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeEnvironmentResult:
    """
    The Batch Compute Environment data source allows access to details of a specific
    compute environment within AWS Batch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    batch_mongo = aws.batch.get_compute_environment(name="batch-mongo-production")
    ```


    :param _builtins.str name: Name of the Batch Compute Environment
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:batch/getComputeEnvironment:getComputeEnvironment', __args__, opts=opts, typ=GetComputeEnvironmentResult).value

    return AwaitableGetComputeEnvironmentResult(
        arn=pulumi.get(__ret__, 'arn'),
        ecs_cluster_arn=pulumi.get(__ret__, 'ecs_cluster_arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        service_role=pulumi.get(__ret__, 'service_role'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        update_policies=pulumi.get(__ret__, 'update_policies'))
def get_compute_environment_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeEnvironmentResult]:
    """
    The Batch Compute Environment data source allows access to details of a specific
    compute environment within AWS Batch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    batch_mongo = aws.batch.get_compute_environment(name="batch-mongo-production")
    ```


    :param _builtins.str name: Name of the Batch Compute Environment
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:batch/getComputeEnvironment:getComputeEnvironment', __args__, opts=opts, typ=GetComputeEnvironmentResult)
    return __ret__.apply(lambda __response__: GetComputeEnvironmentResult(
        arn=pulumi.get(__response__, 'arn'),
        ecs_cluster_arn=pulumi.get(__response__, 'ecs_cluster_arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        service_role=pulumi.get(__response__, 'service_role'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        update_policies=pulumi.get(__response__, 'update_policies')))
