# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentArgs', 'AgentAgent']

@pulumi.input_type
class AgentAgentArgs:
    def __init__(__self__, *,
                 agent_name: pulumi.Input[_builtins.str],
                 agent_resource_role_arn: pulumi.Input[_builtins.str],
                 foundation_model: pulumi.Input[_builtins.str],
                 agent_collaboration: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 prompt_override_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentAgent resource.
        :param pulumi.Input[_builtins.str] agent_name: Name of the agent.
        :param pulumi.Input[_builtins.str] agent_resource_role_arn: ARN of the IAM role with permissions to invoke API operations on the agent.
        :param pulumi.Input[_builtins.str] foundation_model: Foundation model used for orchestration by the agent.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] agent_collaboration: Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: ARN of the AWS KMS key that encrypts the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]] guardrail_configurations: Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        :param pulumi.Input[_builtins.str] instruction: Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]] memory_configurations: Configurations for the agent's ability to retain the conversational context.
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]] prompt_override_configurations: Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "agent_name", agent_name)
        pulumi.set(__self__, "agent_resource_role_arn", agent_resource_role_arn)
        pulumi.set(__self__, "foundation_model", foundation_model)
        if agent_collaboration is not None:
            pulumi.set(__self__, "agent_collaboration", agent_collaboration)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guardrail_configurations is not None:
            pulumi.set(__self__, "guardrail_configurations", guardrail_configurations)
        if idle_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "idle_session_ttl_in_seconds", idle_session_ttl_in_seconds)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if memory_configurations is not None:
            pulumi.set(__self__, "memory_configurations", memory_configurations)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if prompt_override_configurations is not None:
            pulumi.set(__self__, "prompt_override_configurations", prompt_override_configurations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_resource_in_use_check is not None:
            pulumi.set(__self__, "skip_resource_in_use_check", skip_resource_in_use_check)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the agent.
        """
        return pulumi.get(self, "agent_name")

    @agent_name.setter
    def agent_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_name", value)

    @_builtins.property
    @pulumi.getter(name="agentResourceRoleArn")
    def agent_resource_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM role with permissions to invoke API operations on the agent.
        """
        return pulumi.get(self, "agent_resource_role_arn")

    @agent_resource_role_arn.setter
    def agent_resource_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_resource_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="foundationModel")
    def foundation_model(self) -> pulumi.Input[_builtins.str]:
        """
        Foundation model used for orchestration by the agent.

        The following arguments are optional:
        """
        return pulumi.get(self, "foundation_model")

    @foundation_model.setter
    def foundation_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "foundation_model", value)

    @_builtins.property
    @pulumi.getter(name="agentCollaboration")
    def agent_collaboration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        """
        return pulumi.get(self, "agent_collaboration")

    @agent_collaboration.setter
    def agent_collaboration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_collaboration", value)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the AWS KMS key that encrypts the agent.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="guardrailConfigurations")
    def guardrail_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]]:
        """
        Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        """
        return pulumi.get(self, "guardrail_configurations")

    @guardrail_configurations.setter
    def guardrail_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]]):
        pulumi.set(self, "guardrail_configurations", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_session_ttl_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter(name="memoryConfigurations")
    def memory_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]]:
        """
        Configurations for the agent's ability to retain the conversational context.
        """
        return pulumi.get(self, "memory_configurations")

    @memory_configurations.setter
    def memory_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]]):
        pulumi.set(self, "memory_configurations", value)

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prepare_agent", value)

    @_builtins.property
    @pulumi.getter(name="promptOverrideConfigurations")
    def prompt_override_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]]:
        """
        Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        """
        return pulumi.get(self, "prompt_override_configurations")

    @prompt_override_configurations.setter
    def prompt_override_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]]):
        pulumi.set(self, "prompt_override_configurations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the in-use check is skipped when deleting the agent.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @skip_resource_in_use_check.setter
    def skip_resource_in_use_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_resource_in_use_check", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentAgentState:
    def __init__(__self__, *,
                 agent_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_collaboration: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_model: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 prepared_at: Optional[pulumi.Input[_builtins.str]] = None,
                 prompt_override_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentAgent resources.
        :param pulumi.Input[_builtins.str] agent_arn: ARN of the agent.
        :param pulumi.Input[_builtins.str] agent_collaboration: Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        :param pulumi.Input[_builtins.str] agent_id: Unique identifier of the agent.
        :param pulumi.Input[_builtins.str] agent_name: Name of the agent.
        :param pulumi.Input[_builtins.str] agent_resource_role_arn: ARN of the IAM role with permissions to invoke API operations on the agent.
        :param pulumi.Input[_builtins.str] agent_version: Version of the agent.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: ARN of the AWS KMS key that encrypts the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[_builtins.str] foundation_model: Foundation model used for orchestration by the agent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]] guardrail_configurations: Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        :param pulumi.Input[_builtins.str] instruction: Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]] memory_configurations: Configurations for the agent's ability to retain the conversational context.
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] prepared_at: Timestamp of when the agent was last prepared.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]] prompt_override_configurations: Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if agent_arn is not None:
            pulumi.set(__self__, "agent_arn", agent_arn)
        if agent_collaboration is not None:
            pulumi.set(__self__, "agent_collaboration", agent_collaboration)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if agent_name is not None:
            pulumi.set(__self__, "agent_name", agent_name)
        if agent_resource_role_arn is not None:
            pulumi.set(__self__, "agent_resource_role_arn", agent_resource_role_arn)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if foundation_model is not None:
            pulumi.set(__self__, "foundation_model", foundation_model)
        if guardrail_configurations is not None:
            pulumi.set(__self__, "guardrail_configurations", guardrail_configurations)
        if idle_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "idle_session_ttl_in_seconds", idle_session_ttl_in_seconds)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if memory_configurations is not None:
            pulumi.set(__self__, "memory_configurations", memory_configurations)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if prepared_at is not None:
            pulumi.set(__self__, "prepared_at", prepared_at)
        if prompt_override_configurations is not None:
            pulumi.set(__self__, "prompt_override_configurations", prompt_override_configurations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_resource_in_use_check is not None:
            pulumi.set(__self__, "skip_resource_in_use_check", skip_resource_in_use_check)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentArn")
    def agent_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the agent.
        """
        return pulumi.get(self, "agent_arn")

    @agent_arn.setter
    def agent_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentCollaboration")
    def agent_collaboration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        """
        return pulumi.get(self, "agent_collaboration")

    @agent_collaboration.setter
    def agent_collaboration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_collaboration", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the agent.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the agent.
        """
        return pulumi.get(self, "agent_name")

    @agent_name.setter
    def agent_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_name", value)

    @_builtins.property
    @pulumi.getter(name="agentResourceRoleArn")
    def agent_resource_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role with permissions to invoke API operations on the agent.
        """
        return pulumi.get(self, "agent_resource_role_arn")

    @agent_resource_role_arn.setter
    def agent_resource_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_resource_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the agent.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the AWS KMS key that encrypts the agent.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="foundationModel")
    def foundation_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Foundation model used for orchestration by the agent.

        The following arguments are optional:
        """
        return pulumi.get(self, "foundation_model")

    @foundation_model.setter
    def foundation_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "foundation_model", value)

    @_builtins.property
    @pulumi.getter(name="guardrailConfigurations")
    def guardrail_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]]:
        """
        Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        """
        return pulumi.get(self, "guardrail_configurations")

    @guardrail_configurations.setter
    def guardrail_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentGuardrailConfigurationArgs']]]]):
        pulumi.set(self, "guardrail_configurations", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_session_ttl_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter(name="memoryConfigurations")
    def memory_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]]:
        """
        Configurations for the agent's ability to retain the conversational context.
        """
        return pulumi.get(self, "memory_configurations")

    @memory_configurations.setter
    def memory_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentMemoryConfigurationArgs']]]]):
        pulumi.set(self, "memory_configurations", value)

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prepare_agent", value)

    @_builtins.property
    @pulumi.getter(name="preparedAt")
    def prepared_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the agent was last prepared.
        """
        return pulumi.get(self, "prepared_at")

    @prepared_at.setter
    def prepared_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prepared_at", value)

    @_builtins.property
    @pulumi.getter(name="promptOverrideConfigurations")
    def prompt_override_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]]:
        """
        Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        """
        return pulumi.get(self, "prompt_override_configurations")

    @prompt_override_configurations.setter
    def prompt_override_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentPromptOverrideConfigurationArgs']]]]):
        pulumi.set(self, "prompt_override_configurations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the in-use check is skipped when deleting the agent.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @skip_resource_in_use_check.setter
    def skip_resource_in_use_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_resource_in_use_check", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentAgent:AgentAgent")
class AgentAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_collaboration: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_model: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentGuardrailConfigurationArgs', 'AgentAgentGuardrailConfigurationArgsDict']]]]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentMemoryConfigurationArgs', 'AgentAgentMemoryConfigurationArgsDict']]]]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 prompt_override_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentPromptOverrideConfigurationArgs', 'AgentAgentPromptOverrideConfigurationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentTimeoutsArgs', 'AgentAgentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example_agent_trust = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "identifiers": ["bedrock.amazonaws.com"],
                "type": "Service",
            }],
            "conditions": [
                {
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "aws:SourceAccount",
                },
                {
                    "test": "ArnLike",
                    "values": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}:{current.account_id}:agent/*"],
                    "variable": "AWS:SourceArn",
                },
            ],
        }])
        example_agent_permissions = aws.iam.get_policy_document(statements=[{
            "actions": ["bedrock:InvokeModel"],
            "resources": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}::foundation-model/anthropic.claude-v2"],
        }])
        example = aws.iam.Role("example",
            assume_role_policy=example_agent_trust.json,
            name_prefix="AmazonBedrockExecutionRoleForAgents_")
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_agent_permissions.json,
            role=example.id)
        example_agent_agent = aws.bedrock.AgentAgent("example",
            agent_name="my-agent-name",
            agent_resource_role_arn=example.arn,
            idle_session_ttl_in_seconds=500,
            instruction="You are a friendly assistant who helps answer questions.",
            foundation_model="anthropic.claude-v2")
        ```

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent using the agent ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgent:AgentAgent example GGRRAED6JP
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_collaboration: Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        :param pulumi.Input[_builtins.str] agent_name: Name of the agent.
        :param pulumi.Input[_builtins.str] agent_resource_role_arn: ARN of the IAM role with permissions to invoke API operations on the agent.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: ARN of the AWS KMS key that encrypts the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[_builtins.str] foundation_model: Foundation model used for orchestration by the agent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentGuardrailConfigurationArgs', 'AgentAgentGuardrailConfigurationArgsDict']]]] guardrail_configurations: Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        :param pulumi.Input[_builtins.str] instruction: Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentMemoryConfigurationArgs', 'AgentAgentMemoryConfigurationArgsDict']]]] memory_configurations: Configurations for the agent's ability to retain the conversational context.
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentPromptOverrideConfigurationArgs', 'AgentAgentPromptOverrideConfigurationArgsDict']]]] prompt_override_configurations: Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example_agent_trust = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "identifiers": ["bedrock.amazonaws.com"],
                "type": "Service",
            }],
            "conditions": [
                {
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "aws:SourceAccount",
                },
                {
                    "test": "ArnLike",
                    "values": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}:{current.account_id}:agent/*"],
                    "variable": "AWS:SourceArn",
                },
            ],
        }])
        example_agent_permissions = aws.iam.get_policy_document(statements=[{
            "actions": ["bedrock:InvokeModel"],
            "resources": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}::foundation-model/anthropic.claude-v2"],
        }])
        example = aws.iam.Role("example",
            assume_role_policy=example_agent_trust.json,
            name_prefix="AmazonBedrockExecutionRoleForAgents_")
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_agent_permissions.json,
            role=example.id)
        example_agent_agent = aws.bedrock.AgentAgent("example",
            agent_name="my-agent-name",
            agent_resource_role_arn=example.arn,
            idle_session_ttl_in_seconds=500,
            instruction="You are a friendly assistant who helps answer questions.",
            foundation_model="anthropic.claude-v2")
        ```

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent using the agent ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgent:AgentAgent example GGRRAED6JP
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_collaboration: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_resource_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 foundation_model: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrail_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentGuardrailConfigurationArgs', 'AgentAgentGuardrailConfigurationArgsDict']]]]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentMemoryConfigurationArgs', 'AgentAgentMemoryConfigurationArgsDict']]]]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 prompt_override_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentPromptOverrideConfigurationArgs', 'AgentAgentPromptOverrideConfigurationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_resource_in_use_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentTimeoutsArgs', 'AgentAgentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentArgs.__new__(AgentAgentArgs)

            __props__.__dict__["agent_collaboration"] = agent_collaboration
            if agent_name is None and not opts.urn:
                raise TypeError("Missing required property 'agent_name'")
            __props__.__dict__["agent_name"] = agent_name
            if agent_resource_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'agent_resource_role_arn'")
            __props__.__dict__["agent_resource_role_arn"] = agent_resource_role_arn
            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["description"] = description
            if foundation_model is None and not opts.urn:
                raise TypeError("Missing required property 'foundation_model'")
            __props__.__dict__["foundation_model"] = foundation_model
            __props__.__dict__["guardrail_configurations"] = guardrail_configurations
            __props__.__dict__["idle_session_ttl_in_seconds"] = idle_session_ttl_in_seconds
            __props__.__dict__["instruction"] = instruction
            __props__.__dict__["memory_configurations"] = memory_configurations
            __props__.__dict__["prepare_agent"] = prepare_agent
            __props__.__dict__["prompt_override_configurations"] = prompt_override_configurations
            __props__.__dict__["region"] = region
            __props__.__dict__["skip_resource_in_use_check"] = skip_resource_in_use_check
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["agent_arn"] = None
            __props__.__dict__["agent_id"] = None
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["prepared_at"] = None
            __props__.__dict__["tags_all"] = None
        super(AgentAgent, __self__).__init__(
            'aws:bedrock/agentAgent:AgentAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_collaboration: Optional[pulumi.Input[_builtins.str]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_resource_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            foundation_model: Optional[pulumi.Input[_builtins.str]] = None,
            guardrail_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentGuardrailConfigurationArgs', 'AgentAgentGuardrailConfigurationArgsDict']]]]] = None,
            idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            instruction: Optional[pulumi.Input[_builtins.str]] = None,
            memory_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentMemoryConfigurationArgs', 'AgentAgentMemoryConfigurationArgsDict']]]]] = None,
            prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            prepared_at: Optional[pulumi.Input[_builtins.str]] = None,
            prompt_override_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentPromptOverrideConfigurationArgs', 'AgentAgentPromptOverrideConfigurationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            skip_resource_in_use_check: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentAgentTimeoutsArgs', 'AgentAgentTimeoutsArgsDict']]] = None) -> 'AgentAgent':
        """
        Get an existing AgentAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_arn: ARN of the agent.
        :param pulumi.Input[_builtins.str] agent_collaboration: Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        :param pulumi.Input[_builtins.str] agent_id: Unique identifier of the agent.
        :param pulumi.Input[_builtins.str] agent_name: Name of the agent.
        :param pulumi.Input[_builtins.str] agent_resource_role_arn: ARN of the IAM role with permissions to invoke API operations on the agent.
        :param pulumi.Input[_builtins.str] agent_version: Version of the agent.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: ARN of the AWS KMS key that encrypts the agent.
        :param pulumi.Input[_builtins.str] description: Description of the agent.
        :param pulumi.Input[_builtins.str] foundation_model: Foundation model used for orchestration by the agent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentGuardrailConfigurationArgs', 'AgentAgentGuardrailConfigurationArgsDict']]]] guardrail_configurations: Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        :param pulumi.Input[_builtins.str] instruction: Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentMemoryConfigurationArgs', 'AgentAgentMemoryConfigurationArgsDict']]]] memory_configurations: Configurations for the agent's ability to retain the conversational context.
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] prepared_at: Timestamp of when the agent was last prepared.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentPromptOverrideConfigurationArgs', 'AgentAgentPromptOverrideConfigurationArgsDict']]]] prompt_override_configurations: Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_resource_in_use_check: Whether the in-use check is skipped when deleting the agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentState.__new__(_AgentAgentState)

        __props__.__dict__["agent_arn"] = agent_arn
        __props__.__dict__["agent_collaboration"] = agent_collaboration
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["agent_name"] = agent_name
        __props__.__dict__["agent_resource_role_arn"] = agent_resource_role_arn
        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
        __props__.__dict__["description"] = description
        __props__.__dict__["foundation_model"] = foundation_model
        __props__.__dict__["guardrail_configurations"] = guardrail_configurations
        __props__.__dict__["idle_session_ttl_in_seconds"] = idle_session_ttl_in_seconds
        __props__.__dict__["instruction"] = instruction
        __props__.__dict__["memory_configurations"] = memory_configurations
        __props__.__dict__["prepare_agent"] = prepare_agent
        __props__.__dict__["prepared_at"] = prepared_at
        __props__.__dict__["prompt_override_configurations"] = prompt_override_configurations
        __props__.__dict__["region"] = region
        __props__.__dict__["skip_resource_in_use_check"] = skip_resource_in_use_check
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return AgentAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentArn")
    def agent_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the agent.
        """
        return pulumi.get(self, "agent_arn")

    @_builtins.property
    @pulumi.getter(name="agentCollaboration")
    def agent_collaboration(self) -> pulumi.Output[_builtins.str]:
        """
        Agents collaboration role. Valid values: `SUPERVISOR`, `SUPERVISOR_ROUTER`, `DISABLED`.
        """
        return pulumi.get(self, "agent_collaboration")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the agent.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the agent.
        """
        return pulumi.get(self, "agent_name")

    @_builtins.property
    @pulumi.getter(name="agentResourceRoleArn")
    def agent_resource_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role with permissions to invoke API operations on the agent.
        """
        return pulumi.get(self, "agent_resource_role_arn")

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the agent.
        """
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the AWS KMS key that encrypts the agent.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="foundationModel")
    def foundation_model(self) -> pulumi.Output[_builtins.str]:
        """
        Foundation model used for orchestration by the agent.

        The following arguments are optional:
        """
        return pulumi.get(self, "foundation_model")

    @_builtins.property
    @pulumi.getter(name="guardrailConfigurations")
    def guardrail_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AgentAgentGuardrailConfiguration']]]:
        """
        Details about the guardrail associated with the agent. See `guardrail_configuration` Block for details.
        """
        return pulumi.get(self, "guardrail_configurations")

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> pulumi.Output[_builtins.str]:
        """
        Instructions that tell the agent what it should do and how it should interact with users. If `prepare_agent` is `true` this argument is required. The valid range is 40 - 20000 characters.
        """
        return pulumi.get(self, "instruction")

    @_builtins.property
    @pulumi.getter(name="memoryConfigurations")
    def memory_configurations(self) -> pulumi.Output[Sequence['outputs.AgentAgentMemoryConfiguration']]:
        """
        Configurations for the agent's ability to retain the conversational context.
        """
        return pulumi.get(self, "memory_configurations")

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @_builtins.property
    @pulumi.getter(name="preparedAt")
    def prepared_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the agent was last prepared.
        """
        return pulumi.get(self, "prepared_at")

    @_builtins.property
    @pulumi.getter(name="promptOverrideConfigurations")
    def prompt_override_configurations(self) -> pulumi.Output[Sequence['outputs.AgentAgentPromptOverrideConfiguration']]:
        """
        Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
        """
        return pulumi.get(self, "prompt_override_configurations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="skipResourceInUseCheck")
    def skip_resource_in_use_check(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the in-use check is skipped when deleting the agent.
        """
        return pulumi.get(self, "skip_resource_in_use_check")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentAgentTimeouts']]:
        return pulumi.get(self, "timeouts")

