# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentCollaboratorArgs', 'AgentAgentCollaborator']

@pulumi.input_type
class AgentAgentCollaboratorArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 collaboration_instruction: pulumi.Input[_builtins.str],
                 collaborator_name: pulumi.Input[_builtins.str],
                 agent_descriptor: Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_conversation_history: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentAgentCollaborator resource.
        :param pulumi.Input[_builtins.str] agent_id: ID if the agent to associate the collaborator.
        :param pulumi.Input[_builtins.str] collaboration_instruction: Instruction to give the collaborator.
        :param pulumi.Input[_builtins.str] collaborator_name: Name of this collaborator.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relay_conversation_history: Configure relaying the history to the collaborator.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "collaboration_instruction", collaboration_instruction)
        pulumi.set(__self__, "collaborator_name", collaborator_name)
        if agent_descriptor is not None:
            pulumi.set(__self__, "agent_descriptor", agent_descriptor)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if relay_conversation_history is not None:
            pulumi.set(__self__, "relay_conversation_history", relay_conversation_history)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID if the agent to associate the collaborator.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="collaborationInstruction")
    def collaboration_instruction(self) -> pulumi.Input[_builtins.str]:
        """
        Instruction to give the collaborator.
        """
        return pulumi.get(self, "collaboration_instruction")

    @collaboration_instruction.setter
    def collaboration_instruction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collaboration_instruction", value)

    @_builtins.property
    @pulumi.getter(name="collaboratorName")
    def collaborator_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of this collaborator.

        The following arguments are optional:
        """
        return pulumi.get(self, "collaborator_name")

    @collaborator_name.setter
    def collaborator_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collaborator_name", value)

    @_builtins.property
    @pulumi.getter(name="agentDescriptor")
    def agent_descriptor(self) -> Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']]:
        return pulumi.get(self, "agent_descriptor")

    @agent_descriptor.setter
    def agent_descriptor(self, value: Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']]):
        pulumi.set(self, "agent_descriptor", value)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prepare_agent", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="relayConversationHistory")
    def relay_conversation_history(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure relaying the history to the collaborator.
        """
        return pulumi.get(self, "relay_conversation_history")

    @relay_conversation_history.setter
    def relay_conversation_history(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_conversation_history", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentAgentCollaboratorState:
    def __init__(__self__, *,
                 agent_descriptor: Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 collaboration_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 collaborator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 collaborator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_conversation_history: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentAgentCollaborator resources.
        :param pulumi.Input[_builtins.str] agent_id: ID if the agent to associate the collaborator.
        :param pulumi.Input[_builtins.str] collaboration_instruction: Instruction to give the collaborator.
        :param pulumi.Input[_builtins.str] collaborator_id: ID of the Agent Collaborator.
        :param pulumi.Input[_builtins.str] collaborator_name: Name of this collaborator.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relay_conversation_history: Configure relaying the history to the collaborator.
        """
        if agent_descriptor is not None:
            pulumi.set(__self__, "agent_descriptor", agent_descriptor)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if collaboration_instruction is not None:
            pulumi.set(__self__, "collaboration_instruction", collaboration_instruction)
        if collaborator_id is not None:
            pulumi.set(__self__, "collaborator_id", collaborator_id)
        if collaborator_name is not None:
            pulumi.set(__self__, "collaborator_name", collaborator_name)
        if prepare_agent is not None:
            pulumi.set(__self__, "prepare_agent", prepare_agent)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if relay_conversation_history is not None:
            pulumi.set(__self__, "relay_conversation_history", relay_conversation_history)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentDescriptor")
    def agent_descriptor(self) -> Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']]:
        return pulumi.get(self, "agent_descriptor")

    @agent_descriptor.setter
    def agent_descriptor(self, value: Optional[pulumi.Input['AgentAgentCollaboratorAgentDescriptorArgs']]):
        pulumi.set(self, "agent_descriptor", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID if the agent to associate the collaborator.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter(name="collaborationInstruction")
    def collaboration_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instruction to give the collaborator.
        """
        return pulumi.get(self, "collaboration_instruction")

    @collaboration_instruction.setter
    def collaboration_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collaboration_instruction", value)

    @_builtins.property
    @pulumi.getter(name="collaboratorId")
    def collaborator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Agent Collaborator.
        """
        return pulumi.get(self, "collaborator_id")

    @collaborator_id.setter
    def collaborator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collaborator_id", value)

    @_builtins.property
    @pulumi.getter(name="collaboratorName")
    def collaborator_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of this collaborator.

        The following arguments are optional:
        """
        return pulumi.get(self, "collaborator_name")

    @collaborator_name.setter
    def collaborator_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collaborator_name", value)

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @prepare_agent.setter
    def prepare_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prepare_agent", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="relayConversationHistory")
    def relay_conversation_history(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure relaying the history to the collaborator.
        """
        return pulumi.get(self, "relay_conversation_history")

    @relay_conversation_history.setter
    def relay_conversation_history(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_conversation_history", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentCollaboratorTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentAgentCollaborator:AgentAgentCollaborator")
class AgentAgentCollaborator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_descriptor: Optional[pulumi.Input[Union['AgentAgentCollaboratorAgentDescriptorArgs', 'AgentAgentCollaboratorAgentDescriptorArgsDict']]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 collaboration_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 collaborator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_conversation_history: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentCollaboratorTimeoutsArgs', 'AgentAgentCollaboratorTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Bedrock Agents Agent Collaborator.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example_agent_trust = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "identifiers": ["bedrock.amazonaws.com"],
                "type": "Service",
            }],
            "conditions": [
                {
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "aws:SourceAccount",
                },
                {
                    "test": "ArnLike",
                    "values": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}:{current.account_id}:agent/*"],
                    "variable": "AWS:SourceArn",
                },
            ],
        }])
        example_agent_permissions = aws.iam.get_policy_document(statements=[
            {
                "actions": ["bedrock:InvokeModel"],
                "resources": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}::foundation-model/anthropic.claude-3-5-sonnet-20241022-v2:0"],
            },
            {
                "actions": [
                    "bedrock:GetAgentAlias",
                    "bedrock:InvokeAgent",
                ],
                "resources": [
                    f"arn:{current_agent['partition']}:bedrock:{current_get_region.region}:{current.account_id}:agent/*",
                    f"arn:{current_agent['partition']}:bedrock:{current_get_region.region}:{current.account_id}:agent-alias/*",
                ],
            },
        ])
        example = aws.iam.Role("example",
            assume_role_policy=example_agent_trust.json,
            name_prefix="AmazonBedrockExecutionRoleForAgents_")
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_agent_permissions.json,
            role=example.id)
        example_collaborator = aws.bedrock.AgentAgent("example_collaborator",
            agent_name="my-agent-collaborator",
            agent_resource_role_arn=example.arn,
            idle_session_ttl_in_seconds=500,
            foundation_model="anthropic.claude-3-5-sonnet-20241022-v2:0",
            instruction="do what the supervisor tells you to do")
        example_supervisor = aws.bedrock.AgentAgent("example_supervisor",
            agent_name="my-agent-supervisor",
            agent_resource_role_arn=example.arn,
            agent_collaboration="SUPERVISOR",
            idle_session_ttl_in_seconds=500,
            foundation_model="anthropic.claude-3-5-sonnet-20241022-v2:0",
            instruction="tell the sub agent what to do",
            prepare_agent=False)
        example_agent_agent_alias = aws.bedrock.AgentAgentAlias("example",
            agent_alias_name="my-agent-alias",
            agent_id=example_collaborator.agent_id,
            description="Test Alias")
        example_agent_agent_collaborator = aws.bedrock.AgentAgentCollaborator("example",
            agent_id=example_supervisor.agent_id,
            collaboration_instruction="tell the other agent what to do",
            collaborator_name="my-collab-example",
            relay_conversation_history="TO_COLLABORATOR",
            agent_descriptor={
                "alias_arn": example_agent_agent_alias.agent_alias_arn,
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Agent Collaborator using a comma-delimited string combining `agent_id`, `agent_version`, and `collaborator_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentCollaborator:AgentAgentCollaborator example 9LSJO0BFI8,DRAFT,AG3TN4RQIY
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: ID if the agent to associate the collaborator.
        :param pulumi.Input[_builtins.str] collaboration_instruction: Instruction to give the collaborator.
        :param pulumi.Input[_builtins.str] collaborator_name: Name of this collaborator.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relay_conversation_history: Configure relaying the history to the collaborator.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentCollaboratorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Bedrock Agents Agent Collaborator.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        current_get_region = aws.get_region()
        example_agent_trust = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "identifiers": ["bedrock.amazonaws.com"],
                "type": "Service",
            }],
            "conditions": [
                {
                    "test": "StringEquals",
                    "values": [current.account_id],
                    "variable": "aws:SourceAccount",
                },
                {
                    "test": "ArnLike",
                    "values": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}:{current.account_id}:agent/*"],
                    "variable": "AWS:SourceArn",
                },
            ],
        }])
        example_agent_permissions = aws.iam.get_policy_document(statements=[
            {
                "actions": ["bedrock:InvokeModel"],
                "resources": [f"arn:{current_get_partition.partition}:bedrock:{current_get_region.region}::foundation-model/anthropic.claude-3-5-sonnet-20241022-v2:0"],
            },
            {
                "actions": [
                    "bedrock:GetAgentAlias",
                    "bedrock:InvokeAgent",
                ],
                "resources": [
                    f"arn:{current_agent['partition']}:bedrock:{current_get_region.region}:{current.account_id}:agent/*",
                    f"arn:{current_agent['partition']}:bedrock:{current_get_region.region}:{current.account_id}:agent-alias/*",
                ],
            },
        ])
        example = aws.iam.Role("example",
            assume_role_policy=example_agent_trust.json,
            name_prefix="AmazonBedrockExecutionRoleForAgents_")
        example_role_policy = aws.iam.RolePolicy("example",
            policy=example_agent_permissions.json,
            role=example.id)
        example_collaborator = aws.bedrock.AgentAgent("example_collaborator",
            agent_name="my-agent-collaborator",
            agent_resource_role_arn=example.arn,
            idle_session_ttl_in_seconds=500,
            foundation_model="anthropic.claude-3-5-sonnet-20241022-v2:0",
            instruction="do what the supervisor tells you to do")
        example_supervisor = aws.bedrock.AgentAgent("example_supervisor",
            agent_name="my-agent-supervisor",
            agent_resource_role_arn=example.arn,
            agent_collaboration="SUPERVISOR",
            idle_session_ttl_in_seconds=500,
            foundation_model="anthropic.claude-3-5-sonnet-20241022-v2:0",
            instruction="tell the sub agent what to do",
            prepare_agent=False)
        example_agent_agent_alias = aws.bedrock.AgentAgentAlias("example",
            agent_alias_name="my-agent-alias",
            agent_id=example_collaborator.agent_id,
            description="Test Alias")
        example_agent_agent_collaborator = aws.bedrock.AgentAgentCollaborator("example",
            agent_id=example_supervisor.agent_id,
            collaboration_instruction="tell the other agent what to do",
            collaborator_name="my-collab-example",
            relay_conversation_history="TO_COLLABORATOR",
            agent_descriptor={
                "alias_arn": example_agent_agent_alias.agent_alias_arn,
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Agent Collaborator using a comma-delimited string combining `agent_id`, `agent_version`, and `collaborator_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentCollaborator:AgentAgentCollaborator example 9LSJO0BFI8,DRAFT,AG3TN4RQIY
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentCollaboratorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentCollaboratorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_descriptor: Optional[pulumi.Input[Union['AgentAgentCollaboratorAgentDescriptorArgs', 'AgentAgentCollaboratorAgentDescriptorArgsDict']]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 collaboration_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 collaborator_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_conversation_history: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentCollaboratorTimeoutsArgs', 'AgentAgentCollaboratorTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentCollaboratorArgs.__new__(AgentAgentCollaboratorArgs)

            __props__.__dict__["agent_descriptor"] = agent_descriptor
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["agent_version"] = agent_version
            if collaboration_instruction is None and not opts.urn:
                raise TypeError("Missing required property 'collaboration_instruction'")
            __props__.__dict__["collaboration_instruction"] = collaboration_instruction
            if collaborator_name is None and not opts.urn:
                raise TypeError("Missing required property 'collaborator_name'")
            __props__.__dict__["collaborator_name"] = collaborator_name
            __props__.__dict__["prepare_agent"] = prepare_agent
            __props__.__dict__["region"] = region
            __props__.__dict__["relay_conversation_history"] = relay_conversation_history
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["collaborator_id"] = None
        super(AgentAgentCollaborator, __self__).__init__(
            'aws:bedrock/agentAgentCollaborator:AgentAgentCollaborator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_descriptor: Optional[pulumi.Input[Union['AgentAgentCollaboratorAgentDescriptorArgs', 'AgentAgentCollaboratorAgentDescriptorArgsDict']]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            collaboration_instruction: Optional[pulumi.Input[_builtins.str]] = None,
            collaborator_id: Optional[pulumi.Input[_builtins.str]] = None,
            collaborator_name: Optional[pulumi.Input[_builtins.str]] = None,
            prepare_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            relay_conversation_history: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentAgentCollaboratorTimeoutsArgs', 'AgentAgentCollaboratorTimeoutsArgsDict']]] = None) -> 'AgentAgentCollaborator':
        """
        Get an existing AgentAgentCollaborator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: ID if the agent to associate the collaborator.
        :param pulumi.Input[_builtins.str] collaboration_instruction: Instruction to give the collaborator.
        :param pulumi.Input[_builtins.str] collaborator_id: ID of the Agent Collaborator.
        :param pulumi.Input[_builtins.str] collaborator_name: Name of this collaborator.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] prepare_agent: Whether to prepare the agent after creation or modification. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relay_conversation_history: Configure relaying the history to the collaborator.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentCollaboratorState.__new__(_AgentAgentCollaboratorState)

        __props__.__dict__["agent_descriptor"] = agent_descriptor
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["collaboration_instruction"] = collaboration_instruction
        __props__.__dict__["collaborator_id"] = collaborator_id
        __props__.__dict__["collaborator_name"] = collaborator_name
        __props__.__dict__["prepare_agent"] = prepare_agent
        __props__.__dict__["region"] = region
        __props__.__dict__["relay_conversation_history"] = relay_conversation_history
        __props__.__dict__["timeouts"] = timeouts
        return AgentAgentCollaborator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentDescriptor")
    def agent_descriptor(self) -> pulumi.Output[Optional['outputs.AgentAgentCollaboratorAgentDescriptor']]:
        return pulumi.get(self, "agent_descriptor")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID if the agent to associate the collaborator.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter(name="collaborationInstruction")
    def collaboration_instruction(self) -> pulumi.Output[_builtins.str]:
        """
        Instruction to give the collaborator.
        """
        return pulumi.get(self, "collaboration_instruction")

    @_builtins.property
    @pulumi.getter(name="collaboratorId")
    def collaborator_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Agent Collaborator.
        """
        return pulumi.get(self, "collaborator_id")

    @_builtins.property
    @pulumi.getter(name="collaboratorName")
    def collaborator_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of this collaborator.

        The following arguments are optional:
        """
        return pulumi.get(self, "collaborator_name")

    @_builtins.property
    @pulumi.getter(name="prepareAgent")
    def prepare_agent(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to prepare the agent after creation or modification. Defaults to `true`.
        """
        return pulumi.get(self, "prepare_agent")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="relayConversationHistory")
    def relay_conversation_history(self) -> pulumi.Output[_builtins.str]:
        """
        Configure relaying the history to the collaborator.
        """
        return pulumi.get(self, "relay_conversation_history")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentAgentCollaboratorTimeouts']]:
        return pulumi.get(self, "timeouts")

