# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreAgentRuntimeArgs', 'AgentcoreAgentRuntime']

@pulumi.input_type
class AgentcoreAgentRuntimeArgs:
    def __init__(__self__, *,
                 agent_runtime_name: pulumi.Input[_builtins.str],
                 role_arn: pulumi.Input[_builtins.str],
                 agent_runtime_artifact: Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']] = None,
                 authorizer_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']] = None,
                 protocol_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_header_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreAgentRuntime resource.
        :param pulumi.Input[_builtins.str] agent_runtime_name: Name of the agent runtime.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the agent runtime assumes to access AWS services.
        :param pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs'] agent_runtime_artifact: Container artifact configuration. See `agent_runtime_artifact` below.
        :param pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs'] authorizer_configuration: Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Map of environment variables to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]] lifecycle_configurations: Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        :param pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs'] network_configuration: Network configuration for the agent runtime. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs'] protocol_configuration: Protocol configuration for the agent runtime. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs'] request_header_configuration: Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "agent_runtime_name", agent_runtime_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if agent_runtime_artifact is not None:
            pulumi.set(__self__, "agent_runtime_artifact", agent_runtime_artifact)
        if authorizer_configuration is not None:
            pulumi.set(__self__, "authorizer_configuration", authorizer_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if lifecycle_configurations is not None:
            pulumi.set(__self__, "lifecycle_configurations", lifecycle_configurations)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if protocol_configuration is not None:
            pulumi.set(__self__, "protocol_configuration", protocol_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_header_configuration is not None:
            pulumi.set(__self__, "request_header_configuration", request_header_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeName")
    def agent_runtime_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the agent runtime.
        """
        return pulumi.get(self, "agent_runtime_name")

    @agent_runtime_name.setter
    def agent_runtime_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM role that the agent runtime assumes to access AWS services.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArtifact")
    def agent_runtime_artifact(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']]:
        """
        Container artifact configuration. See `agent_runtime_artifact` below.
        """
        return pulumi.get(self, "agent_runtime_artifact")

    @agent_runtime_artifact.setter
    def agent_runtime_artifact(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']]):
        pulumi.set(self, "agent_runtime_artifact", value)

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']]:
        """
        Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @authorizer_configuration.setter
    def authorizer_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']]):
        pulumi.set(self, "authorizer_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent runtime.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of environment variables to pass to the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleConfigurations")
    def lifecycle_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]]:
        """
        Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        """
        return pulumi.get(self, "lifecycle_configurations")

    @lifecycle_configurations.setter
    def lifecycle_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]]):
        pulumi.set(self, "lifecycle_configurations", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']]:
        """
        Network configuration for the agent runtime. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']]:
        """
        Protocol configuration for the agent runtime. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @protocol_configuration.setter
    def protocol_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']]):
        pulumi.set(self, "protocol_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestHeaderConfiguration")
    def request_header_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']]:
        """
        Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        """
        return pulumi.get(self, "request_header_configuration")

    @request_header_configuration.setter
    def request_header_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']]):
        pulumi.set(self, "request_header_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreAgentRuntimeState:
    def __init__(__self__, *,
                 agent_runtime_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_artifact: Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']] = None,
                 agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizer_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']] = None,
                 protocol_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_header_configuration: Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']] = None,
                 workload_identity_details: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs']]]] = None):
        """
        Input properties used for looking up and filtering AgentcoreAgentRuntime resources.
        :param pulumi.Input[_builtins.str] agent_runtime_arn: ARN of the Agent Runtime.
        :param pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs'] agent_runtime_artifact: Container artifact configuration. See `agent_runtime_artifact` below.
        :param pulumi.Input[_builtins.str] agent_runtime_id: Unique identifier of the Agent Runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_name: Name of the agent runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the Agent Runtime.
        :param pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs'] authorizer_configuration: Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Map of environment variables to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]] lifecycle_configurations: Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        :param pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs'] network_configuration: Network configuration for the agent runtime. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs'] protocol_configuration: Protocol configuration for the agent runtime. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs'] request_header_configuration: Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the agent runtime assumes to access AWS services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs']]] workload_identity_details: Workload identity details for the agent runtime. See `workload_identity_details` below.
        """
        if agent_runtime_arn is not None:
            pulumi.set(__self__, "agent_runtime_arn", agent_runtime_arn)
        if agent_runtime_artifact is not None:
            pulumi.set(__self__, "agent_runtime_artifact", agent_runtime_artifact)
        if agent_runtime_id is not None:
            pulumi.set(__self__, "agent_runtime_id", agent_runtime_id)
        if agent_runtime_name is not None:
            pulumi.set(__self__, "agent_runtime_name", agent_runtime_name)
        if agent_runtime_version is not None:
            pulumi.set(__self__, "agent_runtime_version", agent_runtime_version)
        if authorizer_configuration is not None:
            pulumi.set(__self__, "authorizer_configuration", authorizer_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if lifecycle_configurations is not None:
            pulumi.set(__self__, "lifecycle_configurations", lifecycle_configurations)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if protocol_configuration is not None:
            pulumi.set(__self__, "protocol_configuration", protocol_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_header_configuration is not None:
            pulumi.set(__self__, "request_header_configuration", request_header_configuration)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if workload_identity_details is not None:
            pulumi.set(__self__, "workload_identity_details", workload_identity_details)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArn")
    def agent_runtime_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_arn")

    @agent_runtime_arn.setter
    def agent_runtime_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArtifact")
    def agent_runtime_artifact(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']]:
        """
        Container artifact configuration. See `agent_runtime_artifact` below.
        """
        return pulumi.get(self, "agent_runtime_artifact")

    @agent_runtime_artifact.setter
    def agent_runtime_artifact(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs']]):
        pulumi.set(self, "agent_runtime_artifact", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeId")
    def agent_runtime_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_id")

    @agent_runtime_id.setter
    def agent_runtime_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_id", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeName")
    def agent_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the agent runtime.
        """
        return pulumi.get(self, "agent_runtime_name")

    @agent_runtime_name.setter
    def agent_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeVersion")
    def agent_runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_version")

    @agent_runtime_version.setter
    def agent_runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_version", value)

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']]:
        """
        Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @authorizer_configuration.setter
    def authorizer_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeAuthorizerConfigurationArgs']]):
        pulumi.set(self, "authorizer_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent runtime.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of environment variables to pass to the container.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleConfigurations")
    def lifecycle_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]]:
        """
        Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        """
        return pulumi.get(self, "lifecycle_configurations")

    @lifecycle_configurations.setter
    def lifecycle_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeLifecycleConfigurationArgs']]]]):
        pulumi.set(self, "lifecycle_configurations", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']]:
        """
        Network configuration for the agent runtime. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']]:
        """
        Protocol configuration for the agent runtime. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @protocol_configuration.setter
    def protocol_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeProtocolConfigurationArgs']]):
        pulumi.set(self, "protocol_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestHeaderConfiguration")
    def request_header_configuration(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']]:
        """
        Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        """
        return pulumi.get(self, "request_header_configuration")

    @request_header_configuration.setter
    def request_header_configuration(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs']]):
        pulumi.set(self, "request_header_configuration", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that the agent runtime assumes to access AWS services.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityDetails")
    def workload_identity_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs']]]]:
        """
        Workload identity details for the agent runtime. See `workload_identity_details` below.
        """
        return pulumi.get(self, "workload_identity_details")

    @workload_identity_details.setter
    def workload_identity_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs']]]]):
        pulumi.set(self, "workload_identity_details", value)


@pulumi.type_token("aws:bedrock/agentcoreAgentRuntime:AgentcoreAgentRuntime")
class AgentcoreAgentRuntime(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_runtime_artifact: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs', 'AgentcoreAgentRuntimeAgentRuntimeArtifactArgsDict']]] = None,
                 agent_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAuthorizerConfigurationArgs', 'AgentcoreAgentRuntimeAuthorizerConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeLifecycleConfigurationArgs', 'AgentcoreAgentRuntimeLifecycleConfigurationArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeNetworkConfigurationArgs', 'AgentcoreAgentRuntimeNetworkConfigurationArgsDict']]] = None,
                 protocol_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeProtocolConfigurationArgs', 'AgentcoreAgentRuntimeProtocolConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_header_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs', 'AgentcoreAgentRuntimeRequestHeaderConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeTimeoutsArgs', 'AgentcoreAgentRuntimeTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Agent Runtime. Agent Runtime provides a containerized execution environment for AI agents.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        ecr_permissions = aws.iam.get_policy_document(statements=[
            {
                "actions": ["ecr:GetAuthorizationToken"],
                "effect": "Allow",
                "resources": ["*"],
            },
            {
                "actions": [
                    "ecr:BatchGetImage",
                    "ecr:GetDownloadUrlForLayer",
                ],
                "effect": "Allow",
                "resources": [example_aws_ecr_repository["arn"]],
            },
        ])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-runtime-role",
            assume_role_policy=assume_role.json)
        example_role_policy = aws.iam.RolePolicy("example",
            role=example.id,
            policy=ecr_permissions.json)
        example_agentcore_agent_runtime = aws.bedrock.AgentcoreAgentRuntime("example",
            agent_runtime_name="example-agent-runtime",
            role_arn=example.arn,
            agent_runtime_artifact={
                "container_configuration": {
                    "container_uri": f"{example_aws_ecr_repository['repositoryUrl']}:latest",
                },
            },
            network_configuration={
                "network_mode": "PUBLIC",
            })
        ```

        ### MCP Server With Custom JWT Authorizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreAgentRuntime("example",
            agent_runtime_name="example-agent-runtime",
            description="Agent runtime with JWT authorization",
            role_arn=example_aws_iam_role["arn"],
            agent_runtime_artifact={
                "container_configuration": {
                    "container_uri": f"{example_aws_ecr_repository['repositoryUrl']}:v1.0",
                },
            },
            environment_variables={
                "LOG_LEVEL": "INFO",
                "ENV": "production",
            },
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://accounts.google.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "my-app",
                        "mobile-app",
                    ],
                    "allowed_clients": [
                        "client-123",
                        "client-456",
                    ],
                },
            },
            network_configuration={
                "network_mode": "PUBLIC",
            },
            protocol_configuration={
                "server_protocol": "MCP",
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Agent Runtime using `agent_runtime_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreAgentRuntime:AgentcoreAgentRuntime example agent-runtime-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs', 'AgentcoreAgentRuntimeAgentRuntimeArtifactArgsDict']] agent_runtime_artifact: Container artifact configuration. See `agent_runtime_artifact` below.
        :param pulumi.Input[_builtins.str] agent_runtime_name: Name of the agent runtime.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeAuthorizerConfigurationArgs', 'AgentcoreAgentRuntimeAuthorizerConfigurationArgsDict']] authorizer_configuration: Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Map of environment variables to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeLifecycleConfigurationArgs', 'AgentcoreAgentRuntimeLifecycleConfigurationArgsDict']]]] lifecycle_configurations: Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeNetworkConfigurationArgs', 'AgentcoreAgentRuntimeNetworkConfigurationArgsDict']] network_configuration: Network configuration for the agent runtime. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[Union['AgentcoreAgentRuntimeProtocolConfigurationArgs', 'AgentcoreAgentRuntimeProtocolConfigurationArgsDict']] protocol_configuration: Protocol configuration for the agent runtime. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs', 'AgentcoreAgentRuntimeRequestHeaderConfigurationArgsDict']] request_header_configuration: Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the agent runtime assumes to access AWS services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreAgentRuntimeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Agent Runtime. Agent Runtime provides a containerized execution environment for AI agents.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        ecr_permissions = aws.iam.get_policy_document(statements=[
            {
                "actions": ["ecr:GetAuthorizationToken"],
                "effect": "Allow",
                "resources": ["*"],
            },
            {
                "actions": [
                    "ecr:BatchGetImage",
                    "ecr:GetDownloadUrlForLayer",
                ],
                "effect": "Allow",
                "resources": [example_aws_ecr_repository["arn"]],
            },
        ])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-runtime-role",
            assume_role_policy=assume_role.json)
        example_role_policy = aws.iam.RolePolicy("example",
            role=example.id,
            policy=ecr_permissions.json)
        example_agentcore_agent_runtime = aws.bedrock.AgentcoreAgentRuntime("example",
            agent_runtime_name="example-agent-runtime",
            role_arn=example.arn,
            agent_runtime_artifact={
                "container_configuration": {
                    "container_uri": f"{example_aws_ecr_repository['repositoryUrl']}:latest",
                },
            },
            network_configuration={
                "network_mode": "PUBLIC",
            })
        ```

        ### MCP Server With Custom JWT Authorizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreAgentRuntime("example",
            agent_runtime_name="example-agent-runtime",
            description="Agent runtime with JWT authorization",
            role_arn=example_aws_iam_role["arn"],
            agent_runtime_artifact={
                "container_configuration": {
                    "container_uri": f"{example_aws_ecr_repository['repositoryUrl']}:v1.0",
                },
            },
            environment_variables={
                "LOG_LEVEL": "INFO",
                "ENV": "production",
            },
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://accounts.google.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "my-app",
                        "mobile-app",
                    ],
                    "allowed_clients": [
                        "client-123",
                        "client-456",
                    ],
                },
            },
            network_configuration={
                "network_mode": "PUBLIC",
            },
            protocol_configuration={
                "server_protocol": "MCP",
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Agent Runtime using `agent_runtime_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreAgentRuntime:AgentcoreAgentRuntime example agent-runtime-12345
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreAgentRuntimeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreAgentRuntimeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_runtime_artifact: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs', 'AgentcoreAgentRuntimeAgentRuntimeArtifactArgsDict']]] = None,
                 agent_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAuthorizerConfigurationArgs', 'AgentcoreAgentRuntimeAuthorizerConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeLifecycleConfigurationArgs', 'AgentcoreAgentRuntimeLifecycleConfigurationArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeNetworkConfigurationArgs', 'AgentcoreAgentRuntimeNetworkConfigurationArgsDict']]] = None,
                 protocol_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeProtocolConfigurationArgs', 'AgentcoreAgentRuntimeProtocolConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_header_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs', 'AgentcoreAgentRuntimeRequestHeaderConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeTimeoutsArgs', 'AgentcoreAgentRuntimeTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreAgentRuntimeArgs.__new__(AgentcoreAgentRuntimeArgs)

            __props__.__dict__["agent_runtime_artifact"] = agent_runtime_artifact
            if agent_runtime_name is None and not opts.urn:
                raise TypeError("Missing required property 'agent_runtime_name'")
            __props__.__dict__["agent_runtime_name"] = agent_runtime_name
            __props__.__dict__["authorizer_configuration"] = authorizer_configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["lifecycle_configurations"] = lifecycle_configurations
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["protocol_configuration"] = protocol_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["request_header_configuration"] = request_header_configuration
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["agent_runtime_arn"] = None
            __props__.__dict__["agent_runtime_id"] = None
            __props__.__dict__["agent_runtime_version"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["workload_identity_details"] = None
        super(AgentcoreAgentRuntime, __self__).__init__(
            'aws:bedrock/agentcoreAgentRuntime:AgentcoreAgentRuntime',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_runtime_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_artifact: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs', 'AgentcoreAgentRuntimeAgentRuntimeArtifactArgsDict']]] = None,
            agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
            authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeAuthorizerConfigurationArgs', 'AgentcoreAgentRuntimeAuthorizerConfigurationArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeLifecycleConfigurationArgs', 'AgentcoreAgentRuntimeLifecycleConfigurationArgsDict']]]]] = None,
            network_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeNetworkConfigurationArgs', 'AgentcoreAgentRuntimeNetworkConfigurationArgsDict']]] = None,
            protocol_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeProtocolConfigurationArgs', 'AgentcoreAgentRuntimeProtocolConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            request_header_configuration: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs', 'AgentcoreAgentRuntimeRequestHeaderConfigurationArgsDict']]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeTimeoutsArgs', 'AgentcoreAgentRuntimeTimeoutsArgsDict']]] = None,
            workload_identity_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs', 'AgentcoreAgentRuntimeWorkloadIdentityDetailArgsDict']]]]] = None) -> 'AgentcoreAgentRuntime':
        """
        Get an existing AgentcoreAgentRuntime resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_runtime_arn: ARN of the Agent Runtime.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeAgentRuntimeArtifactArgs', 'AgentcoreAgentRuntimeAgentRuntimeArtifactArgsDict']] agent_runtime_artifact: Container artifact configuration. See `agent_runtime_artifact` below.
        :param pulumi.Input[_builtins.str] agent_runtime_id: Unique identifier of the Agent Runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_name: Name of the agent runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the Agent Runtime.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeAuthorizerConfigurationArgs', 'AgentcoreAgentRuntimeAuthorizerConfigurationArgsDict']] authorizer_configuration: Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Map of environment variables to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeLifecycleConfigurationArgs', 'AgentcoreAgentRuntimeLifecycleConfigurationArgsDict']]]] lifecycle_configurations: Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeNetworkConfigurationArgs', 'AgentcoreAgentRuntimeNetworkConfigurationArgsDict']] network_configuration: Network configuration for the agent runtime. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[Union['AgentcoreAgentRuntimeProtocolConfigurationArgs', 'AgentcoreAgentRuntimeProtocolConfigurationArgsDict']] protocol_configuration: Protocol configuration for the agent runtime. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['AgentcoreAgentRuntimeRequestHeaderConfigurationArgs', 'AgentcoreAgentRuntimeRequestHeaderConfigurationArgsDict']] request_header_configuration: Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the agent runtime assumes to access AWS services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreAgentRuntimeWorkloadIdentityDetailArgs', 'AgentcoreAgentRuntimeWorkloadIdentityDetailArgsDict']]]] workload_identity_details: Workload identity details for the agent runtime. See `workload_identity_details` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreAgentRuntimeState.__new__(_AgentcoreAgentRuntimeState)

        __props__.__dict__["agent_runtime_arn"] = agent_runtime_arn
        __props__.__dict__["agent_runtime_artifact"] = agent_runtime_artifact
        __props__.__dict__["agent_runtime_id"] = agent_runtime_id
        __props__.__dict__["agent_runtime_name"] = agent_runtime_name
        __props__.__dict__["agent_runtime_version"] = agent_runtime_version
        __props__.__dict__["authorizer_configuration"] = authorizer_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["lifecycle_configurations"] = lifecycle_configurations
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["protocol_configuration"] = protocol_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["request_header_configuration"] = request_header_configuration
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["workload_identity_details"] = workload_identity_details
        return AgentcoreAgentRuntime(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArn")
    def agent_runtime_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_arn")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArtifact")
    def agent_runtime_artifact(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeAgentRuntimeArtifact']]:
        """
        Container artifact configuration. See `agent_runtime_artifact` below.
        """
        return pulumi.get(self, "agent_runtime_artifact")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeId")
    def agent_runtime_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_id")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeName")
    def agent_runtime_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the agent runtime.
        """
        return pulumi.get(self, "agent_runtime_name")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeVersion")
    def agent_runtime_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_version")

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeAuthorizerConfiguration']]:
        """
        Authorization configuration for authenticating incoming requests. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the agent runtime.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of environment variables to pass to the container.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="lifecycleConfigurations")
    def lifecycle_configurations(self) -> pulumi.Output[Sequence['outputs.AgentcoreAgentRuntimeLifecycleConfiguration']]:
        """
        Runtime session and resource lifecycle configuration for the agent runtime. See `lifecycle_configuration` below.
        """
        return pulumi.get(self, "lifecycle_configurations")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeNetworkConfiguration']]:
        """
        Network configuration for the agent runtime. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeProtocolConfiguration']]:
        """
        Protocol configuration for the agent runtime. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestHeaderConfiguration")
    def request_header_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeRequestHeaderConfiguration']]:
        """
        Configuration for HTTP request headers that will be passed through to the runtime. See `request_header_configuration` below.
        """
        return pulumi.get(self, "request_header_configuration")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role that the agent runtime assumes to access AWS services.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityDetails")
    def workload_identity_details(self) -> pulumi.Output[Sequence['outputs.AgentcoreAgentRuntimeWorkloadIdentityDetail']]:
        """
        Workload identity details for the agent runtime. See `workload_identity_details` below.
        """
        return pulumi.get(self, "workload_identity_details")

