# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreAgentRuntimeEndpointArgs', 'AgentcoreAgentRuntimeEndpoint']

@pulumi.input_type
class AgentcoreAgentRuntimeEndpointArgs:
    def __init__(__self__, *,
                 agent_runtime_id: pulumi.Input[_builtins.str],
                 agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreAgentRuntimeEndpoint resource.
        :param pulumi.Input[_builtins.str] agent_runtime_id: ID of the agent runtime this endpoint belongs to.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the agent runtime to use for this endpoint.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] name: Name of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "agent_runtime_id", agent_runtime_id)
        if agent_runtime_version is not None:
            pulumi.set(__self__, "agent_runtime_version", agent_runtime_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeId")
    def agent_runtime_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the agent runtime this endpoint belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_runtime_id")

    @agent_runtime_id.setter
    def agent_runtime_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_runtime_id", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeVersion")
    def agent_runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the agent runtime to use for this endpoint.
        """
        return pulumi.get(self, "agent_runtime_version")

    @agent_runtime_version.setter
    def agent_runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent runtime endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the agent runtime endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreAgentRuntimeEndpointState:
    def __init__(__self__, *,
                 agent_runtime_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentcoreAgentRuntimeEndpoint resources.
        :param pulumi.Input[_builtins.str] agent_runtime_arn: ARN of the associated Agent Runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_id: ID of the agent runtime this endpoint belongs to.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the agent runtime to use for this endpoint.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] name: Name of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if agent_runtime_arn is not None:
            pulumi.set(__self__, "agent_runtime_arn", agent_runtime_arn)
        if agent_runtime_endpoint_arn is not None:
            pulumi.set(__self__, "agent_runtime_endpoint_arn", agent_runtime_endpoint_arn)
        if agent_runtime_id is not None:
            pulumi.set(__self__, "agent_runtime_id", agent_runtime_id)
        if agent_runtime_version is not None:
            pulumi.set(__self__, "agent_runtime_version", agent_runtime_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArn")
    def agent_runtime_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the associated Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_arn")

    @agent_runtime_arn.setter
    def agent_runtime_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeEndpointArn")
    def agent_runtime_endpoint_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agent_runtime_endpoint_arn")

    @agent_runtime_endpoint_arn.setter
    def agent_runtime_endpoint_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_endpoint_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeId")
    def agent_runtime_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the agent runtime this endpoint belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_runtime_id")

    @agent_runtime_id.setter
    def agent_runtime_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_id", value)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeVersion")
    def agent_runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the agent runtime to use for this endpoint.
        """
        return pulumi.get(self, "agent_runtime_version")

    @agent_runtime_version.setter
    def agent_runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_runtime_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the agent runtime endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the agent runtime endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreAgentRuntimeEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentcoreAgentRuntimeEndpoint:AgentcoreAgentRuntimeEndpoint")
class AgentcoreAgentRuntimeEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeEndpointTimeoutsArgs', 'AgentcoreAgentRuntimeEndpointTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Agent Runtime Endpoint. Agent Runtime Endpoints provide a network-accessible interface for interacting with agent runtimes, enabling external systems to communicate with and invoke agent capabilities.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreAgentRuntimeEndpoint("example",
            name="example-endpoint",
            agent_runtime_id=example_aws_bedrockagentcore_agent_runtime["agentRuntimeId"],
            description="Endpoint for agent runtime communication")
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Agent Runtime Endpoint using the `agent_runtime_id` and `name` separated by a comma. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreAgentRuntimeEndpoint:AgentcoreAgentRuntimeEndpoint example AGENTRUNTIME1234567890,example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_runtime_id: ID of the agent runtime this endpoint belongs to.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the agent runtime to use for this endpoint.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] name: Name of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreAgentRuntimeEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Agent Runtime Endpoint. Agent Runtime Endpoints provide a network-accessible interface for interacting with agent runtimes, enabling external systems to communicate with and invoke agent capabilities.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreAgentRuntimeEndpoint("example",
            name="example-endpoint",
            agent_runtime_id=example_aws_bedrockagentcore_agent_runtime["agentRuntimeId"],
            description="Endpoint for agent runtime communication")
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Agent Runtime Endpoint using the `agent_runtime_id` and `name` separated by a comma. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreAgentRuntimeEndpoint:AgentcoreAgentRuntimeEndpoint example AGENTRUNTIME1234567890,example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreAgentRuntimeEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreAgentRuntimeEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeEndpointTimeoutsArgs', 'AgentcoreAgentRuntimeEndpointTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreAgentRuntimeEndpointArgs.__new__(AgentcoreAgentRuntimeEndpointArgs)

            if agent_runtime_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_runtime_id'")
            __props__.__dict__["agent_runtime_id"] = agent_runtime_id
            __props__.__dict__["agent_runtime_version"] = agent_runtime_version
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["agent_runtime_arn"] = None
            __props__.__dict__["agent_runtime_endpoint_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(AgentcoreAgentRuntimeEndpoint, __self__).__init__(
            'aws:bedrock/agentcoreAgentRuntimeEndpoint:AgentcoreAgentRuntimeEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_runtime_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_endpoint_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreAgentRuntimeEndpointTimeoutsArgs', 'AgentcoreAgentRuntimeEndpointTimeoutsArgsDict']]] = None) -> 'AgentcoreAgentRuntimeEndpoint':
        """
        Get an existing AgentcoreAgentRuntimeEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_runtime_arn: ARN of the associated Agent Runtime.
        :param pulumi.Input[_builtins.str] agent_runtime_id: ID of the agent runtime this endpoint belongs to.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] agent_runtime_version: Version of the agent runtime to use for this endpoint.
        :param pulumi.Input[_builtins.str] description: Description of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] name: Name of the agent runtime endpoint.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreAgentRuntimeEndpointState.__new__(_AgentcoreAgentRuntimeEndpointState)

        __props__.__dict__["agent_runtime_arn"] = agent_runtime_arn
        __props__.__dict__["agent_runtime_endpoint_arn"] = agent_runtime_endpoint_arn
        __props__.__dict__["agent_runtime_id"] = agent_runtime_id
        __props__.__dict__["agent_runtime_version"] = agent_runtime_version
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return AgentcoreAgentRuntimeEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentRuntimeArn")
    def agent_runtime_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the associated Agent Runtime.
        """
        return pulumi.get(self, "agent_runtime_arn")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeEndpointArn")
    def agent_runtime_endpoint_arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "agent_runtime_endpoint_arn")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeId")
    def agent_runtime_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the agent runtime this endpoint belongs to.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_runtime_id")

    @_builtins.property
    @pulumi.getter(name="agentRuntimeVersion")
    def agent_runtime_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the agent runtime to use for this endpoint.
        """
        return pulumi.get(self, "agent_runtime_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the agent runtime endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the agent runtime endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreAgentRuntimeEndpointTimeouts']]:
        return pulumi.get(self, "timeouts")

