# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreApiKeyCredentialProviderArgs', 'AgentcoreApiKeyCredentialProvider']

@pulumi.input_type
class AgentcoreApiKeyCredentialProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AgentcoreApiKeyCredentialProvider resource.
        :param pulumi.Input[_builtins.str] api_key: API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.
               
               **Write-Only API Key (choose one approach):**
        :param pulumi.Input[_builtins.str] api_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        :param pulumi.Input[_builtins.int] api_key_wo_version: Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        :param pulumi.Input[_builtins.str] name: Name of the API Key credential provider. Forces replacement when changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               
               **Standard API Key (choose one approach):**
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_key_wo is not None:
            pulumi.set(__self__, "api_key_wo", api_key_wo)
        if api_key_wo_version is not None:
            pulumi.set(__self__, "api_key_wo_version", api_key_wo_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.

        **Write-Only API Key (choose one approach):**
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyWo")
    def api_key_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        """
        return pulumi.get(self, "api_key_wo")

    @api_key_wo.setter
    def api_key_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key_wo", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyWoVersion")
    def api_key_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        """
        return pulumi.get(self, "api_key_wo_version")

    @api_key_wo_version.setter
    def api_key_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "api_key_wo_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the API Key credential provider. Forces replacement when changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.

        **Standard API Key (choose one approach):**
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AgentcoreApiKeyCredentialProviderState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_secret_arns: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs']]]] = None,
                 api_key_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 credential_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentcoreApiKeyCredentialProvider resources.
        :param pulumi.Input[_builtins.str] api_key: API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.
               
               **Write-Only API Key (choose one approach):**
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs']]] api_key_secret_arns: ARN of the AWS Secrets Manager secret containing the API key.
        :param pulumi.Input[_builtins.str] api_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        :param pulumi.Input[_builtins.int] api_key_wo_version: Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        :param pulumi.Input[_builtins.str] credential_provider_arn: ARN of the API Key credential provider.
        :param pulumi.Input[_builtins.str] name: Name of the API Key credential provider. Forces replacement when changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               
               **Standard API Key (choose one approach):**
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_key_secret_arns is not None:
            pulumi.set(__self__, "api_key_secret_arns", api_key_secret_arns)
        if api_key_wo is not None:
            pulumi.set(__self__, "api_key_wo", api_key_wo)
        if api_key_wo_version is not None:
            pulumi.set(__self__, "api_key_wo_version", api_key_wo_version)
        if credential_provider_arn is not None:
            pulumi.set(__self__, "credential_provider_arn", credential_provider_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.

        **Write-Only API Key (choose one approach):**
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiKeySecretArns")
    def api_key_secret_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs']]]]:
        """
        ARN of the AWS Secrets Manager secret containing the API key.
        """
        return pulumi.get(self, "api_key_secret_arns")

    @api_key_secret_arns.setter
    def api_key_secret_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs']]]]):
        pulumi.set(self, "api_key_secret_arns", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyWo")
    def api_key_wo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        """
        return pulumi.get(self, "api_key_wo")

    @api_key_wo.setter
    def api_key_wo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key_wo", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyWoVersion")
    def api_key_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        """
        return pulumi.get(self, "api_key_wo_version")

    @api_key_wo_version.setter
    def api_key_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "api_key_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="credentialProviderArn")
    def credential_provider_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the API Key credential provider.
        """
        return pulumi.get(self, "credential_provider_arn")

    @credential_provider_arn.setter
    def credential_provider_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_provider_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the API Key credential provider. Forces replacement when changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.

        **Standard API Key (choose one approach):**
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:bedrock/agentcoreApiKeyCredentialProvider:AgentcoreApiKeyCredentialProvider")
class AgentcoreApiKeyCredentialProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreApiKeyCredentialProvider("example",
            name="example-api-key-provider",
            api_key="your-api-key-here")
        ```

        ### Write-Only API Key (Recommended for Production)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreApiKeyCredentialProvider("example",
            name="example-api-key-provider",
            api_key_wo="your-api-key-here",
            api_key_wo_version=1)
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore API Key Credential Provider using the provider name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreApiKeyCredentialProvider:AgentcoreApiKeyCredentialProvider example example-api-key-provider
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.
               
               **Write-Only API Key (choose one approach):**
        :param pulumi.Input[_builtins.str] api_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        :param pulumi.Input[_builtins.int] api_key_wo_version: Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        :param pulumi.Input[_builtins.str] name: Name of the API Key credential provider. Forces replacement when changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               
               **Standard API Key (choose one approach):**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentcoreApiKeyCredentialProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreApiKeyCredentialProvider("example",
            name="example-api-key-provider",
            api_key="your-api-key-here")
        ```

        ### Write-Only API Key (Recommended for Production)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreApiKeyCredentialProvider("example",
            name="example-api-key-provider",
            api_key_wo="your-api-key-here",
            api_key_wo_version=1)
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore API Key Credential Provider using the provider name. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreApiKeyCredentialProvider:AgentcoreApiKeyCredentialProvider example example-api-key-provider
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreApiKeyCredentialProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreApiKeyCredentialProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreApiKeyCredentialProviderArgs.__new__(AgentcoreApiKeyCredentialProviderArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["api_key_wo"] = None if api_key_wo is None else pulumi.Output.secret(api_key_wo)
            __props__.__dict__["api_key_wo_version"] = api_key_wo_version
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["api_key_secret_arns"] = None
            __props__.__dict__["credential_provider_arn"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "apiKeyWo"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AgentcoreApiKeyCredentialProvider, __self__).__init__(
            'aws:bedrock/agentcoreApiKeyCredentialProvider:AgentcoreApiKeyCredentialProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            api_key_secret_arns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs', 'AgentcoreApiKeyCredentialProviderApiKeySecretArnArgsDict']]]]] = None,
            api_key_wo: Optional[pulumi.Input[_builtins.str]] = None,
            api_key_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            credential_provider_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentcoreApiKeyCredentialProvider':
        """
        Get an existing AgentcoreApiKeyCredentialProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.
               
               **Write-Only API Key (choose one approach):**
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreApiKeyCredentialProviderApiKeySecretArnArgs', 'AgentcoreApiKeyCredentialProviderApiKeySecretArnArgsDict']]]] api_key_secret_arns: ARN of the AWS Secrets Manager secret containing the API key.
        :param pulumi.Input[_builtins.str] api_key_wo: **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
               Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        :param pulumi.Input[_builtins.int] api_key_wo_version: Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        :param pulumi.Input[_builtins.str] credential_provider_arn: ARN of the API Key credential provider.
        :param pulumi.Input[_builtins.str] name: Name of the API Key credential provider. Forces replacement when changed.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               
               **Standard API Key (choose one approach):**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreApiKeyCredentialProviderState.__new__(_AgentcoreApiKeyCredentialProviderState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["api_key_secret_arns"] = api_key_secret_arns
        __props__.__dict__["api_key_wo"] = api_key_wo
        __props__.__dict__["api_key_wo_version"] = api_key_wo_version
        __props__.__dict__["credential_provider_arn"] = credential_provider_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return AgentcoreApiKeyCredentialProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key value. Cannot be used with `api_key_wo`. This value will be visible in pulumi preview outputs and logs.

        **Write-Only API Key (choose one approach):**
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiKeySecretArns")
    def api_key_secret_arns(self) -> pulumi.Output[Sequence['outputs.AgentcoreApiKeyCredentialProviderApiKeySecretArn']]:
        """
        ARN of the AWS Secrets Manager secret containing the API key.
        """
        return pulumi.get(self, "api_key_secret_arns")

    @_builtins.property
    @pulumi.getter(name="apiKeyWo")
    def api_key_wo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        **NOTE:** This field is write-only and its value will not be updated in state as part of read operations.
        Write-only API key value. Cannot be used with `api_key`. Must be used together with `api_key_wo_version`.
        """
        return pulumi.get(self, "api_key_wo")

    @_builtins.property
    @pulumi.getter(name="apiKeyWoVersion")
    def api_key_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Used together with `api_key_wo` to trigger an update. Increment this value when an update to `api_key_wo` is required.
        """
        return pulumi.get(self, "api_key_wo_version")

    @_builtins.property
    @pulumi.getter(name="credentialProviderArn")
    def credential_provider_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the API Key credential provider.
        """
        return pulumi.get(self, "credential_provider_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the API Key credential provider. Forces replacement when changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.

        **Standard API Key (choose one approach):**
        """
        return pulumi.get(self, "region")

