# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreBrowserArgs', 'AgentcoreBrowser']

@pulumi.input_type
class AgentcoreBrowserArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']] = None,
                 recording: Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreBrowser resource.
        :param pulumi.Input[_builtins.str] description: Description of the browser.
        :param pulumi.Input[_builtins.str] execution_role_arn: ARN of the IAM role that the browser assumes for execution.
        :param pulumi.Input[_builtins.str] name: Name of the browser.
        :param pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs'] network_configuration: Network configuration for the browser. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input['AgentcoreBrowserRecordingArgs'] recording: Recording configuration for browser sessions. See `recording` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the browser.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that the browser assumes for execution.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the browser.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']]:
        """
        Network configuration for the browser. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']]:
        """
        Recording configuration for browser sessions. See `recording` below.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']]):
        pulumi.set(self, "recording", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreBrowserState:
    def __init__(__self__, *,
                 browser_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 browser_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']] = None,
                 recording: Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentcoreBrowser resources.
        :param pulumi.Input[_builtins.str] browser_arn: ARN of the Browser.
        :param pulumi.Input[_builtins.str] browser_id: Unique identifier of the Browser.
        :param pulumi.Input[_builtins.str] description: Description of the browser.
        :param pulumi.Input[_builtins.str] execution_role_arn: ARN of the IAM role that the browser assumes for execution.
        :param pulumi.Input[_builtins.str] name: Name of the browser.
        :param pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs'] network_configuration: Network configuration for the browser. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input['AgentcoreBrowserRecordingArgs'] recording: Recording configuration for browser sessions. See `recording` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if browser_arn is not None:
            pulumi.set(__self__, "browser_arn", browser_arn)
        if browser_id is not None:
            pulumi.set(__self__, "browser_id", browser_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="browserArn")
    def browser_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Browser.
        """
        return pulumi.get(self, "browser_arn")

    @browser_arn.setter
    def browser_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_arn", value)

    @_builtins.property
    @pulumi.getter(name="browserId")
    def browser_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Browser.
        """
        return pulumi.get(self, "browser_id")

    @browser_id.setter
    def browser_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "browser_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the browser.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that the browser assumes for execution.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the browser.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']]:
        """
        Network configuration for the browser. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['AgentcoreBrowserNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']]:
        """
        Recording configuration for browser sessions. See `recording` below.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input['AgentcoreBrowserRecordingArgs']]):
        pulumi.set(self, "recording", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreBrowserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentcoreBrowser:AgentcoreBrowser")
class AgentcoreBrowser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['AgentcoreBrowserNetworkConfigurationArgs', 'AgentcoreBrowserNetworkConfigurationArgsDict']]] = None,
                 recording: Optional[pulumi.Input[Union['AgentcoreBrowserRecordingArgs', 'AgentcoreBrowserRecordingArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreBrowserTimeoutsArgs', 'AgentcoreBrowserTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Browser. Browser provides AI agents with web browsing capabilities, allowing them to navigate websites, extract information, and interact with web content in a controlled environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreBrowser("example",
            name="example-browser",
            description="Browser for web data extraction",
            network_configuration={
                "network_mode": "PUBLIC",
            })
        ```

        ### Browser with Execution Role and Recording

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-browser-role",
            assume_role_policy=assume_role.json)
        recording = aws.s3.Bucket("recording", bucket="browser-recording-bucket")
        example_agentcore_browser = aws.bedrock.AgentcoreBrowser("example",
            name="example-browser",
            description="Browser with recording enabled",
            execution_role_arn=example.arn,
            network_configuration={
                "network_mode": "PUBLIC",
            },
            recording={
                "enabled": True,
                "s3_location": {
                    "bucket": recording.bucket,
                    "prefix": "browser-sessions/",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Browser using the browser ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreBrowser:AgentcoreBrowser example BROWSER1234567890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the browser.
        :param pulumi.Input[_builtins.str] execution_role_arn: ARN of the IAM role that the browser assumes for execution.
        :param pulumi.Input[_builtins.str] name: Name of the browser.
        :param pulumi.Input[Union['AgentcoreBrowserNetworkConfigurationArgs', 'AgentcoreBrowserNetworkConfigurationArgsDict']] network_configuration: Network configuration for the browser. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[Union['AgentcoreBrowserRecordingArgs', 'AgentcoreBrowserRecordingArgsDict']] recording: Recording configuration for browser sessions. See `recording` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentcoreBrowserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Browser. Browser provides AI agents with web browsing capabilities, allowing them to navigate websites, extract information, and interact with web content in a controlled environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreBrowser("example",
            name="example-browser",
            description="Browser for web data extraction",
            network_configuration={
                "network_mode": "PUBLIC",
            })
        ```

        ### Browser with Execution Role and Recording

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-browser-role",
            assume_role_policy=assume_role.json)
        recording = aws.s3.Bucket("recording", bucket="browser-recording-bucket")
        example_agentcore_browser = aws.bedrock.AgentcoreBrowser("example",
            name="example-browser",
            description="Browser with recording enabled",
            execution_role_arn=example.arn,
            network_configuration={
                "network_mode": "PUBLIC",
            },
            recording={
                "enabled": True,
                "s3_location": {
                    "bucket": recording.bucket,
                    "prefix": "browser-sessions/",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Browser using the browser ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreBrowser:AgentcoreBrowser example BROWSER1234567890
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreBrowserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreBrowserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['AgentcoreBrowserNetworkConfigurationArgs', 'AgentcoreBrowserNetworkConfigurationArgsDict']]] = None,
                 recording: Optional[pulumi.Input[Union['AgentcoreBrowserRecordingArgs', 'AgentcoreBrowserRecordingArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreBrowserTimeoutsArgs', 'AgentcoreBrowserTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreBrowserArgs.__new__(AgentcoreBrowserArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["recording"] = recording
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["browser_arn"] = None
            __props__.__dict__["browser_id"] = None
            __props__.__dict__["tags_all"] = None
        super(AgentcoreBrowser, __self__).__init__(
            'aws:bedrock/agentcoreBrowser:AgentcoreBrowser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            browser_arn: Optional[pulumi.Input[_builtins.str]] = None,
            browser_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_configuration: Optional[pulumi.Input[Union['AgentcoreBrowserNetworkConfigurationArgs', 'AgentcoreBrowserNetworkConfigurationArgsDict']]] = None,
            recording: Optional[pulumi.Input[Union['AgentcoreBrowserRecordingArgs', 'AgentcoreBrowserRecordingArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreBrowserTimeoutsArgs', 'AgentcoreBrowserTimeoutsArgsDict']]] = None) -> 'AgentcoreBrowser':
        """
        Get an existing AgentcoreBrowser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] browser_arn: ARN of the Browser.
        :param pulumi.Input[_builtins.str] browser_id: Unique identifier of the Browser.
        :param pulumi.Input[_builtins.str] description: Description of the browser.
        :param pulumi.Input[_builtins.str] execution_role_arn: ARN of the IAM role that the browser assumes for execution.
        :param pulumi.Input[_builtins.str] name: Name of the browser.
        :param pulumi.Input[Union['AgentcoreBrowserNetworkConfigurationArgs', 'AgentcoreBrowserNetworkConfigurationArgsDict']] network_configuration: Network configuration for the browser. See `network_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[Union['AgentcoreBrowserRecordingArgs', 'AgentcoreBrowserRecordingArgsDict']] recording: Recording configuration for browser sessions. See `recording` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreBrowserState.__new__(_AgentcoreBrowserState)

        __props__.__dict__["browser_arn"] = browser_arn
        __props__.__dict__["browser_id"] = browser_id
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_role_arn"] = execution_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["recording"] = recording
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return AgentcoreBrowser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="browserArn")
    def browser_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Browser.
        """
        return pulumi.get(self, "browser_arn")

    @_builtins.property
    @pulumi.getter(name="browserId")
    def browser_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the Browser.
        """
        return pulumi.get(self, "browser_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the browser.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the IAM role that the browser assumes for execution.
        """
        return pulumi.get(self, "execution_role_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the browser.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreBrowserNetworkConfiguration']]:
        """
        Network configuration for the browser. See `network_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter
    def recording(self) -> pulumi.Output[Optional['outputs.AgentcoreBrowserRecording']]:
        """
        Recording configuration for browser sessions. See `recording` below.
        """
        return pulumi.get(self, "recording")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreBrowserTimeouts']]:
        return pulumi.get(self, "timeouts")

