# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreGatewayArgs', 'AgentcoreGateway']

@pulumi.input_type
class AgentcoreGatewayArgs:
    def __init__(__self__, *,
                 authorizer_type: pulumi.Input[_builtins.str],
                 protocol_type: pulumi.Input[_builtins.str],
                 role_arn: pulumi.Input[_builtins.str],
                 authorizer_configuration: Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_level: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_configuration: Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreGateway resource.
        :param pulumi.Input[_builtins.str] authorizer_type: Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type for the gateway. Valid values: `MCP`.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the gateway assumes to access AWS services.
               
               The following arguments are optional:
        :param pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs'] authorizer_configuration: Configuration for request authorization. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the gateway.
        :param pulumi.Input[_builtins.str] exception_level: Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the KMS key used to encrypt the gateway data.
        :param pulumi.Input[_builtins.str] name: Name of the gateway.
        :param pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs'] protocol_configuration: Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "authorizer_type", authorizer_type)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "role_arn", role_arn)
        if authorizer_configuration is not None:
            pulumi.set(__self__, "authorizer_configuration", authorizer_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exception_level is not None:
            pulumi.set(__self__, "exception_level", exception_level)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_configuration is not None:
            pulumi.set(__self__, "protocol_configuration", protocol_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="authorizerType")
    def authorizer_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        """
        return pulumi.get(self, "authorizer_type")

    @authorizer_type.setter
    def authorizer_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorizer_type", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol type for the gateway. Valid values: `MCP`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the IAM role that the gateway assumes to access AWS services.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']]:
        """
        Configuration for request authorization. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @authorizer_configuration.setter
    def authorizer_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']]):
        pulumi.set(self, "authorizer_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exceptionLevel")
    def exception_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        """
        return pulumi.get(self, "exception_level")

    @exception_level.setter
    def exception_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exception_level", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the KMS key used to encrypt the gateway data.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']]:
        """
        Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @protocol_configuration.setter
    def protocol_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']]):
        pulumi.set(self, "protocol_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreGatewayState:
    def __init__(__self__, *,
                 authorizer_configuration: Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']] = None,
                 authorizer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_level: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_url: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_configuration: Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']] = None,
                 workload_identity_details: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreGatewayWorkloadIdentityDetailArgs']]]] = None):
        """
        Input properties used for looking up and filtering AgentcoreGateway resources.
        :param pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs'] authorizer_configuration: Configuration for request authorization. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] authorizer_type: Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        :param pulumi.Input[_builtins.str] description: Description of the gateway.
        :param pulumi.Input[_builtins.str] exception_level: Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        :param pulumi.Input[_builtins.str] gateway_arn: ARN of the Gateway.
        :param pulumi.Input[_builtins.str] gateway_id: Unique identifier of the Gateway.
        :param pulumi.Input[_builtins.str] gateway_url: URL endpoint for the gateway.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the KMS key used to encrypt the gateway data.
        :param pulumi.Input[_builtins.str] name: Name of the gateway.
        :param pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs'] protocol_configuration: Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type for the gateway. Valid values: `MCP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the gateway assumes to access AWS services.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['AgentcoreGatewayWorkloadIdentityDetailArgs']]] workload_identity_details: Workload identity details for the gateway. See `workload_identity_details` below.
        """
        if authorizer_configuration is not None:
            pulumi.set(__self__, "authorizer_configuration", authorizer_configuration)
        if authorizer_type is not None:
            pulumi.set(__self__, "authorizer_type", authorizer_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exception_level is not None:
            pulumi.set(__self__, "exception_level", exception_level)
        if gateway_arn is not None:
            pulumi.set(__self__, "gateway_arn", gateway_arn)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if gateway_url is not None:
            pulumi.set(__self__, "gateway_url", gateway_url)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_configuration is not None:
            pulumi.set(__self__, "protocol_configuration", protocol_configuration)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if workload_identity_details is not None:
            pulumi.set(__self__, "workload_identity_details", workload_identity_details)

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']]:
        """
        Configuration for request authorization. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @authorizer_configuration.setter
    def authorizer_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayAuthorizerConfigurationArgs']]):
        pulumi.set(self, "authorizer_configuration", value)

    @_builtins.property
    @pulumi.getter(name="authorizerType")
    def authorizer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        """
        return pulumi.get(self, "authorizer_type")

    @authorizer_type.setter
    def authorizer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorizer_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exceptionLevel")
    def exception_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        """
        return pulumi.get(self, "exception_level")

    @exception_level.setter
    def exception_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exception_level", value)

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @gateway_arn.setter
    def gateway_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_arn", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL endpoint for the gateway.
        """
        return pulumi.get(self, "gateway_url")

    @gateway_url.setter
    def gateway_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_url", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the KMS key used to encrypt the gateway data.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']]:
        """
        Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @protocol_configuration.setter
    def protocol_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayProtocolConfigurationArgs']]):
        pulumi.set(self, "protocol_configuration", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol type for the gateway. Valid values: `MCP`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role that the gateway assumes to access AWS services.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreGatewayTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityDetails")
    def workload_identity_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreGatewayWorkloadIdentityDetailArgs']]]]:
        """
        Workload identity details for the gateway. See `workload_identity_details` below.
        """
        return pulumi.get(self, "workload_identity_details")

    @workload_identity_details.setter
    def workload_identity_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentcoreGatewayWorkloadIdentityDetailArgs']]]]):
        pulumi.set(self, "workload_identity_details", value)


@pulumi.type_token("aws:bedrock/agentcoreGateway:AgentcoreGateway")
class AgentcoreGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayAuthorizerConfigurationArgs', 'AgentcoreGatewayAuthorizerConfigurationArgsDict']]] = None,
                 authorizer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_level: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayProtocolConfigurationArgs', 'AgentcoreGatewayProtocolConfigurationArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTimeoutsArgs', 'AgentcoreGatewayTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Gateway. With Gateway, developers can convert APIs, Lambda functions, and existing services into Model Context Protocol (MCP)-compatible tools.

        ## Example Usage

        ### Gateway with JWT Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-gateway-role",
            assume_role_policy=assume_role.json)
        example_agentcore_gateway = aws.bedrock.AgentcoreGateway("example",
            name="example-gateway",
            role_arn=example.arn,
            authorizer_type="CUSTOM_JWT",
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://accounts.google.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "test1",
                        "test2",
                    ],
                },
            },
            protocol_type="MCP")
        ```

        ### Gateway with advanced JWT Authorization and MCP Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreGateway("example",
            name="mcp-gateway",
            description="Gateway for MCP communication",
            role_arn=example_aws_iam_role["arn"],
            authorizer_type="CUSTOM_JWT",
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://auth.example.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "app-client",
                        "web-client",
                    ],
                    "allowed_clients": [
                        "client-123",
                        "client-456",
                    ],
                },
            },
            protocol_type="MCP",
            protocol_configuration={
                "mcp": {
                    "instructions": "Gateway for handling MCP requests",
                    "search_type": "HYBRID",
                    "supported_versions": [
                        "2025-03-26",
                        "2025-06-18",
                    ],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Gateway using the gateway ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreGateway:AgentcoreGateway example GATEWAY1234567890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreGatewayAuthorizerConfigurationArgs', 'AgentcoreGatewayAuthorizerConfigurationArgsDict']] authorizer_configuration: Configuration for request authorization. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] authorizer_type: Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        :param pulumi.Input[_builtins.str] description: Description of the gateway.
        :param pulumi.Input[_builtins.str] exception_level: Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the KMS key used to encrypt the gateway data.
        :param pulumi.Input[_builtins.str] name: Name of the gateway.
        :param pulumi.Input[Union['AgentcoreGatewayProtocolConfigurationArgs', 'AgentcoreGatewayProtocolConfigurationArgsDict']] protocol_configuration: Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type for the gateway. Valid values: `MCP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the gateway assumes to access AWS services.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Gateway. With Gateway, developers can convert APIs, Lambda functions, and existing services into Model Context Protocol (MCP)-compatible tools.

        ## Example Usage

        ### Gateway with JWT Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["bedrock-agentcore.amazonaws.com"],
            }],
        }])
        example = aws.iam.Role("example",
            name="bedrock-agentcore-gateway-role",
            assume_role_policy=assume_role.json)
        example_agentcore_gateway = aws.bedrock.AgentcoreGateway("example",
            name="example-gateway",
            role_arn=example.arn,
            authorizer_type="CUSTOM_JWT",
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://accounts.google.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "test1",
                        "test2",
                    ],
                },
            },
            protocol_type="MCP")
        ```

        ### Gateway with advanced JWT Authorization and MCP Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentcoreGateway("example",
            name="mcp-gateway",
            description="Gateway for MCP communication",
            role_arn=example_aws_iam_role["arn"],
            authorizer_type="CUSTOM_JWT",
            authorizer_configuration={
                "custom_jwt_authorizer": {
                    "discovery_url": "https://auth.example.com/.well-known/openid-configuration",
                    "allowed_audiences": [
                        "app-client",
                        "web-client",
                    ],
                    "allowed_clients": [
                        "client-123",
                        "client-456",
                    ],
                },
            },
            protocol_type="MCP",
            protocol_configuration={
                "mcp": {
                    "instructions": "Gateway for handling MCP requests",
                    "search_type": "HYBRID",
                    "supported_versions": [
                        "2025-03-26",
                        "2025-06-18",
                    ],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Gateway using the gateway ID. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreGateway:AgentcoreGateway example GATEWAY1234567890
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayAuthorizerConfigurationArgs', 'AgentcoreGatewayAuthorizerConfigurationArgsDict']]] = None,
                 authorizer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_level: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayProtocolConfigurationArgs', 'AgentcoreGatewayProtocolConfigurationArgsDict']]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTimeoutsArgs', 'AgentcoreGatewayTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreGatewayArgs.__new__(AgentcoreGatewayArgs)

            __props__.__dict__["authorizer_configuration"] = authorizer_configuration
            if authorizer_type is None and not opts.urn:
                raise TypeError("Missing required property 'authorizer_type'")
            __props__.__dict__["authorizer_type"] = authorizer_type
            __props__.__dict__["description"] = description
            __props__.__dict__["exception_level"] = exception_level
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["protocol_configuration"] = protocol_configuration
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["gateway_arn"] = None
            __props__.__dict__["gateway_id"] = None
            __props__.__dict__["gateway_url"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["workload_identity_details"] = None
        super(AgentcoreGateway, __self__).__init__(
            'aws:bedrock/agentcoreGateway:AgentcoreGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorizer_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayAuthorizerConfigurationArgs', 'AgentcoreGatewayAuthorizerConfigurationArgsDict']]] = None,
            authorizer_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exception_level: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_url: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayProtocolConfigurationArgs', 'AgentcoreGatewayProtocolConfigurationArgsDict']]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTimeoutsArgs', 'AgentcoreGatewayTimeoutsArgsDict']]] = None,
            workload_identity_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreGatewayWorkloadIdentityDetailArgs', 'AgentcoreGatewayWorkloadIdentityDetailArgsDict']]]]] = None) -> 'AgentcoreGateway':
        """
        Get an existing AgentcoreGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreGatewayAuthorizerConfigurationArgs', 'AgentcoreGatewayAuthorizerConfigurationArgsDict']] authorizer_configuration: Configuration for request authorization. See `authorizer_configuration` below.
        :param pulumi.Input[_builtins.str] authorizer_type: Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        :param pulumi.Input[_builtins.str] description: Description of the gateway.
        :param pulumi.Input[_builtins.str] exception_level: Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        :param pulumi.Input[_builtins.str] gateway_arn: ARN of the Gateway.
        :param pulumi.Input[_builtins.str] gateway_id: Unique identifier of the Gateway.
        :param pulumi.Input[_builtins.str] gateway_url: URL endpoint for the gateway.
        :param pulumi.Input[_builtins.str] kms_key_arn: ARN of the KMS key used to encrypt the gateway data.
        :param pulumi.Input[_builtins.str] name: Name of the gateway.
        :param pulumi.Input[Union['AgentcoreGatewayProtocolConfigurationArgs', 'AgentcoreGatewayProtocolConfigurationArgsDict']] protocol_configuration: Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        :param pulumi.Input[_builtins.str] protocol_type: Protocol type for the gateway. Valid values: `MCP`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the IAM role that the gateway assumes to access AWS services.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentcoreGatewayWorkloadIdentityDetailArgs', 'AgentcoreGatewayWorkloadIdentityDetailArgsDict']]]] workload_identity_details: Workload identity details for the gateway. See `workload_identity_details` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreGatewayState.__new__(_AgentcoreGatewayState)

        __props__.__dict__["authorizer_configuration"] = authorizer_configuration
        __props__.__dict__["authorizer_type"] = authorizer_type
        __props__.__dict__["description"] = description
        __props__.__dict__["exception_level"] = exception_level
        __props__.__dict__["gateway_arn"] = gateway_arn
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["gateway_url"] = gateway_url
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol_configuration"] = protocol_configuration
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["workload_identity_details"] = workload_identity_details
        return AgentcoreGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizerConfiguration")
    def authorizer_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayAuthorizerConfiguration']]:
        """
        Configuration for request authorization. See `authorizer_configuration` below.
        """
        return pulumi.get(self, "authorizer_configuration")

    @_builtins.property
    @pulumi.getter(name="authorizerType")
    def authorizer_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of authorizer to use. Valid values: `CUSTOM_JWT`, `AWS_IAM`.
        """
        return pulumi.get(self, "authorizer_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exceptionLevel")
    def exception_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Exception level for the gateway. Valid values: `INFO`, `WARN`, `ERROR`.
        """
        return pulumi.get(self, "exception_level")

    @_builtins.property
    @pulumi.getter(name="gatewayArn")
    def gateway_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Gateway.
        """
        return pulumi.get(self, "gateway_arn")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL endpoint for the gateway.
        """
        return pulumi.get(self, "gateway_url")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the KMS key used to encrypt the gateway data.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protocolConfiguration")
    def protocol_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayProtocolConfiguration']]:
        """
        Protocol-specific configuration for the gateway. See `protocol_configuration` below.
        """
        return pulumi.get(self, "protocol_configuration")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol type for the gateway. Valid values: `MCP`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role that the gateway assumes to access AWS services.

        The following arguments are optional:
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityDetails")
    def workload_identity_details(self) -> pulumi.Output[Sequence['outputs.AgentcoreGatewayWorkloadIdentityDetail']]:
        """
        Workload identity details for the gateway. See `workload_identity_details` below.
        """
        return pulumi.get(self, "workload_identity_details")

