# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreGatewayTargetArgs', 'AgentcoreGatewayTarget']

@pulumi.input_type
class AgentcoreGatewayTargetArgs:
    def __init__(__self__, *,
                 gateway_identifier: pulumi.Input[_builtins.str],
                 credential_provider_configuration: Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration: Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreGatewayTarget resource.
        :param pulumi.Input[_builtins.str] gateway_identifier: Identifier of the gateway that this target belongs to.
        :param pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs'] credential_provider_configuration: Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the gateway target.
        :param pulumi.Input[_builtins.str] name: Name of the gateway target.
        :param pulumi.Input[_builtins.str] region: AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        :param pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs'] target_configuration: Configuration for the target endpoint. See `target_configuration` below.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "gateway_identifier", gateway_identifier)
        if credential_provider_configuration is not None:
            pulumi.set(__self__, "credential_provider_configuration", credential_provider_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="gatewayIdentifier")
    def gateway_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the gateway that this target belongs to.
        """
        return pulumi.get(self, "gateway_identifier")

    @gateway_identifier.setter
    def gateway_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_identifier", value)

    @_builtins.property
    @pulumi.getter(name="credentialProviderConfiguration")
    def credential_provider_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']]:
        """
        Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        """
        return pulumi.get(self, "credential_provider_configuration")

    @credential_provider_configuration.setter
    def credential_provider_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']]):
        pulumi.set(self, "credential_provider_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the gateway target.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the gateway target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']]:
        """
        Configuration for the target endpoint. See `target_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreGatewayTargetState:
    def __init__(__self__, *,
                 credential_provider_configuration: Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration: Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentcoreGatewayTarget resources.
        :param pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs'] credential_provider_configuration: Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the gateway target.
        :param pulumi.Input[_builtins.str] gateway_identifier: Identifier of the gateway that this target belongs to.
        :param pulumi.Input[_builtins.str] name: Name of the gateway target.
        :param pulumi.Input[_builtins.str] region: AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        :param pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs'] target_configuration: Configuration for the target endpoint. See `target_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] target_id: Unique identifier of the gateway target.
        """
        if credential_provider_configuration is not None:
            pulumi.set(__self__, "credential_provider_configuration", credential_provider_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateway_identifier is not None:
            pulumi.set(__self__, "gateway_identifier", gateway_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="credentialProviderConfiguration")
    def credential_provider_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']]:
        """
        Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        """
        return pulumi.get(self, "credential_provider_configuration")

    @credential_provider_configuration.setter
    def credential_provider_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetCredentialProviderConfigurationArgs']]):
        pulumi.set(self, "credential_provider_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the gateway target.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIdentifier")
    def gateway_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the gateway that this target belongs to.
        """
        return pulumi.get(self, "gateway_identifier")

    @gateway_identifier.setter
    def gateway_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the gateway target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']]:
        """
        Configuration for the target endpoint. See `target_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the gateway target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreGatewayTargetTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentcoreGatewayTarget:AgentcoreGatewayTarget")
class AgentcoreGatewayTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_provider_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetCredentialProviderConfigurationArgs', 'AgentcoreGatewayTargetCredentialProviderConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTargetConfigurationArgs', 'AgentcoreGatewayTargetTargetConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTimeoutsArgs', 'AgentcoreGatewayTargetTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Gateway Target. Gateway targets define the endpoints and configurations that a gateway can invoke, such as Lambda functions or APIs, allowing agents to interact with external services through the Model Context Protocol (MCP).

        ## Example Usage

        ### Lambda Target with Gateway IAM Role

        ### Target with API Key Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        api_key_example = aws.bedrock.AgentcoreGatewayTarget("api_key_example",
            name="api-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            description="External API target with API key authentication",
            credential_provider_configuration={
                "api_key": {
                    "provider_arn": "arn:aws:iam::123456789012:oidc-provider/example.com",
                    "credential_location": "HEADER",
                    "credential_parameter_name": "X-API-Key",
                    "credential_prefix": "Bearer",
                },
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "api_tool",
                                "description": "External API integration tool",
                                "input_schema": {
                                    "type": "string",
                                    "description": "Simple string input for API calls",
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ### Target with OAuth Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        oauth_example = aws.bedrock.AgentcoreGatewayTarget("oauth_example",
            name="oauth-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            credential_provider_configuration={
                "oauth": {
                    "provider_arn": "arn:aws:iam::123456789012:oidc-provider/oauth.example.com",
                    "scopes": [
                        "read",
                        "write",
                    ],
                    "custom_parameters": {
                        "client_type": "confidential",
                        "grant_type": "authorization_code",
                    },
                },
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "oauth_tool",
                                "description": "OAuth-authenticated service",
                                "input_schema": {
                                    "type": "array",
                                    "items": {
                                        "type": "object",
                                        "properties": [
                                            {
                                                "name": "id",
                                                "type": "string",
                                                "required": True,
                                            },
                                            {
                                                "name": "value",
                                                "type": "number",
                                            },
                                        ],
                                    },
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ### Complex Schema with JSON Serialization

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        complex_schema = aws.bedrock.AgentcoreGatewayTarget("complex_schema",
            name="complex-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            credential_provider_configuration={
                "gateway_iam_role": {},
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "complex_tool",
                                "description": "Tool with complex nested schema",
                                "input_schema": {
                                    "type": "object",
                                    "properties": [{
                                        "name": "profile",
                                        "type": "object",
                                        "properties": [
                                            {
                                                "name": "nested_tags",
                                                "type": "array",
                                                "items_json": json.dumps({
                                                    "type": "string",
                                                }),
                                            },
                                            {
                                                "name": "metadata",
                                                "type": "object",
                                                "properties_json": json.dumps({
                                                    "properties": {
                                                        "created_at": {
                                                            "type": "string",
                                                        },
                                                        "version": {
                                                            "type": "number",
                                                        },
                                                    },
                                                    "required": ["created_at"],
                                                }),
                                            },
                                        ],
                                    }],
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Gateway Target using the gateway identifier and target ID separated by a comma. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreGatewayTarget:AgentcoreGatewayTarget example GATEWAY1234567890,TARGET0987654321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreGatewayTargetCredentialProviderConfigurationArgs', 'AgentcoreGatewayTargetCredentialProviderConfigurationArgsDict']] credential_provider_configuration: Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the gateway target.
        :param pulumi.Input[_builtins.str] gateway_identifier: Identifier of the gateway that this target belongs to.
        :param pulumi.Input[_builtins.str] name: Name of the gateway target.
        :param pulumi.Input[_builtins.str] region: AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        :param pulumi.Input[Union['AgentcoreGatewayTargetTargetConfigurationArgs', 'AgentcoreGatewayTargetTargetConfigurationArgsDict']] target_configuration: Configuration for the target endpoint. See `target_configuration` below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreGatewayTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Gateway Target. Gateway targets define the endpoints and configurations that a gateway can invoke, such as Lambda functions or APIs, allowing agents to interact with external services through the Model Context Protocol (MCP).

        ## Example Usage

        ### Lambda Target with Gateway IAM Role

        ### Target with API Key Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        api_key_example = aws.bedrock.AgentcoreGatewayTarget("api_key_example",
            name="api-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            description="External API target with API key authentication",
            credential_provider_configuration={
                "api_key": {
                    "provider_arn": "arn:aws:iam::123456789012:oidc-provider/example.com",
                    "credential_location": "HEADER",
                    "credential_parameter_name": "X-API-Key",
                    "credential_prefix": "Bearer",
                },
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "api_tool",
                                "description": "External API integration tool",
                                "input_schema": {
                                    "type": "string",
                                    "description": "Simple string input for API calls",
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ### Target with OAuth Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        oauth_example = aws.bedrock.AgentcoreGatewayTarget("oauth_example",
            name="oauth-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            credential_provider_configuration={
                "oauth": {
                    "provider_arn": "arn:aws:iam::123456789012:oidc-provider/oauth.example.com",
                    "scopes": [
                        "read",
                        "write",
                    ],
                    "custom_parameters": {
                        "client_type": "confidential",
                        "grant_type": "authorization_code",
                    },
                },
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "oauth_tool",
                                "description": "OAuth-authenticated service",
                                "input_schema": {
                                    "type": "array",
                                    "items": {
                                        "type": "object",
                                        "properties": [
                                            {
                                                "name": "id",
                                                "type": "string",
                                                "required": True,
                                            },
                                            {
                                                "name": "value",
                                                "type": "number",
                                            },
                                        ],
                                    },
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ### Complex Schema with JSON Serialization

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        complex_schema = aws.bedrock.AgentcoreGatewayTarget("complex_schema",
            name="complex-target",
            gateway_identifier=example_aws_bedrockagentcore_gateway["gatewayId"],
            credential_provider_configuration={
                "gateway_iam_role": {},
            },
            target_configuration={
                "mcp": {
                    "lambda_": {
                        "lambda_arn": example["arn"],
                        "tool_schema": {
                            "inline_payloads": [{
                                "name": "complex_tool",
                                "description": "Tool with complex nested schema",
                                "input_schema": {
                                    "type": "object",
                                    "properties": [{
                                        "name": "profile",
                                        "type": "object",
                                        "properties": [
                                            {
                                                "name": "nested_tags",
                                                "type": "array",
                                                "items_json": json.dumps({
                                                    "type": "string",
                                                }),
                                            },
                                            {
                                                "name": "metadata",
                                                "type": "object",
                                                "properties_json": json.dumps({
                                                    "properties": {
                                                        "created_at": {
                                                            "type": "string",
                                                        },
                                                        "version": {
                                                            "type": "number",
                                                        },
                                                    },
                                                    "required": ["created_at"],
                                                }),
                                            },
                                        ],
                                    }],
                                },
                            }],
                        },
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Gateway Target using the gateway identifier and target ID separated by a comma. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreGatewayTarget:AgentcoreGatewayTarget example GATEWAY1234567890,TARGET0987654321
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreGatewayTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreGatewayTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_provider_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetCredentialProviderConfigurationArgs', 'AgentcoreGatewayTargetCredentialProviderConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTargetConfigurationArgs', 'AgentcoreGatewayTargetTargetConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTimeoutsArgs', 'AgentcoreGatewayTargetTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreGatewayTargetArgs.__new__(AgentcoreGatewayTargetArgs)

            __props__.__dict__["credential_provider_configuration"] = credential_provider_configuration
            __props__.__dict__["description"] = description
            if gateway_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_identifier'")
            __props__.__dict__["gateway_identifier"] = gateway_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["target_configuration"] = target_configuration
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["target_id"] = None
        super(AgentcoreGatewayTarget, __self__).__init__(
            'aws:bedrock/agentcoreGatewayTarget:AgentcoreGatewayTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_provider_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetCredentialProviderConfigurationArgs', 'AgentcoreGatewayTargetCredentialProviderConfigurationArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_configuration: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTargetConfigurationArgs', 'AgentcoreGatewayTargetTargetConfigurationArgsDict']]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreGatewayTargetTimeoutsArgs', 'AgentcoreGatewayTargetTimeoutsArgsDict']]] = None) -> 'AgentcoreGatewayTarget':
        """
        Get an existing AgentcoreGatewayTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreGatewayTargetCredentialProviderConfigurationArgs', 'AgentcoreGatewayTargetCredentialProviderConfigurationArgsDict']] credential_provider_configuration: Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the gateway target.
        :param pulumi.Input[_builtins.str] gateway_identifier: Identifier of the gateway that this target belongs to.
        :param pulumi.Input[_builtins.str] name: Name of the gateway target.
        :param pulumi.Input[_builtins.str] region: AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        :param pulumi.Input[Union['AgentcoreGatewayTargetTargetConfigurationArgs', 'AgentcoreGatewayTargetTargetConfigurationArgsDict']] target_configuration: Configuration for the target endpoint. See `target_configuration` below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] target_id: Unique identifier of the gateway target.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreGatewayTargetState.__new__(_AgentcoreGatewayTargetState)

        __props__.__dict__["credential_provider_configuration"] = credential_provider_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["gateway_identifier"] = gateway_identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["target_configuration"] = target_configuration
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["timeouts"] = timeouts
        return AgentcoreGatewayTarget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialProviderConfiguration")
    def credential_provider_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayTargetCredentialProviderConfiguration']]:
        """
        Configuration for authenticating requests to the target. See `credential_provider_configuration` below.
        """
        return pulumi.get(self, "credential_provider_configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the gateway target.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gatewayIdentifier")
    def gateway_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the gateway that this target belongs to.
        """
        return pulumi.get(self, "gateway_identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the gateway target.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        AWS region where the resource will be created. If not provided, the region from the provider configuration will be used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayTargetTargetConfiguration']]:
        """
        Configuration for the target endpoint. See `target_configuration` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_configuration")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the gateway target.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreGatewayTargetTimeouts']]:
        return pulumi.get(self, "timeouts")

