# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentcoreMemoryStrategyArgs', 'AgentcoreMemoryStrategy']

@pulumi.input_type
class AgentcoreMemoryStrategyArgs:
    def __init__(__self__, *,
                 memory_id: pulumi.Input[_builtins.str],
                 namespaces: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentcoreMemoryStrategy resource.
        :param pulumi.Input[_builtins.str] memory_id: ID of the memory to associate with this strategy. Changing this forces a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] namespaces: Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] type: Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        :param pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs'] configuration: Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the memory strategy.
        :param pulumi.Input[_builtins.str] name: Name of the memory strategy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "memory_id", memory_id)
        pulumi.set(__self__, "namespaces", namespaces)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if memory_execution_role_arn is not None:
            pulumi.set(__self__, "memory_execution_role_arn", memory_execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="memoryId")
    def memory_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the memory to associate with this strategy. Changing this forces a new resource.
        """
        return pulumi.get(self, "memory_id")

    @memory_id.setter
    def memory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "memory_id", value)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.

        The following arguments are optional:
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "namespaces", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']]:
        """
        Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the memory strategy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="memoryExecutionRoleArn")
    def memory_execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "memory_execution_role_arn")

    @memory_execution_role_arn.setter
    def memory_execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the memory strategy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentcoreMemoryStrategyState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentcoreMemoryStrategy resources.
        :param pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs'] configuration: Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the memory strategy.
        :param pulumi.Input[_builtins.str] memory_id: ID of the memory to associate with this strategy. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] name: Name of the memory strategy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] namespaces: Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] type: Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if memory_execution_role_arn is not None:
            pulumi.set(__self__, "memory_execution_role_arn", memory_execution_role_arn)
        if memory_id is not None:
            pulumi.set(__self__, "memory_id", memory_id)
        if memory_strategy_id is not None:
            pulumi.set(__self__, "memory_strategy_id", memory_strategy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']]:
        """
        Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AgentcoreMemoryStrategyConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the memory strategy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="memoryExecutionRoleArn")
    def memory_execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "memory_execution_role_arn")

    @memory_execution_role_arn.setter
    def memory_execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="memoryId")
    def memory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the memory to associate with this strategy. Changing this forces a new resource.
        """
        return pulumi.get(self, "memory_id")

    @memory_id.setter
    def memory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_id", value)

    @_builtins.property
    @pulumi.getter(name="memoryStrategyId")
    def memory_strategy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "memory_strategy_id")

    @memory_strategy_id.setter
    def memory_strategy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_strategy_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the memory strategy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.

        The following arguments are optional:
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "namespaces", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentcoreMemoryStrategyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:bedrock/agentcoreMemoryStrategy:AgentcoreMemoryStrategy")
class AgentcoreMemoryStrategy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyConfigurationArgs', 'AgentcoreMemoryStrategyConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyTimeoutsArgs', 'AgentcoreMemoryStrategyTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Bedrock AgentCore Memory Strategy. Memory strategies define how the agent processes and organizes information within a memory, such as semantic understanding, summarization, or custom processing logic.

        **Important Limitations:**

        - Each memory can have a maximum of 6 strategies total
        - Only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory
        - Multiple `CUSTOM` strategies are allowed (subject to the total limit of 6)

        ## Example Usage

        ### Semantic Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        semantic = aws.bedrock.AgentcoreMemoryStrategy("semantic",
            name="semantic-strategy",
            memory_id=example["id"],
            type="SEMANTIC",
            description="Semantic understanding strategy",
            namespaces=["default"])
        ```

        ### Summarization Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        summary = aws.bedrock.AgentcoreMemoryStrategy("summary",
            name="summary-strategy",
            memory_id=example["id"],
            type="SUMMARIZATION",
            description="Text summarization strategy",
            namespaces=["{sessionId}"])
        ```

        ### User Preference Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        user_pref = aws.bedrock.AgentcoreMemoryStrategy("user_pref",
            name="user-preference-strategy",
            memory_id=example["id"],
            type="USER_PREFERENCE",
            description="User preference tracking strategy",
            namespaces=["preferences"])
        ```

        ### Custom Strategy with Semantic Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_semantic = aws.bedrock.AgentcoreMemoryStrategy("custom_semantic",
            name="custom-semantic-strategy",
            memory_id=example["id"],
            memory_execution_role_arn=example["memoryExecutionRoleArn"],
            type="CUSTOM",
            description="Custom semantic processing strategy",
            namespaces=["{sessionId}"],
            configuration={
                "type": "SEMANTIC_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Focus on extracting key semantic relationships and concepts",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
                "extraction": {
                    "append_to_prompt": "Extract and categorize semantic information",
                    "model_id": "anthropic.claude-3-haiku-20240307-v1:0",
                },
            })
        ```

        ### Custom Strategy with Summary Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_summary = aws.bedrock.AgentcoreMemoryStrategy("custom_summary",
            name="custom-summary-strategy",
            memory_id=example["id"],
            type="CUSTOM",
            description="Custom summarization strategy",
            namespaces=["summaries"],
            configuration={
                "type": "SUMMARY_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Create concise summaries while preserving key details",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
            })
        ```

        ### Custom Strategy with User Preference Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_user_pref = aws.bedrock.AgentcoreMemoryStrategy("custom_user_pref",
            name="custom-user-preference-strategy",
            memory_id=example["id"],
            type="CUSTOM",
            description="Custom user preference tracking strategy",
            namespaces=["user_prefs"],
            configuration={
                "type": "USER_PREFERENCE_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Consolidate user preferences and behavioral patterns",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
                "extraction": {
                    "append_to_prompt": "Extract user preferences and interaction patterns",
                    "model_id": "anthropic.claude-3-haiku-20240307-v1:0",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Memory Strategy using the `memory_id,strategy_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreMemoryStrategy:AgentcoreMemoryStrategy example MEMORY1234567890,STRATEGY0987654321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreMemoryStrategyConfigurationArgs', 'AgentcoreMemoryStrategyConfigurationArgsDict']] configuration: Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the memory strategy.
        :param pulumi.Input[_builtins.str] memory_id: ID of the memory to associate with this strategy. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] name: Name of the memory strategy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] namespaces: Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] type: Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentcoreMemoryStrategyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Bedrock AgentCore Memory Strategy. Memory strategies define how the agent processes and organizes information within a memory, such as semantic understanding, summarization, or custom processing logic.

        **Important Limitations:**

        - Each memory can have a maximum of 6 strategies total
        - Only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory
        - Multiple `CUSTOM` strategies are allowed (subject to the total limit of 6)

        ## Example Usage

        ### Semantic Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        semantic = aws.bedrock.AgentcoreMemoryStrategy("semantic",
            name="semantic-strategy",
            memory_id=example["id"],
            type="SEMANTIC",
            description="Semantic understanding strategy",
            namespaces=["default"])
        ```

        ### Summarization Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        summary = aws.bedrock.AgentcoreMemoryStrategy("summary",
            name="summary-strategy",
            memory_id=example["id"],
            type="SUMMARIZATION",
            description="Text summarization strategy",
            namespaces=["{sessionId}"])
        ```

        ### User Preference Strategy

        ```python
        import pulumi
        import pulumi_aws as aws

        user_pref = aws.bedrock.AgentcoreMemoryStrategy("user_pref",
            name="user-preference-strategy",
            memory_id=example["id"],
            type="USER_PREFERENCE",
            description="User preference tracking strategy",
            namespaces=["preferences"])
        ```

        ### Custom Strategy with Semantic Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_semantic = aws.bedrock.AgentcoreMemoryStrategy("custom_semantic",
            name="custom-semantic-strategy",
            memory_id=example["id"],
            memory_execution_role_arn=example["memoryExecutionRoleArn"],
            type="CUSTOM",
            description="Custom semantic processing strategy",
            namespaces=["{sessionId}"],
            configuration={
                "type": "SEMANTIC_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Focus on extracting key semantic relationships and concepts",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
                "extraction": {
                    "append_to_prompt": "Extract and categorize semantic information",
                    "model_id": "anthropic.claude-3-haiku-20240307-v1:0",
                },
            })
        ```

        ### Custom Strategy with Summary Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_summary = aws.bedrock.AgentcoreMemoryStrategy("custom_summary",
            name="custom-summary-strategy",
            memory_id=example["id"],
            type="CUSTOM",
            description="Custom summarization strategy",
            namespaces=["summaries"],
            configuration={
                "type": "SUMMARY_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Create concise summaries while preserving key details",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
            })
        ```

        ### Custom Strategy with User Preference Override

        ```python
        import pulumi
        import pulumi_aws as aws

        custom_user_pref = aws.bedrock.AgentcoreMemoryStrategy("custom_user_pref",
            name="custom-user-preference-strategy",
            memory_id=example["id"],
            type="CUSTOM",
            description="Custom user preference tracking strategy",
            namespaces=["user_prefs"],
            configuration={
                "type": "USER_PREFERENCE_OVERRIDE",
                "consolidation": {
                    "append_to_prompt": "Consolidate user preferences and behavioral patterns",
                    "model_id": "anthropic.claude-3-sonnet-20240229-v1:0",
                },
                "extraction": {
                    "append_to_prompt": "Extract user preferences and interaction patterns",
                    "model_id": "anthropic.claude-3-haiku-20240307-v1:0",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock AgentCore Memory Strategy using the `memory_id,strategy_id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentcoreMemoryStrategy:AgentcoreMemoryStrategy example MEMORY1234567890,STRATEGY0987654321
        ```

        :param str resource_name: The name of the resource.
        :param AgentcoreMemoryStrategyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentcoreMemoryStrategyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyConfigurationArgs', 'AgentcoreMemoryStrategyConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyTimeoutsArgs', 'AgentcoreMemoryStrategyTimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentcoreMemoryStrategyArgs.__new__(AgentcoreMemoryStrategyArgs)

            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["memory_execution_role_arn"] = memory_execution_role_arn
            if memory_id is None and not opts.urn:
                raise TypeError("Missing required property 'memory_id'")
            __props__.__dict__["memory_id"] = memory_id
            __props__.__dict__["name"] = name
            if namespaces is None and not opts.urn:
                raise TypeError("Missing required property 'namespaces'")
            __props__.__dict__["namespaces"] = namespaces
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["memory_strategy_id"] = None
        super(AgentcoreMemoryStrategy, __self__).__init__(
            'aws:bedrock/agentcoreMemoryStrategy:AgentcoreMemoryStrategy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyConfigurationArgs', 'AgentcoreMemoryStrategyConfigurationArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            memory_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            memory_id: Optional[pulumi.Input[_builtins.str]] = None,
            memory_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentcoreMemoryStrategyTimeoutsArgs', 'AgentcoreMemoryStrategyTimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentcoreMemoryStrategy':
        """
        Get an existing AgentcoreMemoryStrategy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AgentcoreMemoryStrategyConfigurationArgs', 'AgentcoreMemoryStrategyConfigurationArgsDict']] configuration: Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        :param pulumi.Input[_builtins.str] description: Description of the memory strategy.
        :param pulumi.Input[_builtins.str] memory_id: ID of the memory to associate with this strategy. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] name: Name of the memory strategy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] namespaces: Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] type: Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentcoreMemoryStrategyState.__new__(_AgentcoreMemoryStrategyState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["memory_execution_role_arn"] = memory_execution_role_arn
        __props__.__dict__["memory_id"] = memory_id
        __props__.__dict__["memory_strategy_id"] = memory_strategy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespaces"] = namespaces
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        return AgentcoreMemoryStrategy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.AgentcoreMemoryStrategyConfiguration']]:
        """
        Custom configuration block. Required when `type` is `CUSTOM`, must be omitted for other types. See `configuration` below.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the memory strategy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="memoryExecutionRoleArn")
    def memory_execution_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "memory_execution_role_arn")

    @_builtins.property
    @pulumi.getter(name="memoryId")
    def memory_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the memory to associate with this strategy. Changing this forces a new resource.
        """
        return pulumi.get(self, "memory_id")

    @_builtins.property
    @pulumi.getter(name="memoryStrategyId")
    def memory_strategy_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "memory_strategy_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the memory strategy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Set of namespace identifiers where this strategy applies. Namespaces help organize and scope memory content.

        The following arguments are optional:
        """
        return pulumi.get(self, "namespaces")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentcoreMemoryStrategyTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of memory strategy. Valid values: `SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`, `CUSTOM`. Changing this forces a new resource. Note that only one strategy of each built-in type (`SEMANTIC`, `SUMMARIZATION`, `USER_PREFERENCE`) can exist per memory.
        """
        return pulumi.get(self, "type")

